#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (c) 2021, Cisco Systems
# GNU General Public License v3.0+ (see LICENSE or https://www.gnu.org/licenses/gpl-3.0.txt)

DOCUMENTATION = r"""
---
module: wired_network_devices_id_config_features_intended_layer2_feature
short_description: Resource module for Wired Network Devices Id Config Features Intended Layer2 Feature
description:
  - Manage operations create, update and delete of the resource Wired Network Devices Id Config Features Intended Layer2 Feature.
  - This API creates configurations for an intended feature on a wired device. Once all the updates to intended features are complete, they can be deployed to a
    device using the API /dna/intent/api/v1/networkDevices/{id}/configFeatures/intended/deploy. When the intended features are deployed, they are applied on top
    of the existing configurations on the device. Any existing configurations on the device which are not included in the intended features, are retained on the
    device.
  - This API deletes the configurations for an intended feature on a wired device. Once all the updates to intended features are complete, they can be deployed
    to a device using the API /dna/intent/api/v1/networkDevices/{id}/configFeatures/intended/deploy. When the intended features are deployed, they are applied
    on top of the existing configurations on the device. Any existing configurations on the device which are not included in the intended features, are
    retained on the device.
  - This API updates the configurations for an intended feature on a wired device. Updates to other intended features can be done over several iterations.
    Once all the updates to intended features are complete, they can be deployed to a device using the API
    /dna/intent/api/v1/networkDevices/{id}/configFeatures/intended/deploy. When the intended features are deployed, they are applied on top of the existing
    configurations on the device. Any existing configurations on the device which are not included in the intended features, are retained on the device.
version_added: '6.18.0'
extends_documentation_fragment:
  - cisco.dnac.module
author: Rafael Campos (@racampos)
options:
  cdpGlobalConfig:
    description: Wired Network Devices Id Config Features Intended Layer2 Feature's cdpGlobalConfig.
    type: dict
    suboptions:
      items:
        description: Wired Network Devices Id Config Features Intended Layer2 Feature's items.
        type: list
        elements: dict
        suboptions:
          configType:
            description: Type of network functionality configured for CDP. Config type CDP_GLOBAL is for configuring the global settings for CDP.
            type: str
          holdTime:
            description: Specifies the amount of time a receiving device should hold the information sent by the device before discarding it. Corresponding CLI
              cdp holdtime <10-255>.
            type: int
          isAdvertiseV2Enabled:
            description: Configures CDP to send Version-2 advertisements. The default state is enabled. Corresponding CLI - cdp advertise-v2.
            type: bool
          isCdpEnabled:
            description: Enables or disables CDP on the device. Corresponding CLI - cdp run. Default true.
            type: bool
          isLogDuplexMismatchEnabled:
            description: Configures the reporting of duplex mismatches generated by CDP for all Ethernet interfaces on the device. Corresponding CLI - cdp log
              mismatch. Duplex. Default true.
            type: bool
          timer:
            description: Sets the transmission frequency of CDP updates in seconds. Corresponding CLI - cdp timer <5-254>.
            type: int
  cdpInterfaceConfig:
    description: Wired Network Devices Id Config Features Intended Layer2 Feature's cdpInterfaceConfig.
    type: dict
    suboptions:
      items:
        description: Wired Network Devices Id Config Features Intended Layer2 Feature's items.
        type: list
        elements: dict
        suboptions:
          configType:
            description: Type of network functionality under a feature. Config type CDP_INTERFACE is for configuring CDP on an interface.
            type: str
          interfaceName:
            description: Interface name. The API /dna/intent/api/v1/interface/network-device/{deviceId} can be used to get the list of interfaces on a device.
              Example GigabitEthernet1/0/1.
            type: str
          isCdpEnabled:
            description: Enables or disables CDP on the interface. Corresponding CLI - cdp enable. Default true.
            type: bool
          isLogDuplexMismatchEnabled:
            description: Configures the reporting of duplex mismatches generated by CDP for all Ethernet interfaces on the device. Corresponding CLI - cdp
              log mismatch duplex. Default true.
            type: bool
  dhcpSnoopingGlobalConfig:
    description: Wired Network Devices Id Config Features Intended Layer2 Feature's dhcpSnoopingGlobalConfig.
    type: dict
    suboptions:
      items:
        description: Wired Network Devices Id Config Features Intended Layer2 Feature's items.
        type: list
        elements: dict
        suboptions:
          configType:
            description: Type of network functionality under a feature. Config type DHCP_SNOOPING_GLOBAL is for configuring the global settings for DHCP
              snooping.
            type: str
          databaseAgent:
            description: Wired Network Devices Id Config Features Intended Layer2 Feature's databaseAgent.
            type: dict
            suboptions:
              agentUrl:
                description: Example tftp //192.168.1.100/db_backup Specify the URL for the database agent or the binding file. Corresponding CLI - ip dhcp
                  snooping database .
                type: str
              configType:
                description: Type of network functionality under a feature. Config type DHCP_SNOOPING_DATABASE_AGENT is for configuring DHCP snooping database
                  agent settings on a device.
                type: str
              timeout:
                description: Specify the duration, in seconds, after which a configuration process will be automatically terminated. Corresponding CLI -
                  ip dhcp snooping database timeout <0-86400>.
                type: int
              writeDelay:
                description: WriteDelay.
                type: int
          dhcpSnoopingVlans:
            description: Enable DHCP snooping on VLANs. VLANs can be comma separated and/or a range like '2,4-5,7,10-20'. Corresponding CLI - ip dhcp snooping
              vlan .
            type: str
          isDhcpSnoopingEnabled:
            description: Enable DHCP snooping globally. Corresponding CLI - ip dhcp snooping.default false.
            type: bool
          isGleaningEnabled:
            description: Enable DHCP gleaning which allows components to register and glean only DHCP version 4 packets. Corresponding CLI - ip dhcp snooping
              glean.default false.
            type: bool
          proxyBridgeVlans:
            description: Enable bridge mode on VLANs. VLANs can be comma separated and/or a range like '2,4-5,7,10-20'. Corresponding CLI - ip dhcp snooping
              vlan proxy-bridge.
            type: str
  dhcpSnoopingInterfaceConfig:
    description: Wired Network Devices Id Config Features Intended Layer2 Feature's dhcpSnoopingInterfaceConfig.
    type: dict
    suboptions:
      items:
        description: Wired Network Devices Id Config Features Intended Layer2 Feature's items.
        type: list
        elements: dict
        suboptions:
          configType:
            description: Type of network functionality under a feature. Config type DHCP_SNOOPING_INTERFACE is for configuring DHCP snooping on an interface.
            type: str
          interfaceName:
            description: Interface name. The API /intent/api/v1/interface/network-device/{deviceId} can be used to get the list of interfaces on a
              device.example GigabitEthernet1/0/1.
            type: str
          isTrustedInterface:
            description: Enable Trusted Interface. Corresponding CLI - ip dhcp snooping trust.
            type: bool
          messageRateLimit:
            description: Limit the number of DHCP packets a port can send or receive in a second. This is a protective measure to prevent a single device from
              overwhelming the DHCP server. Increase the rate limit on trunk ports carrying more than one VLAN. By default, rate limit is disabled. The
              recommended value is <= 100. Set the rate-limit as 0 to disable it. Corresponding CLI - ip dhcp snooping limit rate <1-2048>.
            type: int
  dot1xGlobalConfig:
    description: Wired Network Devices Id Config Features Intended Layer2 Feature's dot1xGlobalConfig.
    type: dict
    suboptions:
      items:
        description: Wired Network Devices Id Config Features Intended Layer2 Feature's items.
        type: list
        elements: dict
        suboptions:
          authenticationConfigMode:
            description: ReadOnly attribute. Identity-Based Networking Services features are configured in the Cisco common classification policy language
              (C3PL) display mode. The legacy authentication manager mode is enabled by default. Use this command in EXEC mode to display the current
              configuration mode. Corresponding CLI - authentication display config-mode. LEGACY - Legacy configuration mode. NEW_STYLE - Identity-Based
              Networking Services (IBNS) configuration mode.
            type: str
          configType:
            description: Type of network functionality under a feature. Config type DOT1X_GLOBAL is for global 802.1x settings on a device.
            type: str
          isDot1xEnabled:
            description: Globally enable 802.1x authentication on Switch. Corresponding CLI - dot1x system-auth-control. Default false.
            type: bool
  dot1xInterfaceConfig:
    description: Wired Network Devices Id Config Features Intended Layer2 Feature's dot1xInterfaceConfig.
    type: dict
    suboptions:
      items:
        description: Wired Network Devices Id Config Features Intended Layer2 Feature's items.
        type: list
        elements: dict
        suboptions:
          authenticationOrder:
            description: Wired Network Devices Id Config Features Intended Layer2 Feature's authenticationOrder.
            type: dict
            suboptions:
              configType:
                description: ConfigType.
                type: str
              items:
                description: Array of Enums. DOT1X, MAB, WEBAUTH.
                type: list
                elements: str
          configType:
            description: Type of network functionality under a feature. Config type DOT1X_INTERFACE is for configuring 802.1x on an interface.
            type: str
          interfaceName:
            description: Interface name. The API /intent/api/v1/interface/network-device/{deviceId} can be used to get the list of interfaces on a
              device.example GigabitEthernet1/0/1.
            type: str
  feature:
    description: Feature path parameter. Name of the feature to delete.
    type: str
  id:
    description: Id path parameter. Network device ID of the wired device to configure.
    type: str
  igmpSnoopingGlobalConfig:
    description: Wired Network Devices Id Config Features Intended Layer2 Feature's igmpSnoopingGlobalConfig.
    type: dict
    suboptions:
      items:
        description: Wired Network Devices Id Config Features Intended Layer2 Feature's items.
        type: list
        elements: dict
        suboptions:
          configType:
            description: Type of network functionality under a feature. Config type IGMP_SNOOPING_GLOBAL is for configuring global IGMP snooping settings on a
              device.
            type: str
          igmpSnoopingVlanSettings:
            description: Wired Network Devices Id Config Features Intended Layer2 Feature's igmpSnoopingVlanSettings.
            type: dict
            suboptions:
              configType:
                description: ConfigType.
                type: str
              items:
                description: Wired Network Devices Id Config Features Intended Layer2 Feature's items.
                type: list
                elements: dict
                suboptions:
                  configType:
                    description: Type of network functionality under a feature. Config type IGMP_SNOOPING_VLAN is for configuring IGMP snooping per VLAN.
                    type: str
                  igmpSnoopingVlanMrouters:
                    description: Wired Network Devices Id Config Features Intended Layer2 Feature's igmpSnoopingVlanMrouters.
                    type: dict
                    suboptions:
                      configType:
                        description: Type of IGMP Snooping Mrouter Settings.
                        type: str
                      items:
                        description: Wired Network Devices Id Config Features Intended Layer2 Feature's items.
                        type: list
                        elements: dict
                        suboptions:
                          configType:
                            description: Type of network functionality under a feature. Config type IGMP_SNOOPING_VLAN_MROUTER is for configuring IGMP snooping
                              mrouter per VLAN.
                            type: str
                          interfaceName:
                            description: Mrouter interface name. The API /dna/intent/api/v1/interface/network-dev... can be used to get the list of interfaces
                              on a device.example GigabitEthernet1/0/2.
                            type: str
                  isIgmpSnoopingEnabled:
                    description: Enable IGMP Snooping for a VLAN. Corresponding CLI - ip igmp snooping vlan <1-4094>.
                    type: bool
                  isImmediateLeaveEnabled:
                    description: Enable immediate leave processing for IGMPv2. Corresponding CLI - ip igmp snooping vlan <vlan-id> immediate-leave.default
                      false.
                    type: bool
                  isQuerierEnabled:
                    description: Enable IGMP querier for this VLAN. Corresponding CLI - ip igmp snooping vlan <vlan-id> querier.
                    type: bool
                  querierAddress:
                    description: IGMP querier source IP address. Corresponding CLI - ip igmp snooping vlan <vlan-id> querier address <ip-address>.
                    type: str
                  querierQueryInterval:
                    description: Set the IGMP querier query interval (in seconds). Corresponding CLI - ip igmp snooping vlan <vlan-id> querier query-interval
                      <1-18000>.
                    type: int
                  querierVersion:
                    description: The switch supports IGMP version 1, IGMP version 2, and IGMP version 3. These versions are interoperable on the switch.
                      For example, if IGMP snooping is enabled and the querier's version is IGMPv2, and the switch receives an IGMPv3 report from a host, then
                      the switch can forward the IGMPv3 report to the multicast router. Corresponding CLI - ip igmp snooping querier version <1-3>. IGMP
                      version 1 provides the basic query-response mechanism that allows the multicast device to determine which multicast groups are active and
                      other processes that enable hosts to join and leave a multicast group. IGMP version 2 extends IGMP functionality by providing such
                      features as the IGMP leave process to reduce leave latency, group-specific queries, and an explicit maximum query response time.
                      IGMPv2 also adds the capability for routers to elect the IGMP querier without depending on the multicast protocol to perform this task.
                      An IGMP version 3 switch supports Basic IGMPv3SnoopingSupport (BISS), which includes support for the snooping features on IGMPv1
                      and IGMPv2 switches and for IGMPv3 membership report messages. BISS constrains the flooding of multicast traffic when your network
                      includes IGMPv3 hosts. It constrains traffic to approximately the same set of ports as the IGMP snooping feature on IGMPv2 or IGMPv
                      hosts. An IGMPv3 switch can receive messages from and forward messages to a device running theSourceSpecific Multicast (SSM) feature.
                    type: str
                  vlanId:
                    description: VLAN ID.
                    type: int
          isIgmpSnoopingEnabled:
            description: Enable global IGMP Snooping. Corresponding CLI - ip igmp snooping.default true.
            type: bool
          isQuerierEnabled:
            description: Enable IGMP Snooping Querier. Corresponding CLI - ip igmp snooping querier.default false.
            type: bool
          querierAddress:
            description: Configure IGMP querier source IP address. Corresponding CLI - ip igmp snooping querier address <ip-address>.
            type: str
          querierQueryInterval:
            description: Set the IGMP querier query interval (in seconds). Corresponding CLI - ip igmp snooping querier query-interval <1-18000>.
            type: int
          querierVersion:
            description: The switch supports IGMP version 1, IGMP version 2, and IGMP version 3. These versions are interoperable on the switch. For example,
              if IGMP snooping is enabled and the querier's version is IGMPv2, and the switch receives an IGMPv3 report from a host, then the switch can
              forward the IGMPv3 report to the multicast router. Corresponding CLI - ip igmp snooping querier version <1-3>. IGMP version 1 provides the basic
              query-response mechanism that allows the multicast device to determine which multicast groups are active and other processes that enable hosts to
              join and leave a multicast group. IGMP version 2 extends IGMP functionality by providing such features as the IGMP leave process to reduce leave
              latency, group-specific queries, and an explicit maximum query response time. IGMPv2 also adds the capability for routers to elect the IGMP
              querier without depending on the multicast protocol to perform this task. An IGMP version 3 switch supports Basic IGMPv3SnoopingSupport (BISS),
              which includes support for the snooping features on IGMPv1 and IGMPv2 switches and for IGMPv3 membership report messages. BISS constrains the
              flooding of multicast traffic when your network includes IGMPv3 hosts. It constrains traffic to approximately the same set of ports as the IGMP
              snooping feature on IGMPv2 or IGMPv1 hosts. An IGMPv3 switch can receive messages from and forward messages to a device running theSourceSpecific
              Multicast (SSM) feature.
            type: str
  lldpGlobalConfig:
    description: Wired Network Devices Id Config Features Intended Layer2 Feature's lldpGlobalConfig.
    type: dict
    suboptions:
      items:
        description: Wired Network Devices Id Config Features Intended Layer2 Feature's items.
        type: list
        elements: dict
        suboptions:
          configType:
            description: Type of network functionality configured for LLDP. Config type LLDP_GLOBAL is for configuring the global settings for LLDP.
            type: str
          holdTime:
            description: Specifies the amount of time a receiving device should hold the information sent by the device before discarding it. Corresponding
              CLI - lldp holdtime $holdTime <0-32767>.
            type: int
          isLldpEnabled:
            description: Enables or disables LLDP on the device. Corresponding CLI - lldp run. Default true.
            type: bool
          reinitializationDelay:
            description: Specifies the delay time in seconds for LLDP to initialize on any interface. Corresponding CLI - lldp reinit <2-5>.
            type: int
          timer:
            description: Sets the transmission frequency of LLDP updates in seconds. Corresponding CLI - lldp timer <5-32767>.
            type: int
  lldpInterfaceConfig:
    description: Wired Network Devices Id Config Features Intended Layer2 Feature's lldpInterfaceConfig.
    type: dict
    suboptions:
      items:
        description: Wired Network Devices Id Config Features Intended Layer2 Feature's items.
        type: list
        elements: dict
        suboptions:
          adminStatus:
            description: Configure the interface to transmit and receive LLDP packets, or disable LLDP on the interface. TRANSMIT_ONLY - Configure the
              interface to transmit LLDP packets only. Corresponding CLI - lldp transmit. RECEIVE_ONLY - Configure the interface to receive LLDP packets
              only. Corresponding CLI - lldp receive. TRANSMIT_AND_RECEIVE - Configure the interface to both transmit and receive LLDP packets. Corresponding
              CLI - lldp receive; lldp transmit. DISABLED - Disable LLDP functionality on the device, preventing both transmission and reception of LLDP
              packets.
            type: str
          configType:
            description: Type of network functionality under a feature. Config type LLDP_INTERFACE is for configuring LLDP on an interface.
            type: str
          interfaceName:
            description: Interface name. The API /intent/api/v1/interface/network-device/{deviceId} can be used to get the list of interfaces on a
              device. Example GigabitEthernet1/0/1.
            type: str
  mabInterfaceConfig:
    description: Wired Network Devices Id Config Features Intended Layer2 Feature's mabInterfaceConfig.
    type: dict
    suboptions:
      items:
        description: Wired Network Devices Id Config Features Intended Layer2 Feature's items.
        type: list
        elements: dict
        suboptions:
          configType:
            description: Type of network functionality under a feature. Config type MAB_INTERFACE is for configuring MAB on an
              interface.
            type: str
          interfaceName:
            description: Interface name. The API /intent/api/v1/interface/network-device/{deviceId} can be used to get the list of interfaces on a device.
            type: str
          isMabEnabled:
            description: Enable MAC-based authentication on a port. Corresponding CLI - mab. Default false.
            type: bool
  mldSnoopingGlobalConfig:
    description: Wired Network Devices Id Config Features Intended Layer2 Feature's mldSnoopingGlobalConfig.
    type: dict
    suboptions:
      items:
        description: Wired Network Devices Id Config Features Intended Layer2 Feature's items.
        type: list
        elements: dict
        suboptions:
          configType:
            description: Type of network functionality under a feature. Config type MLD_SNOOPING_GLOBAL is for configuring MLD snooping settings on a device.
            type: str
          isMldSnoopingEnabled:
            description: Enable global MLD Snooping. Corresponding CLI - ipv6 mld snooping.default false.
            type: bool
          isQuerierEnabled:
            description: Enable MLD Snooping Querier. Corresponding CLI - ipv6 mld snooping querier.default false.
            type: bool
          isSuppressListenerMessagesEnabled:
            description: When Listener Message Suppression is enabled, the switch forwards only a single MLD report per multicast router query. Corresponding
              CLI - ipv6 mld snooping listener-message-suppression.default true.
            type: bool
          mldSnoopingVlanSettings:
            description: Wired Network Devices Id Config Features Intended Layer2 Feature's mldSnoopingVlanSettings.
            type: dict
            suboptions:
              configType:
                description: Type of MLD Snooping VLAN Settings.
                type: str
              items:
                description: Wired Network Devices Id Config Features Intended Layer2 Feature's items.
                type: list
                elements: dict
                suboptions:
                  configType:
                    description: Type of network functionality under a feature. Config type MLD_SNOOPING_VLAN is for configuring MLD snooping per VLAN.
                    type: str
                  isImmediateLeaveEnabled:
                    description: Enable immediate leave processing for MLDv1. Corresponding CLI - ipv6 mld snooping vlan <vlan-id> immediate-leave.default
                      false.
                    type: bool
                  isMldSnoopingEnabled:
                    description: Enable MLD Snooping for a VLAN. Corresponding CLI - ipv6 mld snooping vlan <1-4094>.
                    type: bool
                  isQuerierEnabled:
                    description: Enable MLD querier for this VLAN. Corresponding CLI - ipv6 mld snooping vlan <vlan-id> querier.
                    type: bool
                  mldSnoopingVlanMrouters:
                    description: Wired Network Devices Id Config Features Intended Layer2 Feature's mldSnoopingVlanMrouters.
                    type: dict
                    suboptions:
                      configType:
                        description: Type of MLD Snooping Mrouter Settings.
                        type: str
                      items:
                        description: Wired Network Devices Id Config Features Intended Layer2 Feature's items.
                        type: list
                        elements: dict
                        suboptions:
                          configType:
                            description: Type of network functionality under a feature. Config type MLD_SNOOPING_VLAN_MROUTER is for configuring MLD snooping
                              mrouter per VLAN.
                            type: str
                          interfaceName:
                            description: Mrouter interface name. The API /dna/intent/api/v1/interface/network-dev... can be used to get the list of interfaces
                              on a device.example GigabitEthernet1/0/2.
                            type: str
                  querierAddress:
                    description: MLD querier source IP address. Corresponding CLI - ipv6 mld snooping vlan <vlan-id> querier address <source-ipv6-address>.
                    type: str
                  querierQueryInterval:
                    description: Set the MLD querier query interval (in seconds). Corresponding CLI - ipv6 mld snooping vlan <vlan-id> querier query-interval
                      <1-18000>.
                    type: int
                  querierVersion:
                    description: Configure MLD version. Corresponding CLI - ipv6 mld snooping vlan <vlan-id> querier version <1-2> VERSION_1 - MLDv1 snooping
                      detects MLDv1 control packets and sets up traffic bridging based on IPv6 destination multicast addresses. MLDv1 supports three types of
                      messages - Listener Queries, Multicast Listener Reports, Multicast Listener Done. VERSION_2 - MLDv2 basic snooping (MBSS) uses MLDv2
                      control packets to set up traffic forwarding based on IPv6 destination multicast addresses. MLDv2 supports MLDv2 queries and reports, as
                      well as MLDv1 Report and Done messages.
                    type: str
                  vlanId:
                    description: VLAN ID.
                    type: int
          querierAddress:
            description: MLD querier source IP address. Corresponding CLI - ipv6 mld snooping querier address <source-ipv6-address>.
            type: str
          querierQueryInterval:
            description: Set the MLD querier query interval (in seconds). Corresponding CLI - ipv6 mld snooping querier query-interval <1-18000>.
            type: int
          querierVersion:
            description: Configure the MLD version. Corresponding CLI - ipv6 mld snooping querier version <1-2> VERSION_1 - MLDv1 snooping detects MLDv1
              control packets and sets up traffic bridging based on IPv6 destination multicast addresses. MLDv1 supports three types of messages -
              Listener Queries, Multicast Listener Reports, Multicast Listener Done. VERSION_2 - MLDv2 basic snooping (MBSS) uses MLDv2 control packets to set
              up traffic forwarding based on IPv6 destination multicast addresses. MLDv2 supports MLDv2 queries and reports, as well as MLDv1 Report and Done
              messages.
            type: str
requirements:
- dnacentersdk >= 2.4.9
- python >= 3.5
seealso:
- name: Cisco DNA Center documentation for Wired CreateConfigurationsForAnIntendedLayer2FeatureOnAWiredDevice
  description: Complete reference of the CreateConfigurationsForAnIntendedLayer2FeatureOnAWiredDevice API.
  link: https://developer.cisco.com/docs/dna-center/#!create-configurations-for-an-intended-layer-2-feature-on-a-wired-device
- name: Cisco DNA Center documentation for Wired DeleteConfigurationsForAnIntendedLayer2FeatureOnAWiredDevice
  description: Complete reference of the DeleteConfigurationsForAnIntendedLayer2FeatureOnAWiredDevice API.
  link: https://developer.cisco.com/docs/dna-center/#!delete-configurations-for-an-intended-layer-2-feature-on-a-wired-device
- name: Cisco DNA Center documentation for Wired UpdateConfigurationsForAnIntendedLayer2FeatureOnAWiredDevice
  description: Complete reference of the UpdateConfigurationsForAnIntendedLayer2FeatureOnAWiredDevice API.
  link: https://developer.cisco.com/docs/dna-center/#!update-configurations-for-an-intended-layer-2-feature-on-a-wired-device
notes:
- SDK Method used are wired.Wired.create_configurations_for_an_intended_layer2_feature_on_a_wired_device,
  wired.Wired.delete_configurations_for_an_intended_layer2_feature_on_a_wired_device,
  wired.Wired.update_configurations_for_an_intended_layer2_feature_on_a_wired_device,
- Paths used are post /dna/intent/api/v1/wired/networkDevices/{id}/configFeatures/intended/layer2/{feature},
  delete /dna/intent/api/v1/wired/networkDevices/{id}/configFeatures/intended/layer2/{feature},
  put /dna/intent/api/v1/wired/networkDevices/{id}/configFeatures/intended/layer2/{feature},
"""

EXAMPLES = r"""
---
- name: Delete by id
  cisco.dnac.wired_network_devices_id_config_features_intended_layer2_feature:
    dnac_host: "{{dnac_host}}"
    dnac_username: "{{dnac_username}}"
    dnac_password: "{{dnac_password}}"
    dnac_verify: "{{dnac_verify}}"
    dnac_port: "{{dnac_port}}"
    dnac_version: "{{dnac_version}}"
    dnac_debug: "{{dnac_debug}}"
    state: absent
    feature: string
    id: string
- name: Update by id
  cisco.dnac.wired_network_devices_id_config_features_intended_layer2_feature:
    dnac_host: "{{dnac_host}}"
    dnac_username: "{{dnac_username}}"
    dnac_password: "{{dnac_password}}"
    dnac_verify: "{{dnac_verify}}"
    dnac_port: "{{dnac_port}}"
    dnac_version: "{{dnac_version}}"
    dnac_debug: "{{dnac_debug}}"
    state: present
    cdpGlobalConfig:
      items:
        - - configType: string
            holdTime: 0
            isAdvertiseV2Enabled: true
            isCdpEnabled: true
            isLogDuplexMismatchEnabled: true
            timer: 0
    cdpInterfaceConfig:
      items:
        - - configType: string
            interfaceName: string
            isCdpEnabled: true
            isLogDuplexMismatchEnabled: true
    dhcpSnoopingGlobalConfig:
      items:
        - - configType: string
            databaseAgent:
              agentUrl: string
              configType: string
              timeout: 0
              writeDelay: 0
            dhcpSnoopingVlans: string
            isDhcpSnoopingEnabled: true
            isGleaningEnabled: true
            proxyBridgeVlans: string
    dhcpSnoopingInterfaceConfig:
      items:
        - - configType: string
            interfaceName: string
            isTrustedInterface: true
            messageRateLimit: 0
    dot1xGlobalConfig:
      items:
        - - authenticationConfigMode: string
            configType: string
            isDot1xEnabled: true
    dot1xInterfaceConfig:
      items:
        - - authenticationOrder:
              configType: string
              items:
                - string
            configType: string
            interfaceName: string
    feature: string
    id: string
    igmpSnoopingGlobalConfig:
      items:
        - - configType: string
            igmpSnoopingVlanSettings:
              configType: string
              items:
                - configType: string
                  igmpSnoopingVlanMrouters:
                    configType: string
                    items:
                      - configType: string
                        interfaceName: string
                  isIgmpSnoopingEnabled: true
                  isImmediateLeaveEnabled: true
                  isQuerierEnabled: true
                  querierAddress: string
                  querierQueryInterval: 0
                  querierVersion: string
                  vlanId: 0
            isIgmpSnoopingEnabled: true
            isQuerierEnabled: true
            querierAddress: string
            querierQueryInterval: 0
            querierVersion: string
    lldpGlobalConfig:
      items:
        - - configType: string
            holdTime: 0
            isLldpEnabled: true
            reinitializationDelay: 0
            timer: 0
    lldpInterfaceConfig:
      items:
        - - adminStatus: string
            configType: string
            interfaceName: string
    mabInterfaceConfig:
      items:
        - - configType: string
            interfaceName: string
            isMabEnabled: true
    mldSnoopingGlobalConfig:
      items:
        - - configType: string
            isMldSnoopingEnabled: true
            isQuerierEnabled: true
            isSuppressListenerMessagesEnabled: true
            mldSnoopingVlanSettings:
              configType: string
              items:
                - configType: string
                  isImmediateLeaveEnabled: true
                  isMldSnoopingEnabled: true
                  isQuerierEnabled: true
                  mldSnoopingVlanMrouters:
                    configType: string
                    items:
                      - configType: string
                        interfaceName: string
                  querierAddress: string
                  querierQueryInterval: 0
                  querierVersion: string
                  vlanId: 0
            querierAddress: string
            querierQueryInterval: 0
            querierVersion: string
    portChannelConfig:
      items:
        - - configType: string
            isAutoEnabled: true
            lacpSystemPriority: 0
            loadBalancingMethod: string
            portchannels:
              configType: string
              items:
                - AnyOf:
                    EtherchannelConfig:
                      configType: string
                      memberPorts:
                        configType: string
                        items:
                          - configType: string
                            interfaceName: string
                            mode: string
                      minLinks: 0
                      name: string
                    LacpPortchannelConfig:
                      configType: string
                      memberPorts:
                        configType: string
                        items:
                          - configType: string
                            interfaceName: string
                            mode: string
                            portPriority: 0
                            rate: 0
                      minLinks: 0
                      name: string
                    PagpPortchannelConfig:
                      configType: string
                      memberPorts:
                        configType: string
                        items:
                          - configType: string
                            interfaceName: string
                            learnMethod: string
                            mode: string
                            portPriority: 0
                      minLinks: 0
                      name: string
    stpGlobalConfig:
      items:
        - - configType: string
            isBackboneFastEnabled: true
            isBpduFilterEnabled: true
            isBpduGuardEnabled: true
            isEtherChannelGuardEnabled: true
            isExtendedSystemIdEnabled: true
            isLoggingEnabled: true
            isLoopGuardEnabled: true
            isUplinkFastEnabled: true
            portFastMode: string
            stpInstances:
              configType: string
              items:
                - configType: string
                  priority: 0
                  timers:
                    configType: string
                    forwardDelay: 0
                    helloInterval: 0
                    isStpEnabled: true
                    maxAge: 0
                  vlanId: 0
            stpMode: string
            transmitHoldCount: 0
            uplinkFastMaxUpdateRate: 0
    stpInterfaceConfig:
      items:
        - bpduFilter: string
          bpduGuard: string
          configType: string
          guardMode: string
          interfaceName: string
          pathCost: 0
          portFastMode: string
          portVlanCostSettings:
            configType: string
            items:
              - configType: string
                cost: 0
                vlans: string
          portVlanPrioritySettings:
            configType: string
            items:
              - configType: string
                priority: 0
                vlans: string
          priority: 0
    switchportInterfaceConfig:
      items:
        - - accessVlan: 0
            adminStatus: string
            configType: string
            description: string
            interfaceName: string
            mode: string
            nativeVlan: 0
            trunkAllowedVlans: string
            voiceVlan: 0
    trunkInterfaceConfig:
      items:
        - - configType: string
            interfaceName: string
            isDtpNegotiationEnabled: true
            isProtected: true
            pruneEligibleVlans: string
    vlanConfig:
      items:
        - - configType: string
            isVlanEnabled: true
            name: string
            vlanId: 0
    vtpGlobalConfig:
      items:
        - - configType: string
            configurationFileName: string
            domainName: string
            isPruningEnabled: true
            mode: string
            sourceInterface: string
            version: string
    vtpInterfaceConfig:
      items:
        - - configType: string
            interfaceName: string
            isVtpEnabled: true
- name: Create
  cisco.dnac.wired_network_devices_id_config_features_intended_layer2_feature:
    dnac_host: "{{dnac_host}}"
    dnac_username: "{{dnac_username}}"
    dnac_password: "{{dnac_password}}"
    dnac_verify: "{{dnac_verify}}"
    dnac_port: "{{dnac_port}}"
    dnac_version: "{{dnac_version}}"
    dnac_debug: "{{dnac_debug}}"
    state: present
    cdpGlobalConfig:
      items:
        - - configType: string
            holdTime: 0
            isAdvertiseV2Enabled: true
            isCdpEnabled: true
            isLogDuplexMismatchEnabled: true
            timer: 0
    cdpInterfaceConfig:
      items:
        - - configType: string
            interfaceName: string
            isCdpEnabled: true
            isLogDuplexMismatchEnabled: true
    dhcpSnoopingGlobalConfig:
      items:
        - - configType: string
            databaseAgent:
              agentUrl: string
              configType: string
              timeout: 0
              writeDelay: 0
            dhcpSnoopingVlans: string
            isDhcpSnoopingEnabled: true
            isGleaningEnabled: true
            proxyBridgeVlans: string
    dhcpSnoopingInterfaceConfig:
      items:
        - - configType: string
            interfaceName: string
            isTrustedInterface: true
            messageRateLimit: 0
    dot1xGlobalConfig:
      items:
        - - authenticationConfigMode: string
            configType: string
            isDot1xEnabled: true
    dot1xInterfaceConfig:
      items:
        - - authenticationOrder:
              configType: string
              items:
                - string
            configType: string
            interfaceName: string
    feature: string
    id: string
    igmpSnoopingGlobalConfig:
      items:
        - - configType: string
            igmpSnoopingVlanSettings:
              configType: string
              items:
                - configType: string
                  igmpSnoopingVlanMrouters:
                    configType: string
                    items:
                      - configType: string
                        interfaceName: string
                  isIgmpSnoopingEnabled: true
                  isImmediateLeaveEnabled: true
                  isQuerierEnabled: true
                  querierAddress: string
                  querierQueryInterval: 0
                  querierVersion: string
                  vlanId: 0
            isIgmpSnoopingEnabled: true
            isQuerierEnabled: true
            querierAddress: string
            querierQueryInterval: 0
            querierVersion: string
    lldpGlobalConfig:
      items:
        - - configType: string
            holdTime: 0
            isLldpEnabled: true
            reinitializationDelay: 0
            timer: 0
    lldpInterfaceConfig:
      items:
        - - adminStatus: string
            configType: string
            interfaceName: string
    mabInterfaceConfig:
      items:
        - - configType: string
            interfaceName: string
            isMabEnabled: true
    mldSnoopingGlobalConfig:
      items:
        - - configType: string
            isMldSnoopingEnabled: true
            isQuerierEnabled: true
            isSuppressListenerMessagesEnabled: true
            mldSnoopingVlanSettings:
              configType: string
              items:
                - configType: string
                  isImmediateLeaveEnabled: true
                  isMldSnoopingEnabled: true
                  isQuerierEnabled: true
                  mldSnoopingVlanMrouters:
                    configType: string
                    items:
                      - configType: string
                        interfaceName: string
                  querierAddress: string
                  querierQueryInterval: 0
                  querierVersion: string
                  vlanId: 0
            querierAddress: string
            querierQueryInterval: 0
            querierVersion: string
    portChannelConfig:
      items:
        - - configType: string
            isAutoEnabled: true
            lacpSystemPriority: 0
            loadBalancingMethod: string
            portchannels:
              configType: string
              items:
                - AnyOf:
                    EtherchannelConfig:
                      configType: string
                      memberPorts:
                        configType: string
                        items:
                          - configType: string
                            interfaceName: string
                            mode: string
                      minLinks: 0
                      name: string
                    LacpPortchannelConfig:
                      configType: string
                      memberPorts:
                        configType: string
                        items:
                          - configType: string
                            interfaceName: string
                            mode: string
                            portPriority: 0
                            rate: 0
                      minLinks: 0
                      name: string
                    PagpPortchannelConfig:
                      configType: string
                      memberPorts:
                        configType: string
                        items:
                          - configType: string
                            interfaceName: string
                            learnMethod: string
                            mode: string
                            portPriority: 0
                      minLinks: 0
                      name: string
    stpGlobalConfig:
      items:
        - - configType: string
            isBackboneFastEnabled: true
            isBpduFilterEnabled: true
            isBpduGuardEnabled: true
            isEtherChannelGuardEnabled: true
            isExtendedSystemIdEnabled: true
            isLoggingEnabled: true
            isLoopGuardEnabled: true
            isUplinkFastEnabled: true
            portFastMode: string
            stpInstances:
              configType: string
              items:
                - configType: string
                  priority: 0
                  timers:
                    configType: string
                    forwardDelay: 0
                    helloInterval: 0
                    isStpEnabled: true
                    maxAge: 0
                  vlanId: 0
            stpMode: string
            transmitHoldCount: 0
            uplinkFastMaxUpdateRate: 0
    stpInterfaceConfig:
      items:
        - bpduFilter: string
          bpduGuard: string
          configType: string
          guardMode: string
          interfaceName: string
          pathCost: 0
          portFastMode: string
          portVlanCostSettings:
            configType: string
            items:
              - configType: string
                cost: 0
                vlans: string
          portVlanPrioritySettings:
            configType: string
            items:
              - configType: string
                priority: 0
                vlans: string
          priority: 0
    switchportInterfaceConfig:
      items:
        - - accessVlan: 0
            adminStatus: string
            configType: string
            description: string
            interfaceName: string
            mode: string
            nativeVlan: 0
            trunkAllowedVlans: string
            voiceVlan: 0
    trunkInterfaceConfig:
      items:
        - - configType: string
            interfaceName: string
            isDtpNegotiationEnabled: true
            isProtected: true
            pruneEligibleVlans: string
    vlanConfig:
      items:
        - - configType: string
            isVlanEnabled: true
            name: string
            vlanId: 0
    vtpGlobalConfig:
      items:
        - - configType: string
            configurationFileName: string
            domainName: string
            isPruningEnabled: true
            mode: string
            sourceInterface: string
            version: string
    vtpInterfaceConfig:
      items:
        - - configType: string
            interfaceName: string
            isVtpEnabled: true
"""
RETURN = r"""
dnac_response:
  description: A dictionary or list with the response returned by the Cisco DNAC Python SDK
  returned: always
  type: dict
  sample: >
    {
      "response": {
        "taskId": "string",
        "url": "string"
      },
      "version": "string"
    }
"""
