/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.ObjectNormalizer;
import com.intellij.database.datagrid.ObjectNormalizerProvider;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DefaultValuesExtractor;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.FormatBasedExtractor;
import com.intellij.database.util.Out;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DumpRequestDelegate
implements DataConsumer {
    private static final Logger LOG = Logger.getInstance(DumpRequestDelegate.class);
    private final int myResultSetNumber;
    private final String myQuery;
    private final ProgressIndicator myProgressIndicator;
    private final String myName;
    private final ExtractionConfig myConfig;
    private final Consumer<Integer> myAddRowCount;
    private final DataExtractor myExtractor;
    private final Out myOut;
    private final ModelIndexSet<GridColumn> mySelectedColumns;
    private int myFirstRowNum;
    protected GridColumn[] myColumns;
    private DataExtractor.Extraction myExtraction;

    public DumpRequestDelegate(int resultSetNumber, @NotNull String query, @Nullable ModelIndexSet<GridColumn> columns, @NotNull DataExtractor extractor, @NotNull Out out, @Nullable String name, @NotNull ExtractionConfig config, @NotNull Consumer<Integer> addRowCount) {
        if (query == null) {
            DumpRequestDelegate.$$$reportNull$$$0(0);
        }
        if (extractor == null) {
            DumpRequestDelegate.$$$reportNull$$$0(1);
        }
        if (out == null) {
            DumpRequestDelegate.$$$reportNull$$$0(2);
        }
        if (config == null) {
            DumpRequestDelegate.$$$reportNull$$$0(3);
        }
        if (addRowCount == null) {
            DumpRequestDelegate.$$$reportNull$$$0(4);
        }
        this.myResultSetNumber = resultSetNumber;
        this.myQuery = query;
        this.myProgressIndicator = (ProgressIndicator)ObjectUtils.chooseNotNull((Object)ProgressManager.getInstance().getProgressIndicator(), (Object)new EmptyProgressIndicator());
        this.mySelectedColumns = columns;
        this.myExtractor = extractor;
        this.myOut = out;
        this.myName = name;
        this.myConfig = config;
        this.myAddRowCount = addRowCount;
    }

    public void setColumns(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull GridDataRequest.Context context, int subQueryIndex, int resultSetIndex, GridColumn @NotNull [] columns, int firstRowNum) {
        if (context == null) {
            DumpRequestDelegate.$$$reportNull$$$0(5);
        }
        if (columns == null) {
            DumpRequestDelegate.$$$reportNull$$$0(6);
        }
        LOG.assertTrue(resultSetIndex == this.myResultSetNumber);
        this.myColumns = columns;
        this.myFirstRowNum = firstRowNum;
        this.myProgressIndicator.setText(this.getSavingText());
    }

    @NlsContexts.ProgressText
    @NotNull
    private String getSavingText() {
        String string = DataGridBundle.message((String)"progress.text.saving.choice", (Object[])new Object[]{this.myName, this.myName == null ? 0 : 1});
        if (string == null) {
            DumpRequestDelegate.$$$reportNull$$$0(7);
        }
        return string;
    }

    public void updateColumns(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull GridDataRequest.Context context, GridColumn @NotNull [] columns) {
        if (context == null) {
            DumpRequestDelegate.$$$reportNull$$$0(8);
        }
        if (columns == null) {
            DumpRequestDelegate.$$$reportNull$$$0(9);
        }
        if (this.myExtraction == null) {
            this.myColumns = columns;
        } else {
            this.myExtraction.updateColumns(columns);
        }
    }

    public void addRows(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull GridDataRequest.Context context, @NotNull List<? extends GridRow> rows) {
        if (rows == null) {
            DumpRequestDelegate.$$$reportNull$$$0(10);
        }
        if (context == null) {
            DumpRequestDelegate.$$$reportNull$$$0(11);
        }
        if (this.myExtraction == null) {
            this.myExtraction = this.startExtraction();
        }
        this.myProgressIndicator.checkCanceled();
        if (rows.isEmpty()) {
            return;
        }
        ObjectNormalizer.convertRows((ObjectNormalizer)((ObjectNormalizer)ObjectNormalizerProvider.getCache().fun((Object)context)), rows, Arrays.stream(this.myColumns).toList());
        int maxRow = rows.get(rows.size() - 1).getRowNum();
        if (rows.get(0).getRowNum() > this.myFirstRowNum && this.myExtractor instanceof DefaultValuesExtractor && !(this.myExtractor instanceof FormatBasedExtractor)) {
            this.myOut.appendText((CharSequence)((DefaultValuesExtractor)this.myExtractor).getLineSeparator());
        }
        this.myExtraction.addData(rows);
        String bytesLoadedMessagePart = " / " + StringUtil.formatFileSize((long)this.myOut.sizeInBytes()) + DataGridBundle.message((String)"progress.text.rows.chars.loaded", (Object[])new Object[0]);
        this.myProgressIndicator.setText(DataGridBundle.message((String)"progress.text.rows", (Object[])new Object[]{this.getSavingText(), maxRow, bytesLoadedMessagePart}));
        this.myAddRowCount.accept(rows.size());
    }

    public void afterLastRowAdded(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull GridDataRequest.Context context, int total) {
        if (context == null) {
            DumpRequestDelegate.$$$reportNull$$$0(12);
        }
        if (this.myExtraction == null) {
            this.myExtraction = this.startExtraction();
        }
        this.myExtraction.complete();
    }

    @NotNull
    private DataExtractor.Extraction startExtraction() {
        int[] selectedColumns = this.mySelectedColumns != null ? this.mySelectedColumns.asArray() : ArrayUtilRt.EMPTY_INT_ARRAY;
        List columns = this.myColumns != null ? Arrays.asList(this.myColumns) : Collections.emptyList();
        DataExtractor.Extraction extraction = this.myExtractor.startExtraction(this.myOut, columns, this.myQuery, this.myConfig, selectedColumns);
        if (extraction == null) {
            DumpRequestDelegate.$$$reportNull$$$0(13);
        }
        return extraction;
    }

    public GridColumn[] getColumns() {
        return this.myColumns;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addRowCount";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dump/DumpRequestDelegate";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dump/DumpRequestDelegate";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSavingText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "startExtraction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setColumns";
                break;
            }
            case 7: 
            case 13: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateColumns";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addRows";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "afterLastRowAdded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 13 -> new IllegalStateException(string);
        };
    }
}

