/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.data.types.DataTypeConversion;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.CoreGridHelper;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridColumnLayout;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.GridUtilKt;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ResultView;
import com.intellij.database.dump.DumpHandler;
import com.intellij.database.dump.ExtractionHelper;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorFactories;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.ExtractionConfigKt;
import com.intellij.database.extractors.GridExtractorsUtilCore;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.run.actions.DumpSource;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.DefaultGridColumnLayout;
import com.intellij.database.run.ui.grid.GridRowComparator;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.database.util.Out;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GridHelper
extends CoreGridHelper {
    public static final Key<GridHelper> GRID_HELPER_KEY = new Key("GRID_HELPER_KEY");

    @NotNull
    public DataTypeConversion.Builder createDataTypeConversionBuilder();

    @NotNull
    public ObjectFormatterMode getDefaultMode();

    public boolean canEditTogether(@NotNull CoreGrid<GridRow, GridColumn> var1, @NotNull List<GridColumn> var2);

    default public boolean canSortTogether(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull List<ModelIndex<GridColumn>> oldOrdering, List<ModelIndex<GridColumn>> newColumns) {
        if (grid == null) {
            GridHelper.$$$reportNull$$$0(0);
        }
        if (oldOrdering == null) {
            GridHelper.$$$reportNull$$$0(1);
        }
        return true;
    }

    @Nullable
    public GridColumn findUniqueColumn(@NotNull CoreGrid<GridRow, GridColumn> var1, @NotNull List<GridColumn> var2);

    @Nullable
    public Icon getColumnIcon(@NotNull CoreGrid<GridRow, GridColumn> var1, @NotNull GridColumn var2, boolean var3);

    @Nullable
    public VirtualFile getVirtualFile(@NotNull CoreGrid<GridRow, GridColumn> var1);

    @NotNull
    default public JBIterable<TreeElement> getChildrenFromModel(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        if (grid == null) {
            GridHelper.$$$reportNull$$$0(2);
        }
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            GridHelper.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    @Nullable
    default public String getLocationString(@Nullable PsiElement element) {
        return null;
    }

    default public void setFilterSortHighlighter(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull Editor editor) {
        if (grid == null) {
            GridHelper.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            GridHelper.$$$reportNull$$$0(5);
        }
    }

    default public void updateFilterSortPSI(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        if (grid == null) {
            GridHelper.$$$reportNull$$$0(6);
        }
    }

    public void applyFix(@NotNull Project var1, @NotNull ErrorInfo.Fix var2, @Nullable Object var3);

    @NotNull
    public List<String> getUnambiguousColumnNames(@NotNull CoreGrid<GridRow, GridColumn> var1);

    public boolean canAddRow(@NotNull CoreGrid<GridRow, GridColumn> var1);

    public boolean hasTargetForEditing(@NotNull CoreGrid<GridRow, GridColumn> var1);

    @Nullable
    public String getTableName(@NotNull CoreGrid<GridRow, GridColumn> var1);

    @Nullable
    public String getNameForDump(@NotNull DataGrid var1);

    @Nullable
    public String getQueryText(@NotNull DataGrid var1);

    public boolean isDatabaseHookUp(@NotNull DataGrid var1);

    public int getDefaultPageSize();

    public void setDefaultPageSize(int var1);

    public boolean isLimitDefaultPageSize();

    public void setLimitDefaultPageSize(boolean var1);

    @Nullable
    public DumpSource<?> createDumpSource(@NotNull DataGrid var1, @NotNull AnActionEvent var2);

    @NotNull
    public DumpHandler<?> createDumpHandler(@NotNull DumpSource<?> var1, @NotNull ExtractionHelper var2, @NotNull DataExtractorFactory var3, @NotNull ExtractionConfig var4);

    default public boolean isDumpEnabled(@NotNull DumpSource<?> source) {
        if (source == null) {
            GridHelper.$$$reportNull$$$0(7);
        }
        return true;
    }

    default public void syncExtractorsInNotebook(@NotNull DataGrid grid, @NotNull DataExtractorFactory factory) {
        if (grid == null) {
            GridHelper.$$$reportNull$$$0(8);
        }
        if (factory == null) {
            GridHelper.$$$reportNull$$$0(9);
        }
        GridUtilKt.findAllGridsInFile(grid).forEach(g -> {
            DataExtractorFactory f = (DataExtractorFactory)g.getUserData(DataExtractorFactories.GRID_DATA_EXTRACTOR_FACTORY_KEY);
            if (f == null || !factory.getId().equals(f.getId())) {
                DataExtractorFactories.setExtractorFactory((CoreGrid)g, (DataExtractorFactory)factory);
            }
        });
    }

    default public boolean isLoadWholeTableWhenPaginationIsOff(@NotNull DataGrid grid) {
        if (grid == null) {
            GridHelper.$$$reportNull$$$0(10);
        }
        return false;
    }

    @NotNull
    public static GridHelper get(@NotNull CoreGrid<?, ?> grid) {
        if (grid == null) {
            GridHelper.$$$reportNull$$$0(11);
        }
        GridHelper gridHelper = Objects.requireNonNull((GridHelper)GRID_HELPER_KEY.get(grid));
        if (gridHelper == null) {
            GridHelper.$$$reportNull$$$0(12);
        }
        return gridHelper;
    }

    public static boolean supportsTableStatistics(DataGrid grid) {
        if (grid == null) {
            return false;
        }
        ResultView resultView = grid.getResultView();
        if (resultView instanceof TableResultView) {
            TableResultView tableResultView = (TableResultView)resultView;
            return tableResultView.getStatisticsHeader() != null;
        }
        return false;
    }

    @NotNull
    default public GridColumnLayout<GridRow, GridColumn> createColumnLayout(@NotNull TableResultView resultView, @NotNull DataGrid grid) {
        if (resultView == null) {
            GridHelper.$$$reportNull$$$0(13);
        }
        if (grid == null) {
            GridHelper.$$$reportNull$$$0(14);
        }
        return new DefaultGridColumnLayout(resultView, grid);
    }

    public static void set(@NotNull CoreGrid<?, ?> grid, @NotNull GridHelper helper) {
        if (grid == null) {
            GridHelper.$$$reportNull$$$0(15);
        }
        if (helper == null) {
            GridHelper.$$$reportNull$$$0(16);
        }
        GRID_HELPER_KEY.set(grid, (Object)helper);
    }

    @NlsContexts.Tooltip
    @Nullable
    default public String getColumnTooltipHtml(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ModelIndex<GridColumn> columnIdx) {
        if (grid == null) {
            GridHelper.$$$reportNull$$$0(17);
        }
        if (columnIdx == null) {
            GridHelper.$$$reportNull$$$0(18);
        }
        return null;
    }

    @NlsSafe
    @Nullable
    default public String getDatabaseSystemName(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        if (grid == null) {
            GridHelper.$$$reportNull$$$0(19);
        }
        return null;
    }

    public boolean isEditable(@NotNull CoreGrid<GridRow, GridColumn> var1);

    @Nullable
    default public GridRowComparator createComparator(@NotNull GridColumn column) {
        if (column == null) {
            GridHelper.$$$reportNull$$$0(20);
        }
        return GridRowComparator.create(column);
    }

    @NotNull
    default public Out extractValues(@NotNull DataGrid dataGrid, @NotNull DataExtractor extractor, @NotNull Out out, boolean selection, boolean transpositionAllowed) {
        if (dataGrid == null) {
            GridHelper.$$$reportNull$$$0(21);
        }
        if (extractor == null) {
            GridHelper.$$$reportNull$$$0(22);
        }
        if (out == null) {
            GridHelper.$$$reportNull$$$0(23);
        }
        GridModel model2 = dataGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        int[] columns = (selection ? dataGrid.getSelectionModel().getSelectedColumns() : model2.getColumnIndices()).asArray();
        List rows = selection ? GridUtil.getSelectedGridRows(dataGrid) : model2.getRows();
        boolean transposed = transpositionAllowed && dataGrid.getResultView().isTransposed();
        ExtractionConfig config = ExtractionConfigKt.builder().setTransposed(transposed).setAddGeneratedColumns(!DataExtractorFactories.getSkipGeneratedColumns((CoreGrid)dataGrid)).setAddComputedColumns(!DataExtractorFactories.getSkipComputedColumns((CoreGrid)dataGrid)).build();
        GridExtractorsUtilCore.extract((Out)out, (ExtractionConfig)config, (List)model2.getAllColumnsForExtraction(columns), (DataExtractor)extractor, (List)rows, (int[])columns);
        Out out2 = out;
        if (out2 == null) {
            GridHelper.$$$reportNull$$$0(24);
        }
        return out2;
    }

    @NotNull
    default public Out extractValuesForCopy(@NotNull DataGrid dataGrid, @NotNull DataExtractor extractor, @NotNull Out out, boolean selection, boolean transpositionAllowed) {
        if (dataGrid == null) {
            GridHelper.$$$reportNull$$$0(25);
        }
        if (extractor == null) {
            GridHelper.$$$reportNull$$$0(26);
        }
        if (out == null) {
            GridHelper.$$$reportNull$$$0(27);
        }
        Out out2 = this.extractValues(dataGrid, extractor, out, selection, transpositionAllowed);
        if (out2 == null) {
            GridHelper.$$$reportNull$$$0(28);
        }
        return out2;
    }

    default public boolean isColumnContainNestedTables(@Nullable GridModel<GridRow, GridColumn> gridModel, @NotNull GridColumn column) {
        if (column == null) {
            GridHelper.$$$reportNull$$$0(29);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 12, 24, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldOrdering";
                break;
            }
            case 3: 
            case 12: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/GridHelper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultView";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 20: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGrid";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractor";
                break;
            }
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/GridHelper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenFromModel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "extractValues";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "extractValuesForCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canSortTogether";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenFromModel";
                break;
            }
            case 3: 
            case 12: 
            case 24: 
            case 28: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setFilterSortHighlighter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateFilterSortPSI";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDumpEnabled";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "syncExtractorsInNotebook";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isLoadWholeTableWhenPaginationIsOff";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createColumnLayout";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getColumnTooltipHtml";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseSystemName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createComparator";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "extractValues";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "extractValuesForCopy";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isColumnContainNestedTables";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 12, 24, 28 -> new IllegalStateException(string);
        };
    }
}

