/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.snapshots;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.runtime.internal.System_jvmKt;
import androidx.compose.runtime.internal.WeakReference;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0001\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0013\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001cJ\u001d\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001a0 H\u0086\bJ\u001d\u0010!\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00028\u00002\u0006\u0010\"\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010#J%\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00028\u00002\u0006\u0010&\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010'J\r\u0010(\u001a\u00020\u001aH\u0001\u00a2\u0006\u0002\b)R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R*\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00130\u0012X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006*"}, d2={"Landroidx/compose/runtime/snapshots/SnapshotWeakSet;", "T", "", "<init>", "()V", "size", "", "getSize$runtime", "()I", "setSize$runtime", "(I)V", "hashes", "", "getHashes$runtime", "()[I", "setHashes$runtime", "([I)V", "values", "", "Landroidx/compose/runtime/internal/WeakReference;", "getValues$runtime", "()[Landroidx/compose/runtime/internal/WeakReference;", "setValues$runtime", "([Landroidx/compose/runtime/internal/WeakReference;)V", "[Landroidx/compose/runtime/internal/WeakReference;", "add", "", "value", "(Ljava/lang/Object;)Z", "removeIf", "", "block", "Lkotlin/Function1;", "find", "hash", "(Ljava/lang/Object;I)I", "findExactIndex", "midIndex", "valueHash", "(ILjava/lang/Object;I)I", "isValid", "isValid$runtime", "runtime"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSnapshotWeakSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnapshotWeakSet.kt\nandroidx/compose/runtime/snapshots/SnapshotWeakSet\n+ 2 ArrayUtils.nonAndroid.kt\nandroidx/compose/runtime/collection/ArrayUtils_nonAndroidKt\n*L\n1#1,243:1\n26#2:244\n26#2:245\n26#2:246\n*S KotlinDebug\n*F\n+ 1 SnapshotWeakSet.kt\nandroidx/compose/runtime/snapshots/SnapshotWeakSet\n*L\n74#1:244\n80#1:245\n96#1:246\n*E\n"})
public final class SnapshotWeakSet<T> {
    private int size;
    @NotNull
    private int[] hashes = new int[16];
    @NotNull
    private WeakReference<T>[] values = new WeakReference[16];
    public static final int $stable = 8;

    public final int getSize$runtime() {
        return this.size;
    }

    public final void setSize$runtime(int n) {
        this.size = n;
    }

    @NotNull
    public final int[] getHashes$runtime() {
        return this.hashes;
    }

    public final void setHashes$runtime(@NotNull int[] nArray) {
        this.hashes = nArray;
    }

    @NotNull
    public final WeakReference<T>[] getValues$runtime() {
        return this.values;
    }

    public final void setValues$runtime(@NotNull WeakReference<T>[] weakReferenceArray) {
        this.values = weakReferenceArray;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean add(@NotNull T value) {
        int index2 = 0;
        int size = this.size;
        int hash = System_jvmKt.identityHashCode(value);
        if (size > 0) {
            index2 = this.find(value, hash);
            if (index2 >= 0) {
                return false;
            }
        } else {
            index2 = -1;
        }
        int insertIndex = -(index2 + 1);
        int capacity = this.values.length;
        if (size == capacity) {
            void startIndex$iv;
            int destinationOffset$iv;
            Object[] $this$fastCopyInto$iv;
            int newCapacity = capacity * 2;
            Object[] newValues = new WeakReference[newCapacity];
            int[] newHashes = new int[newCapacity];
            WeakReference<T>[] weakReferenceArray = this.values;
            int n = insertIndex + 1;
            boolean $i$f$fastCopyInto = false;
            ArraysKt.copyInto((Object[])$this$fastCopyInto$iv, (Object[])newValues, (int)destinationOffset$iv, (int)insertIndex, (int)size);
            $this$fastCopyInto$iv = this.values;
            destinationOffset$iv = 0;
            $i$f$fastCopyInto = false;
            boolean $i$f$fastCopyInto2 = false;
            ArraysKt.copyInto((Object[])$this$fastCopyInto$iv, (Object[])newValues, (int)destinationOffset$iv, (int)startIndex$iv, (int)insertIndex);
            ArraysKt.copyInto((int[])this.hashes, (int[])newHashes, (int)(insertIndex + 1), (int)insertIndex, (int)size);
            ArraysKt.copyInto$default((int[])this.hashes, (int[])newHashes, (int)0, (int)0, (int)insertIndex, (int)6, null);
            this.values = newValues;
            this.hashes = newHashes;
        } else {
            void destinationOffset$iv;
            void destination$iv;
            void $this$fastCopyInto$iv;
            WeakReference<T>[] newCapacity = this.values;
            WeakReference<T>[] newValues = this.values;
            int newHashes = insertIndex + 1;
            boolean $i$f$fastCopyInto = false;
            ArraysKt.copyInto((Object[])$this$fastCopyInto$iv, (Object[])destination$iv, (int)destinationOffset$iv, (int)insertIndex, (int)size);
            ArraysKt.copyInto((int[])this.hashes, (int[])this.hashes, (int)(insertIndex + 1), (int)insertIndex, (int)size);
        }
        this.values[insertIndex] = new WeakReference<T>(value);
        this.hashes[insertIndex] = hash;
        int n = this.size;
        this.size = n + 1;
        return true;
    }

    public final void removeIf(@NotNull Function1<? super T, Boolean> block) {
        int i;
        boolean $i$f$removeIf = false;
        int size = this.getSize$runtime();
        int currentUsed = 0;
        for (i = 0; i < size; ++i) {
            Object value;
            WeakReference<T> entry;
            WeakReference<T> weakReference = entry = this.getValues$runtime()[i];
            Object object = value = weakReference != null ? weakReference.get() : null;
            if (value == null || ((Boolean)block.invoke(value)).booleanValue()) continue;
            if (currentUsed != i) {
                this.getValues$runtime()[currentUsed] = entry;
                this.getHashes$runtime()[currentUsed] = this.getHashes$runtime()[i];
            }
            ++currentUsed;
        }
        for (i = currentUsed; i < size; ++i) {
            this.getValues$runtime()[i] = null;
            this.getHashes$runtime()[i] = 0;
        }
        if (currentUsed != size) {
            this.setSize$runtime(currentUsed);
        }
    }

    private final int find(T value, int hash) {
        int low = 0;
        int high = this.size - 1;
        while (low <= high) {
            Object midVal;
            int mid = low + high >>> 1;
            int midHash = this.hashes[mid];
            if (midHash < hash) {
                low = mid + 1;
                continue;
            }
            if (midHash > hash) {
                high = mid - 1;
                continue;
            }
            WeakReference<T> weakReference = this.values[mid];
            Object object = midVal = weakReference != null ? weakReference.get() : null;
            if (value == midVal) {
                return mid;
            }
            return this.findExactIndex(mid, value, hash);
        }
        return -(low + 1);
    }

    private final int findExactIndex(int midIndex, T value, int valueHash) {
        int i;
        for (i = midIndex - 1; -1 < i && this.hashes[i] == valueHash; --i) {
            Object v;
            WeakReference<T> weakReference = this.values[i];
            Object object = v = weakReference != null ? weakReference.get() : null;
            if (v != value) continue;
            return i;
        }
        int n = this.size;
        for (i = midIndex + 1; i < n; ++i) {
            Object v;
            if (this.hashes[i] != valueHash) {
                return -(i + 1);
            }
            WeakReference<T> weakReference = this.values[i];
            Object object = v = weakReference != null ? weakReference.get() : null;
            if (v != value) continue;
            return i;
        }
        return -(this.size + 1);
    }

    @TestOnly
    public final boolean isValid$runtime() {
        int i;
        int size = this.size;
        WeakReference<T>[] values = this.values;
        int[] hashes = this.hashes;
        int capacity = values.length;
        if (size > capacity) {
            return false;
        }
        int previous = Integer.MIN_VALUE;
        for (i = 0; i < size; ++i) {
            WeakReference<T> entry;
            int hash = hashes[i];
            if (hash < previous) {
                return false;
            }
            if (values[i] == null) {
                return false;
            }
            Object value = entry.get();
            if (value != null && hash != System_jvmKt.identityHashCode(value)) {
                return false;
            }
            previous = hash;
        }
        for (i = size; i < capacity; ++i) {
            if (hashes[i] != 0) {
                return false;
            }
            if (values[i] == null) continue;
            return false;
        }
        return true;
    }
}

