/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.QueryDocValues;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;

public class QueryValueSource
extends ValueSource {
    final Query q;
    final float defVal;

    public QueryValueSource(Query q, float defVal) {
        if (q == null) {
            throw new IllegalArgumentException("query cannot be null");
        }
        this.q = q;
        this.defVal = defVal;
    }

    public Query getQuery() {
        return this.q;
    }

    public float getDefaultValue() {
        return this.defVal;
    }

    @Override
    public String description() {
        return "query(" + String.valueOf(this.q) + ",def=" + this.defVal + ")";
    }

    @Override
    public FunctionValues getValues(Map<Object, Object> fcontext, LeafReaderContext readerContext) throws IOException {
        return new QueryDocValues(this, readerContext, fcontext);
    }

    @Override
    public int hashCode() {
        return this.q.hashCode() * 29;
    }

    @Override
    public boolean equals(Object o) {
        if (QueryValueSource.class != o.getClass()) {
            return false;
        }
        QueryValueSource other = (QueryValueSource)o;
        return this.q.equals((Object)other.q) && this.defVal == other.defVal;
    }

    @Override
    public void createWeight(Map<Object, Object> context, IndexSearcher searcher) throws IOException {
        Query rewritten = searcher.rewrite(this.q);
        Weight w = searcher.createWeight(rewritten, ScoreMode.COMPLETE, 1.0f);
        context.put(this, w);
    }
}

