/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.AccessToken;

public class AdminAuth {
    private final RealmModel realm;
    private final AccessToken token;
    private final UserModel user;
    private final ClientModel client;

    public AdminAuth(RealmModel realm, AccessToken token, UserModel user, ClientModel client) {
        this.token = token;
        this.realm = realm;
        this.user = user;
        this.client = client;
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public UserModel getUser() {
        return this.user;
    }

    public ClientModel getClient() {
        return this.client;
    }

    public AccessToken getToken() {
        return this.token;
    }

    public boolean hasRealmRole(String role) {
        if (this.client instanceof ClientModel) {
            RoleModel roleModel = this.realm.getRole(role);
            if (roleModel == null) {
                return false;
            }
            return this.user.hasRole(roleModel) && this.client.hasScope(roleModel);
        }
        AccessToken.Access access = this.token.getRealmAccess();
        return access != null && access.isUserInRole(role);
    }

    public boolean hasOneOfRealmRole(String ... roles) {
        for (String r : roles) {
            if (!this.hasRealmRole(r)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAppRole(ClientModel app, String role) {
        if (this.client instanceof ClientModel) {
            RoleModel roleModel = app.getRole(role);
            if (roleModel == null) {
                return false;
            }
            return this.user.hasRole(roleModel) && this.client.hasScope(roleModel);
        }
        AccessToken.Access access = this.token.getResourceAccess(app.getClientId());
        return access != null && access.isUserInRole(role);
    }

    public boolean hasOneOfAppRole(ClientModel app, String ... roles) {
        for (String r : roles) {
            if (!this.hasAppRole(app, r)) continue;
            return true;
        }
        return false;
    }

    public static enum Resource {
        CLIENT,
        USER,
        REALM,
        EVENTS,
        IDENTITY_PROVIDER,
        IMPERSONATION,
        AUTHORIZATION;

    }
}

