/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriBuilderException;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.InitiatedActionSupport;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.authentication.actiontoken.verifyemail.VerifyEmailActionToken;
import org.keycloak.authentication.requiredactions.util.EmailCooldownManager;
import org.keycloak.common.util.Time;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailTemplateProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.Urls;
import org.keycloak.services.validation.Validation;
import org.keycloak.sessions.AuthenticationSessionCompoundId;
import org.keycloak.sessions.AuthenticationSessionModel;

public class VerifyEmail
implements RequiredActionProvider,
RequiredActionFactory {
    public static final String EMAIL_RESEND_COOLDOWN_KEY_PREFIX = "verify-email-cooldown-";
    private static final Logger logger = Logger.getLogger(VerifyEmail.class);

    public void evaluateTriggers(RequiredActionContext context) {
        if (context.getRealm().isVerifyEmail() && !context.getUser().isEmailVerified()) {
            if (context.getUser().getRequiredActionsStream().noneMatch(action -> UserModel.RequiredAction.UPDATE_EMAIL.name().equals(action))) {
                context.getUser().addRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL);
                logger.debug((Object)"User is required to verify email");
            } else {
                logger.debug((Object)"Skipping VERIFY_EMAIL because UPDATE_EMAIL is already present");
            }
        }
    }

    public InitiatedActionSupport initiatedActionSupport() {
        return InitiatedActionSupport.SUPPORTED;
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        this.process(context, true);
    }

    private void process(RequiredActionContext context, boolean isChallenge) {
        Response challenge;
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        if (context.getUser().isEmailVerified()) {
            context.success();
            authSession.removeAuthNote("VERIFY_EMAIL_KEY");
            return;
        }
        String email = context.getUser().getEmail();
        if (Validation.isBlank(email)) {
            context.ignore();
            return;
        }
        LoginFormsProvider loginFormsProvider = context.form();
        loginFormsProvider.setAuthenticationSession(context.getAuthenticationSession());
        authSession.setClientNote("APP_INITIATED_FLOW", null);
        if (!(Objects.equals(authSession.getAuthNote("VERIFY_EMAIL_KEY"), email) || this.isCurrentActionTriggeredFromAIA(context) && isChallenge)) {
            EmailCooldownManager.addCooldownEntry(context, EMAIL_RESEND_COOLDOWN_KEY_PREFIX);
            authSession.setAuthNote("VERIFY_EMAIL_KEY", email);
            EventBuilder event = context.getEvent().clone().event(EventType.SEND_VERIFY_EMAIL).detail("email", email);
            challenge = this.sendVerifyEmail(context, event);
        } else {
            challenge = loginFormsProvider.createResponse(UserModel.RequiredAction.VERIFY_EMAIL);
        }
        context.challenge(challenge);
    }

    private boolean isCurrentActionTriggeredFromAIA(RequiredActionContext context) {
        return Objects.equals(context.getAuthenticationSession().getClientNote("kc_action"), this.getId());
    }

    public void processAction(RequiredActionContext context) {
        logger.debugf("Re-sending email requested for user: %s", (Object)context.getUser().getUsername());
        Long remaining = EmailCooldownManager.retrieveCooldownEntry(context, EMAIL_RESEND_COOLDOWN_KEY_PREFIX);
        if (remaining != null) {
            Response retryPage = context.form().setError("emailVerifySendCooldown", new Object[]{remaining}).createResponse(UserModel.RequiredAction.VERIFY_EMAIL);
            context.challenge(retryPage);
            return;
        }
        context.getAuthenticationSession().removeAuthNote("VERIFY_EMAIL_KEY");
        this.process(context, false);
    }

    public void close() {
    }

    public RequiredActionProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getDisplayText() {
        return "Verify Email";
    }

    public String getId() {
        return UserModel.RequiredAction.VERIFY_EMAIL.name();
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        ProviderConfigProperty maxAge = new ProviderConfigProperty();
        maxAge.setName("max_auth_age");
        maxAge.setLabel("Maximum Age of Authentication");
        maxAge.setHelpText("Configures the duration in seconds this action can be used after the last authentication before the user is required to re-authenticate. This parameter is used just in the context of AIA when the kc_action parameter is available in the request, which is for instance when user himself updates his password in the account console.");
        maxAge.setType("String");
        maxAge.setDefaultValue((Object)300);
        return List.of(maxAge, EmailCooldownManager.createCooldownConfigProperty());
    }

    private Response sendVerifyEmail(RequiredActionContext context, EventBuilder event) throws UriBuilderException, IllegalArgumentException {
        RealmModel realm = context.getRealm();
        UriInfo uriInfo = context.getUriInfo();
        UserModel user = context.getUser();
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        KeycloakSession session = context.getSession();
        int validityInSecs = realm.getActionTokenGeneratedByUserLifespan("verify-email");
        int absoluteExpirationInSecs = Time.currentTime() + validityInSecs;
        String authSessionEncodedId = AuthenticationSessionCompoundId.fromAuthSession((AuthenticationSessionModel)authSession).getEncodedId();
        VerifyEmailActionToken token = new VerifyEmailActionToken(user.getId(), absoluteExpirationInSecs, authSessionEncodedId, user.getEmail(), authSession.getClient().getClientId());
        UriBuilder builder = Urls.actionTokenBuilder(uriInfo.getBaseUri(), token.serialize(session, realm, uriInfo), authSession.getClient().getClientId(), authSession.getTabId(), AuthenticationProcessor.getClientData(session, authSession));
        String link = builder.build(new Object[]{realm.getName()}).toString();
        long expirationInMinutes = TimeUnit.SECONDS.toMinutes(validityInSecs);
        try {
            ((EmailTemplateProvider)session.getProvider(EmailTemplateProvider.class)).setAuthenticationSession(authSession).setRealm(realm).setUser(user).sendVerifyEmail(link, expirationInMinutes);
            event.success();
            return context.form().createResponse(UserModel.RequiredAction.VERIFY_EMAIL);
        }
        catch (EmailException e) {
            event.clone().event(EventType.SEND_VERIFY_EMAIL).detail("reason", e.getMessage()).user(user).error("email_send_failed");
            logger.error((Object)"Failed to send verification email", (Throwable)e);
            context.failure("emailSendErrorMessage");
            return context.form().setError("emailSendErrorMessage", new Object[0]).createErrorPage(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

