/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.web.flow;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.model.support.mfa.trusteddevice.TrustedDevicesMultifactorProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.trusted.authentication.MultifactorAuthenticationTrustedDeviceBypassEvaluator;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustRecord;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustStorage;
import org.apereo.cas.trusted.util.MultifactorAuthenticationTrustUtils;
import org.apereo.cas.trusted.web.flow.fingerprint.DeviceFingerprintStrategy;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class MultifactorAuthenticationVerifyTrustAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MultifactorAuthenticationVerifyTrustAction.class);
    private final MultifactorAuthenticationTrustStorage storage;
    private final DeviceFingerprintStrategy deviceFingerprintStrategy;
    private final TrustedDevicesMultifactorProperties trustedProperties;
    private final AuditableExecution registeredServiceAccessStrategyEnforcer;
    private final MultifactorAuthenticationTrustedDeviceBypassEvaluator bypassEvaluator;

    protected Event doExecute(RequestContext requestContext) {
        WebApplicationService service;
        Authentication authn = WebUtils.getAuthentication((RequestContext)requestContext);
        if (authn == null) {
            LOGGER.warn("Could not determine authentication from the request context");
            return this.no();
        }
        RegisteredService registeredService = WebUtils.getRegisteredService((RequestContext)requestContext);
        if (this.bypassEvaluator.shouldBypassTrustedDevice(registeredService, (Service)(service = WebUtils.getService((RequestContext)requestContext)), authn)) {
            LOGGER.debug("Trusted device registration is disabled for [{}]", (Object)registeredService);
            return this.result("skip");
        }
        String principal = authn.getPrincipal().getId();
        LOGGER.trace("Retrieving trusted authentication records for [{}]", (Object)principal);
        Set<? extends MultifactorAuthenticationTrustRecord> results = this.storage.get(principal);
        if (results.isEmpty()) {
            LOGGER.debug("No valid trusted authentication records could be found for [{}]", (Object)principal);
            return this.no();
        }
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
        String fingerprint = this.deviceFingerprintStrategy.determineFingerprintComponent(principal, request, response);
        LOGGER.trace("Retrieving authentication records for [{}] that matches [{}]", (Object)principal, (Object)fingerprint);
        if (results.stream().noneMatch(entry -> entry.getDeviceFingerprint().equals(fingerprint))) {
            LOGGER.debug("No trusted authentication records could be found for [{}] to match the current device fingerprint", (Object)principal);
            return this.no();
        }
        LOGGER.debug("Trusted authentication records found for [{}] that matches the current device fingerprint", (Object)principal);
        MultifactorAuthenticationTrustUtils.setMultifactorAuthenticationTrustedInScope(requestContext);
        MultifactorAuthenticationTrustUtils.trackTrustedMultifactorAuthenticationAttribute(authn, this.trustedProperties.getCore().getAuthenticationContextAttribute());
        return this.yes();
    }

    @Generated
    public MultifactorAuthenticationVerifyTrustAction(MultifactorAuthenticationTrustStorage storage, DeviceFingerprintStrategy deviceFingerprintStrategy, TrustedDevicesMultifactorProperties trustedProperties, AuditableExecution registeredServiceAccessStrategyEnforcer, MultifactorAuthenticationTrustedDeviceBypassEvaluator bypassEvaluator) {
        this.storage = storage;
        this.deviceFingerprintStrategy = deviceFingerprintStrategy;
        this.trustedProperties = trustedProperties;
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
        this.bypassEvaluator = bypassEvaluator;
    }

    @Generated
    public MultifactorAuthenticationTrustStorage getStorage() {
        return this.storage;
    }

    @Generated
    public DeviceFingerprintStrategy getDeviceFingerprintStrategy() {
        return this.deviceFingerprintStrategy;
    }

    @Generated
    public TrustedDevicesMultifactorProperties getTrustedProperties() {
        return this.trustedProperties;
    }

    @Generated
    public AuditableExecution getRegisteredServiceAccessStrategyEnforcer() {
        return this.registeredServiceAccessStrategyEnforcer;
    }

    @Generated
    public MultifactorAuthenticationTrustedDeviceBypassEvaluator getBypassEvaluator() {
        return this.bypassEvaluator;
    }
}

