/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.csvdir.database;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.tirasa.connid.bundles.csvdir.CSVDirConfiguration;
import net.tirasa.connid.bundles.csvdir.utilities.QueryTemplate;
import net.tirasa.connid.bundles.csvdir.utilities.Utilities;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.Uid;

public final class QueryCreator {
    private final String ocColumnName;

    public QueryCreator(CSVDirConfiguration conf) {
        this.ocColumnName = conf.getObjectClassColumn();
    }

    private String getWhereClause(ObjectClass oc, Uid uid, String keySeparator, String[] keys) {
        StringBuilder where = new StringBuilder();
        if (!StringUtil.isEmpty((String)this.ocColumnName)) {
            where.append(this.ocColumnName).append("=").append("'").append(oc.getObjectClassValue()).append("' AND ");
        }
        String[] uidKeys = uid.getUidValue().split(keySeparator);
        for (int i = 0; i < keys.length; ++i) {
            where.append(keys[i]).append("=").append("'").append(uidKeys[i]).append("'");
            if (i >= keys.length - 1) continue;
            where.append(" AND ");
        }
        return where.toString();
    }

    private Map<String, String> getKeyValueMap(ObjectClass oc, Map<String, String> valuesMap) {
        LinkedHashMap<String, String> keyValueMap = new LinkedHashMap<String, String>();
        if (!StringUtil.isEmpty((String)this.ocColumnName)) {
            keyValueMap.put(this.ocColumnName, "'" + oc.getObjectClassValue() + "'");
        }
        for (Map.Entry<String, String> entry : valuesMap.entrySet()) {
            if (entry.getValue() == null) {
                keyValueMap.put(entry.getKey(), "NULL");
                continue;
            }
            keyValueMap.put(entry.getKey(), "'" + entry.getValue() + "'");
        }
        return keyValueMap;
    }

    public String insertQuery(ObjectClass oc, Map<String, String> valuesMap, String tableName) {
        Map<String, String> keyValueMap = this.getKeyValueMap(oc, valuesMap);
        QueryTemplate queryTemplate = new QueryTemplate("INSERT INTO {0}({1}) VALUES({2})");
        return queryTemplate.apply(tableName, Utilities.join(keyValueMap.keySet(), ','), Utilities.join(keyValueMap.values(), ','));
    }

    public String updateQuery(ObjectClass oc, Map<String, String> valuesMap, Uid uid, String keySeparator, String[] keys, String tableName) {
        Map<String, String> keyValueMap = this.getKeyValueMap(oc, valuesMap);
        ArrayList<String> set = new ArrayList<String>(keyValueMap.size());
        for (Map.Entry<String, String> entry : keyValueMap.entrySet()) {
            set.add(entry.getKey() + "=" + entry.getValue());
        }
        QueryTemplate queryTemplate = new QueryTemplate("UPDATE {0} SET {1} WHERE {2}");
        return queryTemplate.apply(tableName, Utilities.join(set, ','), this.getWhereClause(oc, uid, keySeparator, keys));
    }

    public String deleteQuery(ObjectClass oc, Uid uid, String keySeparator, String[] keys, String tableName) {
        QueryTemplate queryTemplate = new QueryTemplate("DELETE FROM {0} WHERE {1}");
        return queryTemplate.apply(tableName, this.getWhereClause(oc, uid, keySeparator, keys));
    }
}

