/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.provider.jcs;

import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.Properties;
import org.springframework.util.StringUtils;
import org.springmodules.cache.provider.jcs.JcsFlushingModel;
import org.springmodules.cache.util.SemicolonSeparatedPropertiesParser;

public class JcsFlushingModelEditor
extends PropertyEditorSupport {
    private static final String CACHE_STRUCT_DELIMETER = "|";

    public void setAsText(String text) throws IllegalArgumentException {
        String newText = text;
        JcsFlushingModel model = new JcsFlushingModel();
        if (!StringUtils.hasText((String)newText)) {
            this.setValue(model);
            return;
        }
        if (newText.endsWith(CACHE_STRUCT_DELIMETER) && !StringUtils.hasText((String)(newText = newText.substring(0, newText.length() - CACHE_STRUCT_DELIMETER.length())))) {
            this.setValue(model);
            return;
        }
        ArrayList<JcsFlushingModel.CacheStruct> cacheStructList = new ArrayList<JcsFlushingModel.CacheStruct>();
        String[] structs = StringUtils.delimitedListToStringArray((String)newText, (String)CACHE_STRUCT_DELIMETER);
        int structCount = structs.length;
        for (int i = 0; i < structCount; ++i) {
            Properties properties = SemicolonSeparatedPropertiesParser.parseProperties(structs[i]);
            JcsFlushingModel.CacheStruct struct = new JcsFlushingModel.CacheStruct();
            struct.setCacheName(properties.getProperty("cacheName"));
            struct.setGroups(properties.getProperty("groups"));
            cacheStructList.add(struct);
        }
        JcsFlushingModel.CacheStruct[] cacheStructs = cacheStructList.toArray(new JcsFlushingModel.CacheStruct[cacheStructList.size()]);
        model.setCacheStructs(cacheStructs);
        this.setValue(model);
    }
}

