/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.task.service.impl.persistence.entity.data.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.impl.cfg.IdGenerator;
import org.flowable.common.engine.impl.db.AbstractDataManager;
import org.flowable.common.engine.impl.db.DbSqlSession;
import org.flowable.common.engine.impl.db.ListQueryParameterObject;
import org.flowable.common.engine.impl.persistence.cache.CachedEntityMatcher;
import org.flowable.task.api.Task;
import org.flowable.task.service.TaskServiceConfiguration;
import org.flowable.task.service.impl.TaskQueryImpl;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntityImpl;
import org.flowable.task.service.impl.persistence.entity.data.TaskDataManager;
import org.flowable.task.service.impl.persistence.entity.data.impl.cachematcher.TasksByExecutionIdMatcher;
import org.flowable.task.service.impl.persistence.entity.data.impl.cachematcher.TasksByProcessInstanceIdMatcher;
import org.flowable.task.service.impl.persistence.entity.data.impl.cachematcher.TasksByScopeIdAndScopeTypeMatcher;
import org.flowable.task.service.impl.persistence.entity.data.impl.cachematcher.TasksBySubScopeIdAndScopeTypeMatcher;

public class MybatisTaskDataManager
extends AbstractDataManager<TaskEntity>
implements TaskDataManager {
    protected CachedEntityMatcher<TaskEntity> tasksByExecutionIdMatcher = new TasksByExecutionIdMatcher();
    protected CachedEntityMatcher<TaskEntity> tasksByProcessInstanceIdMatcher = new TasksByProcessInstanceIdMatcher();
    protected CachedEntityMatcher<TaskEntity> tasksBySubScopeIdAndScopeTypeMatcher = new TasksBySubScopeIdAndScopeTypeMatcher();
    protected CachedEntityMatcher<TaskEntity> tasksByScopeIdAndScopeTypeMatcher = new TasksByScopeIdAndScopeTypeMatcher();
    protected TaskServiceConfiguration taskServiceConfiguration;

    public MybatisTaskDataManager(TaskServiceConfiguration taskServiceConfiguration) {
        this.taskServiceConfiguration = taskServiceConfiguration;
    }

    public Class<? extends TaskEntity> getManagedEntityClass() {
        return TaskEntityImpl.class;
    }

    public TaskEntity create() {
        return new TaskEntityImpl();
    }

    @Override
    public List<TaskEntity> findTasksByExecutionId(String executionId) {
        DbSqlSession dbSqlSession = this.getDbSqlSession();
        if (this.isEntityInserted(dbSqlSession, "execution", executionId)) {
            return this.getListFromCache(this.tasksByExecutionIdMatcher, executionId);
        }
        return this.getList(dbSqlSession, "selectTasksByExecutionId", executionId, this.tasksByExecutionIdMatcher, true);
    }

    @Override
    public List<TaskEntity> findTasksByProcessInstanceId(String processInstanceId) {
        DbSqlSession dbSqlSession = this.getDbSqlSession();
        if (this.isEntityInserted(dbSqlSession, "execution", processInstanceId)) {
            return this.getListFromCache(this.tasksByProcessInstanceIdMatcher, processInstanceId);
        }
        return this.getList(dbSqlSession, "selectTasksByProcessInstanceId", processInstanceId, this.tasksByProcessInstanceIdMatcher, true);
    }

    @Override
    public List<TaskEntity> findTasksByScopeIdAndScopeType(String scopeId, String scopeType) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("scopeId", scopeId);
        params.put("scopeType", scopeType);
        return this.getList("selectTasksByScopeIdAndScopeType", params, this.tasksByScopeIdAndScopeTypeMatcher, true);
    }

    @Override
    public List<TaskEntity> findTasksBySubScopeIdAndScopeType(String subScopeId, String scopeType) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("subScopeId", subScopeId);
        params.put("scopeType", scopeType);
        return this.getList("selectTasksBySubScopeIdAndScopeType", params, this.tasksBySubScopeIdAndScopeTypeMatcher, true);
    }

    @Override
    public List<Task> findTasksByQueryCriteria(TaskQueryImpl taskQuery) {
        String query = "selectTaskByQueryCriteria";
        this.setSafeInValueLists(taskQuery);
        return this.getDbSqlSession().selectList("selectTaskByQueryCriteria", (ListQueryParameterObject)taskQuery, this.getManagedEntityClass());
    }

    @Override
    public List<Task> findTasksWithRelatedEntitiesByQueryCriteria(TaskQueryImpl taskQuery) {
        String query = "selectTasksWithRelatedEntitiesByQueryCriteria";
        this.setSafeInValueLists(taskQuery);
        return this.getDbSqlSession().selectList("selectTasksWithRelatedEntitiesByQueryCriteria", (ListQueryParameterObject)taskQuery, this.getManagedEntityClass());
    }

    @Override
    public long findTaskCountByQueryCriteria(TaskQueryImpl taskQuery) {
        this.setSafeInValueLists(taskQuery);
        return (Long)this.getDbSqlSession().selectOne("selectTaskCountByQueryCriteria", (Object)taskQuery);
    }

    @Override
    public List<Task> findTasksByNativeQuery(Map<String, Object> parameterMap) {
        return this.getDbSqlSession().selectListWithRawParameter("selectTaskByNativeQuery", parameterMap);
    }

    @Override
    public long findTaskCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectTaskCountByNativeQuery", parameterMap);
    }

    @Override
    public List<Task> findTasksByParentTaskId(String parentTaskId) {
        return this.getDbSqlSession().selectList("selectTasksByParentTaskId", (Object)parentTaskId);
    }

    @Override
    public void updateTaskTenantIdForDeployment(String deploymentId, String newTenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        params.put("tenantId", newTenantId);
        this.getDbSqlSession().directUpdate("updateTaskTenantIdForDeployment", params);
    }

    @Override
    public void updateAllTaskRelatedEntityCountFlags(boolean newValue) {
        this.getDbSqlSession().directUpdate("updateTaskRelatedEntityCountEnabled", (Object)newValue);
    }

    @Override
    public void deleteTasksByExecutionId(String executionId) {
        DbSqlSession dbSqlSession = this.getDbSqlSession();
        if (this.isEntityInserted(dbSqlSession, "execution", executionId)) {
            this.deleteCachedEntities(dbSqlSession, this.tasksByExecutionIdMatcher, executionId);
        } else {
            this.bulkDelete("deleteTasksByExecutionId", this.tasksByExecutionIdMatcher, executionId);
        }
    }

    protected IdGenerator getIdGenerator() {
        return this.taskServiceConfiguration.getIdGenerator();
    }

    protected void setSafeInValueLists(TaskQueryImpl taskQuery) {
        if (taskQuery.getCandidateGroups() != null) {
            taskQuery.setSafeCandidateGroups(this.createSafeInValuesList(taskQuery.getCandidateGroups()));
        }
        if (taskQuery.getInvolvedGroups() != null) {
            taskQuery.setSafeInvolvedGroups(this.createSafeInValuesList(taskQuery.getInvolvedGroups()));
        }
        if (taskQuery.getOrQueryObjects() != null && !taskQuery.getOrQueryObjects().isEmpty()) {
            for (TaskQueryImpl orTaskQuery : taskQuery.getOrQueryObjects()) {
                this.setSafeInValueLists(orTaskQuery);
            }
        }
    }
}

