/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.assigners;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;

@PublicEvolving
public enum WindowStagger {
    ALIGNED{

        @Override
        public long getStaggerOffset(long currentProcessingTime, long size) {
            return 0L;
        }
    }
    ,
    RANDOM{

        @Override
        public long getStaggerOffset(long currentProcessingTime, long size) {
            return (long)(ThreadLocalRandom.current().nextDouble() * (double)size);
        }
    }
    ,
    NATURAL{

        @Override
        public long getStaggerOffset(long currentProcessingTime, long size) {
            long currentProcessingWindowStart = TimeWindow.getWindowStartWithOffset(currentProcessingTime, 0L, size);
            return Math.max(0L, currentProcessingTime - currentProcessingWindowStart);
        }
    };


    public abstract long getStaggerOffset(long var1, long var3);
}

