/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.fs.Path;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.checkpointing.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.state.LineageItem;
import org.apache.spark.sql.execution.streaming.state.RocksDB;
import org.apache.spark.sql.execution.streaming.state.RocksDBKeyStateEncoder;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateStoreChangeDataReader$;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateStoreProvider$;
import org.apache.spark.sql.execution.streaming.state.RocksDBValueStateEncoder;
import org.apache.spark.sql.execution.streaming.state.StateStore$;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangeDataReader;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogReader;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dd\u0001\u0002\u000b\u0016\u0001\u0011B\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005c!AA\u0007\u0001B\u0001B\u0003%Q\u0007\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0011!!\u0005A!A!\u0002\u0013q\u0004\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u0011Q\u0003!\u0011!Q\u0001\nUC\u0001b\u0017\u0001\u0003\u0002\u0003\u0006I\u0001\u0018\u0005\te\u0002\u0011\t\u0011)A\u0005\r\")1\u000f\u0001C\u0001i\"Aq\u0010\u0001b\u0001\n#\n\t\u0001\u0003\u0005\u0002\u0010\u0001\u0001\u000b\u0011BA\u0002\u0011%\t\t\u0002\u0001b\u0001\n#\n\u0019\u0002C\u0004\u0002\u0016\u0001\u0001\u000b\u0011B%\t\u000f\u0005]\u0001\u0001\"\u0011\u0002\u001a\u001dI\u0011\u0011I\u000b\u0002\u0002#\u0005\u00111\t\u0004\t)U\t\t\u0011#\u0001\u0002F!11/\u0005C\u0001\u0003\u001bB\u0011\"a\u0014\u0012#\u0003%\t!!\u0015\u0003CI{7m[:E\u0005N#\u0018\r^3Ti>\u0014Xm\u00115b]\u001e,G)\u0019;b%\u0016\fG-\u001a:\u000b\u0005Y9\u0012!B:uCR,'B\u0001\r\u001a\u0003%\u0019HO]3b[&twM\u0003\u0002\u001b7\u0005IQ\r_3dkRLwN\u001c\u0006\u00039u\t1a]9m\u0015\tqr$A\u0003ta\u0006\u00148N\u0003\u0002!C\u00051\u0011\r]1dQ\u0016T\u0011AI\u0001\u0004_J<7\u0001A\n\u0003\u0001\u0015\u0002\"AJ\u0014\u000e\u0003UI!\u0001K\u000b\u00035M#\u0018\r^3Ti>\u0014Xm\u00115b]\u001e,G)\u0019;b%\u0016\fG-\u001a:\u0002\u0005\u0019l\u0007CA\u0016/\u001b\u0005a#BA\u0017\u0018\u00035\u0019\u0007.Z2la>Lg\u000e^5oO&\u0011q\u0006\f\u0002\u0016\u0007\",7m\u001b9pS:$h)\u001b7f\u001b\u0006t\u0017mZ3s\u0003\u001d\u0011xnY6t\t\n\u0003\"A\n\u001a\n\u0005M*\"a\u0002*pG.\u001cHIQ\u0001\u000egR\fG/\u001a'pG\u0006$\u0018n\u001c8\u0011\u0005YZT\"A\u001c\u000b\u0005aJ\u0014A\u00014t\u0015\tQt$\u0001\u0004iC\u0012|w\u000e]\u0005\u0003y]\u0012A\u0001U1uQ\u0006a1\u000f^1siZ+'o]5p]B\u0011qHQ\u0007\u0002\u0001*\t\u0011)A\u0003tG\u0006d\u0017-\u0003\u0002D\u0001\n!Aj\u001c8h\u0003))g\u000e\u001a,feNLwN\\\u0001\u001bK:$g+\u001a:tS>t7\u000b^1uKN#xN]3DWB$\u0018\n\u001a\t\u0004\u007f\u001dK\u0015B\u0001%A\u0005\u0019y\u0005\u000f^5p]B\u0011!*\u0015\b\u0003\u0017>\u0003\"\u0001\u0014!\u000e\u00035S!AT\u0012\u0002\rq\u0012xn\u001c;?\u0013\t\u0001\u0006)\u0001\u0004Qe\u0016$WMZ\u0005\u0003%N\u0013aa\u0015;sS:<'B\u0001)A\u0003A\u0019w.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7\r\u0005\u0002W36\tqK\u0003\u0002Y;\u0005\u0011\u0011n\\\u0005\u00035^\u0013\u0001cQ8naJ,7o]5p]\u000e{G-Z2\u0002%-,\u0017PV1mk\u0016,enY8eKJl\u0015\r\u001d\t\u0005;\u0012Le-D\u0001_\u0015\ty\u0006-\u0001\u0006d_:\u001cWO\u001d:f]RT!!\u00192\u0002\tU$\u0018\u000e\u001c\u0006\u0002G\u0006!!.\u0019<b\u0013\t)gLA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004RaP4jY>L!\u0001\u001b!\u0003\rQ+\b\u000f\\34!\t1#.\u0003\u0002l+\t1\"k\\2lg\u0012\u00135*Z=Ti\u0006$X-\u00128d_\u0012,'\u000f\u0005\u0002'[&\u0011a.\u0006\u0002\u0019%>\u001c7n\u001d#C-\u0006dW/Z*uCR,WI\\2pI\u0016\u0014\bCA q\u0013\t\t\bIA\u0003TQ>\u0014H/\u0001\td_24\u0015-\\5ms:\u000bW.Z(qi\u00061A(\u001b8jiz\"\"\"\u001e<xqfT8\u0010`?\u007f!\t1\u0003\u0001C\u0003*\u0015\u0001\u0007!\u0006C\u00031\u0015\u0001\u0007\u0011\u0007C\u00035\u0015\u0001\u0007Q\u0007C\u0003>\u0015\u0001\u0007a\bC\u0003E\u0015\u0001\u0007a\bC\u0003F\u0015\u0001\u0007a\tC\u0003U\u0015\u0001\u0007Q\u000bC\u0003\\\u0015\u0001\u0007A\fC\u0004s\u0015A\u0005\t\u0019\u0001$\u0002)Y,'o]5p]N\fe\u000eZ+oSF,X-\u00133t+\t\t\u0019\u0001E\u0003@\u0003\u000b\tI!C\u0002\u0002\b\u0001\u0013Q!\u0011:sCf\u0004RaPA\u0006}\u0019K1!!\u0004A\u0005\u0019!V\u000f\u001d7fe\u0005)b/\u001a:tS>t7/\u00118e+:L\u0017/^3JIN\u0004\u0013aD2iC:<W\r\\8h'V4g-\u001b=\u0016\u0003%\u000b\u0001c\u00195b]\u001e,Gn\\4Tk\u001a4\u0017\u000e\u001f\u0011\u0002\u000f\u001d,GOT3yiR\u0011\u00111\u0004\t\u000b\u007f\u0005u\u0011\u0011EA\u0019\u0003cq\u0014bAA\u0010\u0001\n1A+\u001e9mKR\u0002B!a\t\u0002*9\u0019a%!\n\n\u0007\u0005\u001dR#\u0001\u0006SK\u000e|'\u000f\u001a+za\u0016LA!a\u000b\u0002.\t)a+\u00197vK&\u0019\u0011q\u0006!\u0003\u0017\u0015sW/\\3sCRLwN\u001c\t\u0005\u0003g\ti$\u0004\u0002\u00026)!\u0011qGA\u001d\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0007\u0005m2$\u0001\u0005dCR\fG._:u\u0013\u0011\ty$!\u000e\u0003\u0013Us7/\u00194f%><\u0018!\t*pG.\u001cHIQ*uCR,7\u000b^8sK\u000eC\u0017M\\4f\t\u0006$\u0018MU3bI\u0016\u0014\bC\u0001\u0014\u0012'\r\t\u0012q\t\t\u0004\u007f\u0005%\u0013bAA&\u0001\n1\u0011I\\=SK\u001a$\"!a\u0011\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u0013:+\t\t\u0019FK\u0002G\u0003+Z#!a\u0016\u0011\t\u0005e\u00131M\u0007\u0003\u00037RA!!\u0018\u0002`\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003C\u0002\u0015AC1o]>$\u0018\r^5p]&!\u0011QMA.\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class RocksDBStateStoreChangeDataReader
extends StateStoreChangeDataReader {
    private final ConcurrentHashMap<String, Tuple3<RocksDBKeyStateEncoder, RocksDBValueStateEncoder, Object>> keyValueEncoderMap;
    private final Option<String> colFamilyNameOpt;
    private final Tuple2<Object, Option<String>>[] versionsAndUniqueIds;
    private final String changelogSuffix;

    public static Option<String> $lessinit$greater$default$9() {
        return RocksDBStateStoreChangeDataReader$.MODULE$.$lessinit$greater$default$9();
    }

    @Override
    public Tuple2<Object, Option<String>>[] versionsAndUniqueIds() {
        return this.versionsAndUniqueIds;
    }

    @Override
    public String changelogSuffix() {
        return this.changelogSuffix;
    }

    public Tuple4<Enumeration.Value, UnsafeRow, UnsafeRow, Object> getNext() {
        Tuple3 currRecord = null;
        Tuple3<RocksDBKeyStateEncoder, RocksDBValueStateEncoder, Object> currEncoder = this.keyValueEncoderMap.get(this.colFamilyNameOpt.getOrElse((Function0 & Serializable)() -> StateStore$.MODULE$.DEFAULT_COL_FAMILY_NAME()));
        if (this.colFamilyNameOpt.isDefined()) {
            while (currRecord == null) {
                Tuple3 result;
                StateStoreChangelogReader reader = this.currentChangelogReader();
                if (reader == null) {
                    return null;
                }
                Tuple3 nextRecord = (Tuple3)reader.next();
                byte[] colFamilyIdBytes = RocksDBStateStoreProvider$.MODULE$.getColumnFamilyIdAsBytes(BoxesRunTime.unboxToShort((Object)currEncoder._3()));
                int endIndex = ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.byteArrayOps(colFamilyIdBytes));
                if (!Arrays.equals((byte[])nextRecord._2(), 0, endIndex, colFamilyIdBytes, 0, endIndex)) continue;
                byte[] extractedKey = RocksDBStateStoreProvider$.MODULE$.decodeStateRowWithPrefix((byte[])nextRecord._2());
                currRecord = result = new Tuple3(nextRecord._1(), (Object)extractedKey, nextRecord._3());
            }
        } else {
            StateStoreChangelogReader reader = this.currentChangelogReader();
            if (reader == null) {
                return null;
            }
            currRecord = (Tuple3)reader.next();
        }
        UnsafeRow keyRow = ((RocksDBKeyStateEncoder)currEncoder._1()).decodeKey((byte[])currRecord._2());
        if (currRecord._3() == null) {
            return new Tuple4(currRecord._1(), (Object)keyRow, null, (Object)BoxesRunTime.boxToLong((long)(this.currentChangelogVersion() - 1L)));
        }
        UnsafeRow valueRow = ((RocksDBValueStateEncoder)currEncoder._2()).decodeValue((byte[])currRecord._3());
        return new Tuple4(currRecord._1(), (Object)keyRow, (Object)valueRow, (Object)BoxesRunTime.boxToLong((long)(this.currentChangelogVersion() - 1L)));
    }

    public static final /* synthetic */ Tuple2 $anonfun$versionsAndUniqueIds$3(long x$20) {
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)x$20), (Object)None$.MODULE$);
    }

    public RocksDBStateStoreChangeDataReader(CheckpointFileManager fm, RocksDB rocksDB, Path stateLocation, long startVersion, long endVersion, Option<String> endVersionStateStoreCkptId, CompressionCodec compressionCodec, ConcurrentHashMap<String, Tuple3<RocksDBKeyStateEncoder, RocksDBValueStateEncoder, Object>> keyValueEncoderMap, Option<String> colFamilyNameOpt) {
        Tuple2[] tuple2Array;
        this.keyValueEncoderMap = keyValueEncoderMap;
        this.colFamilyNameOpt = colFamilyNameOpt;
        super(fm, stateLocation, startVersion, endVersion, compressionCodec, colFamilyNameOpt);
        if (endVersionStateStoreCkptId.isDefined()) {
            LineageItem[] fullVersionLineage = rocksDB.getFullLineage(startVersion, endVersion, endVersionStateStoreCkptId);
            tuple2Array = (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])fullVersionLineage), (Function1 & Serializable)x$19 -> BoxesRunTime.boxToLong((long)x$19.version()), (Ordering)Ordering.Long$.MODULE$)), (Function1 & Serializable)item -> new Tuple2((Object)BoxesRunTime.boxToLong((long)item.version()), (Object)new Some((Object)item.checkpointUniqueId())), ClassTag$.MODULE$.apply(Tuple2.class));
        } else {
            tuple2Array = (Tuple2[])((IterableOnceOps)new RichLong(Predef$.MODULE$.longWrapper(startVersion)).to((Object)BoxesRunTime.boxToLong((long)endVersion)).map((Function1 & Serializable)x$20 -> RocksDBStateStoreChangeDataReader.$anonfun$versionsAndUniqueIds$3(BoxesRunTime.unboxToLong((Object)x$20)))).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        }
        this.versionsAndUniqueIds = tuple2Array;
        this.changelogSuffix = "changelog";
    }
}

