% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/mllib_regression.R
\name{spark.lm}
\alias{spark.lm}
\alias{spark.lm,SparkDataFrame,formula-method}
\alias{summary,LinearRegressionModel-method}
\alias{predict,LinearRegressionModel-method}
\alias{predict,LinearRegressionModel,SparkDataFrame-method}
\alias{write.ml,LinearRegressionModel,character-method}
\title{Linear Regression Model}
\usage{
spark.lm(data, formula, ...)

\S4method{spark.lm}{SparkDataFrame,formula}(
  data,
  formula,
  maxIter = 100L,
  regParam = 0,
  elasticNetParam = 0,
  tol = 1e-06,
  standardization = TRUE,
  solver = c("auto", "l-bfgs", "normal"),
  weightCol = NULL,
  aggregationDepth = 2L,
  loss = c("squaredError", "huber"),
  epsilon = 1.35,
  stringIndexerOrderType = c("frequencyDesc", "frequencyAsc", "alphabetDesc",
    "alphabetAsc")
)

\S4method{summary}{LinearRegressionModel}(object)

\S4method{predict}{LinearRegressionModel}(object, newData)

\S4method{write.ml}{LinearRegressionModel,character}(object, path, overwrite = FALSE)
}
\arguments{
\item{data}{a \code{SparkDataFrame} of observations and labels for model fitting.}

\item{formula}{a symbolic description of the model to be fitted. Currently only a few formula
operators are supported, including '~', '.', ':', '+', and '-'.}

\item{...}{additional arguments passed to the method.}

\item{maxIter}{maximum iteration number.}

\item{regParam}{the regularization parameter.}

\item{elasticNetParam}{the ElasticNet mixing parameter, in range [0, 1].
For alpha = 0, the penalty is an L2 penalty. For alpha = 1, it is an L1 penalty.}

\item{tol}{convergence tolerance of iterations.}

\item{standardization}{whether to standardize the training features before fitting the model.}

\item{solver}{The solver algorithm for optimization.
Supported options: "l-bfgs", "normal" and "auto".}

\item{weightCol}{weight column name.}

\item{aggregationDepth}{suggested depth for treeAggregate (>= 2).}

\item{loss}{the loss function to be optimized. Supported options: "squaredError" and "huber".}

\item{epsilon}{the shape parameter to control the amount of robustness.}

\item{stringIndexerOrderType}{how to order categories of a string feature column. This is used to
decide the base level of a string feature as the last category
after ordering is dropped when encoding strings. Supported options
are "frequencyDesc", "frequencyAsc", "alphabetDesc", and
"alphabetAsc". The default value is "frequencyDesc". When the
ordering is set to "alphabetDesc", this drops the same category
as R when encoding strings.}

\item{object}{a Linear Regression Model model fitted by \code{spark.lm}.}

\item{newData}{a SparkDataFrame for testing.}

\item{path}{The directory where the model is saved.}

\item{overwrite}{Overwrites or not if the output path already exists. Default is FALSE
which means throw exception if the output path exists.}
}
\value{
\code{spark.lm} returns a fitted Linear Regression Model.

\code{summary} returns summary information of the fitted model, which is a list.

\code{predict} returns the predicted values based on a LinearRegressionModel.
}
\description{
\code{spark.lm} fits a linear regression model against a SparkDataFrame.
Users can call \code{summary} to print a summary of the fitted model,
\code{predict} to make predictions on new data,
and \code{write.ml}/\code{read.ml} to save/load fitted models.
}
\note{
spark.lm since 3.1.0

summary(LinearRegressionModel) since 3.1.0

predict(LinearRegressionModel) since 3.1.0

write.ml(LinearRegressionModel, character) since 3.1.0
}
\examples{
\dontrun{
df <- read.df("data/mllib/sample_linear_regression_data.txt", source = "libsvm")

# fit Linear Regression Model
model <- spark.lm(df, label ~ features, regParam = 0.01, maxIter = 1)

# get the summary of the model
summary(model)

# make predictions
predictions <- predict(model, df)

# save and load the model
path <- "path/to/model"
write.ml(model, path)
savedModel <- read.ml(path)
summary(savedModel)
}
}
\seealso{
\link{read.ml}
}
