/*
 * Decompiled with CFR 0.152.
 */
package io.fury.collection;

import java.util.Arrays;

public final class ObjectArray {
    private static final int COPY_THRESHOLD = 128;
    private static final int NIL_ARRAY_SIZE = 1024;
    private static final Object[] NIL_ARRAY = new Object[1024];
    public Object[] objects;
    public int size;

    public ObjectArray() {
        this(0);
    }

    public ObjectArray(int initialCapacity) {
        this.objects = new Object[initialCapacity];
    }

    public void add(Object element) {
        int size;
        Object[] objects = this.objects;
        if (objects.length <= (size = this.size++)) {
            Object[] tmp = new Object[(size + 1) * 2];
            System.arraycopy(objects, 0, tmp, 0, objects.length);
            objects = tmp;
            this.objects = tmp;
        }
        objects[size] = element;
    }

    public void set(int index, Object element) {
        this.objects[index] = element;
    }

    public Object get(int index) {
        return this.objects[index];
    }

    public Object popOrNull() {
        int size = this.size;
        if (size == 0) {
            return null;
        }
        this.size = --size;
        return this.objects[size];
    }

    public void clear() {
        ObjectArray.clearObjectArray(this.objects, 0, this.size);
        this.size = 0;
    }

    public void clearApproximate(int maximumCapacity) {
        if (this.objects.length < maximumCapacity) {
            this.clear();
        } else {
            this.size = 0;
            this.objects = new Object[maximumCapacity];
        }
    }

    public int size() {
        return this.size;
    }

    public static void clearObjectArray(Object[] objects, int start, int size) {
        if (size < 128) {
            Arrays.fill(objects, start, size, null);
        } else if (size < 1024) {
            System.arraycopy(NIL_ARRAY, 0, objects, start, size);
        } else {
            while (size > 1024) {
                System.arraycopy(NIL_ARRAY, 0, objects, start, 1024);
                size -= 1024;
                start += 1024;
            }
            System.arraycopy(NIL_ARRAY, 0, objects, start, size);
        }
    }
}

