/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data.array;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import com.clickhouse.client.data.ClickHouseObjectValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ClickHouseByteArrayValue
extends ClickHouseObjectValue<byte[]> {
    private static final String TYPE_NAME = "byte[]";

    public static ClickHouseByteArrayValue ofEmpty() {
        return ClickHouseByteArrayValue.of(ClickHouseValues.EMPTY_BYTE_ARRAY);
    }

    public static ClickHouseByteArrayValue of(byte[] value) {
        return ClickHouseByteArrayValue.of(null, value);
    }

    public static ClickHouseByteArrayValue of(ClickHouseValue ref, byte[] value) {
        return ref instanceof ClickHouseByteArrayValue ? ((ClickHouseByteArrayValue)ref).set(value) : new ClickHouseByteArrayValue(value);
    }

    protected ClickHouseByteArrayValue(byte[] value) {
        super(value);
    }

    protected ClickHouseByteArrayValue set(byte[] value) {
        super.set(ClickHouseChecker.nonNull(value, "Array"));
        return this;
    }

    @Override
    public Object[] asArray() {
        byte[] v = (byte[])this.getValue();
        int len = v.length;
        Object[] array = new Byte[len];
        for (int i = 0; i < len; ++i) {
            array[i] = v[i];
        }
        return array;
    }

    public <E> E[] asArray(Class<E> clazz) {
        byte[] v = (byte[])this.getValue();
        int len = v.length;
        if (clazz == Boolean.class) {
            Boolean[] array = new Boolean[len];
            for (int i = 0; i < len; ++i) {
                array[i] = v[i] == 1 ? Boolean.TRUE : Boolean.FALSE;
            }
            return array;
        }
        E[] array = ClickHouseValues.createObjectArray(clazz, len, 1);
        for (int i = 0; i < len; ++i) {
            array[i] = clazz.cast(v[i]);
        }
        return array;
    }

    @Override
    public <K, V> Map<K, V> asMap(Class<K> keyClass, Class<V> valueClass) {
        if (keyClass == null || valueClass == null) {
            throw new IllegalArgumentException("Non-null key and value classes are required");
        }
        byte[] v = (byte[])this.getValue();
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        for (int i = 0; i < v.length; ++i) {
            map.put(keyClass.cast(i + 1), valueClass.cast(v[i]));
        }
        return map;
    }

    @Override
    public String asString(int length, Charset charset) {
        String str = Arrays.toString((byte[])this.getValue());
        if (length > 0) {
            ClickHouseChecker.notWithDifferentLength(str.getBytes(charset == null ? StandardCharsets.UTF_8 : charset), length);
        }
        return str;
    }

    @Override
    public ClickHouseByteArrayValue copy(boolean deep) {
        if (!deep) {
            return new ClickHouseByteArrayValue((byte[])this.getValue());
        }
        byte[] value = (byte[])this.getValue();
        return new ClickHouseByteArrayValue(Arrays.copyOf(value, value.length));
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isNullOrEmpty() {
        return ((byte[])this.getValue()).length == 0;
    }

    @Override
    public ClickHouseByteArrayValue resetToDefault() {
        this.set(ClickHouseValues.EMPTY_BYTE_ARRAY);
        return this;
    }

    @Override
    public ClickHouseByteArrayValue resetToNullOrEmpty() {
        return this.resetToDefault();
    }

    @Override
    public String toSqlExpression() {
        int len;
        byte[] value = (byte[])this.getValue();
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder().append('[');
        for (int i = 0; i < len; ++i) {
            builder.append(value[i]).append(',');
        }
        builder.setLength(builder.length() - 1);
        return builder.append(']').toString();
    }

    @Override
    public ClickHouseByteArrayValue update(boolean[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        byte[] v = new byte[len];
        for (int i = 0; i < len; ++i) {
            v[i] = value[i] ? (byte)1 : 0;
        }
        return this.set(v);
    }

    @Override
    public ClickHouseByteArrayValue update(char[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        byte[] v = new byte[len];
        for (int i = 0; i < len; ++i) {
            v[i] = (byte)value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseByteArrayValue update(byte value) {
        return this.set(new byte[]{value});
    }

    @Override
    public ClickHouseByteArrayValue update(byte[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        return this.set(Arrays.copyOf(value, len));
    }

    @Override
    public ClickHouseByteArrayValue update(short value) {
        return this.set(new byte[]{(byte)value});
    }

    @Override
    public ClickHouseByteArrayValue update(short[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        byte[] v = new byte[len];
        for (int i = 0; i < len; ++i) {
            v[i] = (byte)value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseByteArrayValue update(int value) {
        return this.set(new byte[]{(byte)value});
    }

    @Override
    public ClickHouseByteArrayValue update(int[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        byte[] v = new byte[len];
        for (int i = 0; i < len; ++i) {
            v[i] = (byte)value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseByteArrayValue update(long value) {
        return this.set(new byte[]{(byte)value});
    }

    @Override
    public ClickHouseByteArrayValue update(long[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        byte[] v = new byte[len];
        for (int i = 0; i < len; ++i) {
            v[i] = (byte)value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseByteArrayValue update(float value) {
        return this.set(new byte[]{(byte)value});
    }

    @Override
    public ClickHouseByteArrayValue update(float[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        byte[] v = new byte[len];
        for (int i = 0; i < len; ++i) {
            v[i] = (byte)value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseByteArrayValue update(double value) {
        return this.set(new byte[]{(byte)value});
    }

    @Override
    public ClickHouseByteArrayValue update(double[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        byte[] v = new byte[len];
        for (int i = 0; i < len; ++i) {
            v[i] = (byte)value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseByteArrayValue update(BigInteger value) {
        byte[] byArray;
        if (value == null) {
            byArray = ClickHouseValues.EMPTY_BYTE_ARRAY;
        } else {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = value.byteValue();
        }
        return this.set(byArray);
    }

    @Override
    public ClickHouseByteArrayValue update(BigDecimal value) {
        byte[] byArray;
        if (value == null) {
            byArray = ClickHouseValues.EMPTY_BYTE_ARRAY;
        } else {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = value.byteValue();
        }
        return this.set(byArray);
    }

    @Override
    public ClickHouseByteArrayValue update(Enum<?> value) {
        byte[] byArray;
        if (value == null) {
            byArray = ClickHouseValues.EMPTY_BYTE_ARRAY;
        } else {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = (byte)value.ordinal();
        }
        return this.set(byArray);
    }

    @Override
    public ClickHouseByteArrayValue update(Inet4Address value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        throw this.newUnsupportedException("Inet4Address", TYPE_NAME);
    }

    @Override
    public ClickHouseByteArrayValue update(Inet6Address value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        throw this.newUnsupportedException("Inet6Address", TYPE_NAME);
    }

    @Override
    public ClickHouseByteArrayValue update(LocalDate value) {
        byte[] byArray;
        if (value == null) {
            byArray = ClickHouseValues.EMPTY_BYTE_ARRAY;
        } else {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = (byte)value.toEpochDay();
        }
        return this.set(byArray);
    }

    @Override
    public ClickHouseByteArrayValue update(LocalTime value) {
        byte[] byArray;
        if (value == null) {
            byArray = ClickHouseValues.EMPTY_BYTE_ARRAY;
        } else {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = (byte)value.toSecondOfDay();
        }
        return this.set(byArray);
    }

    @Override
    public ClickHouseByteArrayValue update(LocalDateTime value) {
        byte[] byArray;
        if (value == null) {
            byArray = ClickHouseValues.EMPTY_BYTE_ARRAY;
        } else {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = (byte)value.toEpochSecond(ZoneOffset.UTC);
        }
        return this.set(byArray);
    }

    @Override
    public ClickHouseByteArrayValue update(Collection<?> value) {
        int size;
        int n = size = value == null ? 0 : value.size();
        if (size == 0) {
            return this.resetToNullOrEmpty();
        }
        byte[] v = new byte[size];
        int index = 0;
        for (Object o : value) {
            v[index++] = o == null ? (byte)0 : ((Number)o).byteValue();
        }
        return this.set(v);
    }

    @Override
    public ClickHouseByteArrayValue update(Enumeration<?> value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        LinkedList<Number> v = new LinkedList<Number>();
        while (value.hasMoreElements()) {
            v.add((Number)value.nextElement());
        }
        byte[] values = new byte[v.size()];
        int index = 0;
        for (Number n : v) {
            values[index++] = n == null ? (byte)0 : n.byteValue();
        }
        return this.set(values);
    }

    @Override
    public ClickHouseByteArrayValue update(Map<?, ?> value) {
        int size;
        int n = size = value == null ? 0 : value.size();
        if (size == 0) {
            return this.resetToNullOrEmpty();
        }
        byte[] v = new byte[size];
        int index = 0;
        for (Map.Entry<?, ?> e : value.entrySet()) {
            Object o = e.getValue();
            v[index++] = o == null ? (byte)0 : ((Number)e.getValue()).byteValue();
        }
        return this.set(v);
    }

    @Override
    public ClickHouseByteArrayValue update(String value) {
        if (ClickHouseChecker.isNullOrBlank(value)) {
            this.set(ClickHouseValues.EMPTY_BYTE_ARRAY);
        } else {
            List<String> list = ClickHouseUtils.readValueArray(value, 0, value.length());
            if (list.isEmpty()) {
                this.set(ClickHouseValues.EMPTY_BYTE_ARRAY);
            } else {
                byte[] arr = new byte[list.size()];
                int index = 0;
                for (String v : list) {
                    arr[index++] = v == null ? (byte)0 : Byte.parseByte(v);
                }
                this.set(arr);
            }
        }
        return this;
    }

    @Override
    public ClickHouseByteArrayValue update(UUID value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        throw this.newUnsupportedException("UUID", TYPE_NAME);
    }

    @Override
    public ClickHouseByteArrayValue update(ClickHouseValue value) {
        if (value == null || value.isNullOrEmpty()) {
            return this.resetToNullOrEmpty();
        }
        if (value instanceof ClickHouseByteArrayValue) {
            this.set((byte[])((ClickHouseByteArrayValue)value).getValue());
        } else {
            this.update(value.asArray());
        }
        return this;
    }

    @Override
    public ClickHouseByteArrayValue update(Object[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        if (value instanceof Boolean[]) {
            byte[] values = new byte[len];
            for (int i = 0; i < len; ++i) {
                values[i] = Boolean.TRUE.equals(value[i]) ? (byte)1 : 0;
            }
            this.set(values);
        } else {
            byte[] values = new byte[len];
            for (int i = 0; i < len; ++i) {
                Object o = value[i];
                values[i] = o == null ? (byte)0 : ((Number)o).byteValue();
            }
            this.set(values);
        }
        return this;
    }

    @Override
    public ClickHouseValue updateUnknown(Object value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        if (value instanceof Number) {
            return this.set(new byte[]{((Number)value).byteValue()});
        }
        throw this.newUnsupportedException(value.getClass().getName(), TYPE_NAME);
    }

    @Override
    public ClickHouseByteArrayValue update(Object value) {
        if (value instanceof byte[]) {
            this.set((byte[])value);
        } else {
            super.update(value);
        }
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Arrays.equals((byte[])this.getValue(), (byte[])((ClickHouseByteArrayValue)obj).getValue());
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode((byte[])this.getValue());
    }
}

