/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.AcknowledgeState;
import co.elastic.clients.elasticsearch.watcher.ExecutionState;
import co.elastic.clients.elasticsearch.watcher.ThrottleState;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ActionStatus
implements JsonpSerializable {
    private final AcknowledgeState ack;
    @Nullable
    private final ExecutionState lastExecution;
    @Nullable
    private final ExecutionState lastSuccessfulExecution;
    @Nullable
    private final ThrottleState lastThrottle;
    public static final JsonpDeserializer<ActionStatus> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ActionStatus::setupActionStatusDeserializer);

    private ActionStatus(Builder builder) {
        this.ack = ApiTypeHelper.requireNonNull(builder.ack, this, "ack");
        this.lastExecution = builder.lastExecution;
        this.lastSuccessfulExecution = builder.lastSuccessfulExecution;
        this.lastThrottle = builder.lastThrottle;
    }

    public static ActionStatus of(Function<Builder, ObjectBuilder<ActionStatus>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final AcknowledgeState ack() {
        return this.ack;
    }

    @Nullable
    public final ExecutionState lastExecution() {
        return this.lastExecution;
    }

    @Nullable
    public final ExecutionState lastSuccessfulExecution() {
        return this.lastSuccessfulExecution;
    }

    @Nullable
    public final ThrottleState lastThrottle() {
        return this.lastThrottle;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("ack");
        this.ack.serialize(generator, mapper);
        if (this.lastExecution != null) {
            generator.writeKey("last_execution");
            this.lastExecution.serialize(generator, mapper);
        }
        if (this.lastSuccessfulExecution != null) {
            generator.writeKey("last_successful_execution");
            this.lastSuccessfulExecution.serialize(generator, mapper);
        }
        if (this.lastThrottle != null) {
            generator.writeKey("last_throttle");
            this.lastThrottle.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupActionStatusDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::ack, AcknowledgeState._DESERIALIZER, "ack");
        op.add(Builder::lastExecution, ExecutionState._DESERIALIZER, "last_execution");
        op.add(Builder::lastSuccessfulExecution, ExecutionState._DESERIALIZER, "last_successful_execution");
        op.add(Builder::lastThrottle, ThrottleState._DESERIALIZER, "last_throttle");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ActionStatus> {
        private AcknowledgeState ack;
        @Nullable
        private ExecutionState lastExecution;
        @Nullable
        private ExecutionState lastSuccessfulExecution;
        @Nullable
        private ThrottleState lastThrottle;

        public final Builder ack(AcknowledgeState value) {
            this.ack = value;
            return this;
        }

        public final Builder ack(Function<AcknowledgeState.Builder, ObjectBuilder<AcknowledgeState>> fn) {
            return this.ack(fn.apply(new AcknowledgeState.Builder()).build());
        }

        public final Builder lastExecution(@Nullable ExecutionState value) {
            this.lastExecution = value;
            return this;
        }

        public final Builder lastExecution(Function<ExecutionState.Builder, ObjectBuilder<ExecutionState>> fn) {
            return this.lastExecution(fn.apply(new ExecutionState.Builder()).build());
        }

        public final Builder lastSuccessfulExecution(@Nullable ExecutionState value) {
            this.lastSuccessfulExecution = value;
            return this;
        }

        public final Builder lastSuccessfulExecution(Function<ExecutionState.Builder, ObjectBuilder<ExecutionState>> fn) {
            return this.lastSuccessfulExecution(fn.apply(new ExecutionState.Builder()).build());
        }

        public final Builder lastThrottle(@Nullable ThrottleState value) {
            this.lastThrottle = value;
            return this;
        }

        public final Builder lastThrottle(Function<ThrottleState.Builder, ObjectBuilder<ThrottleState>> fn) {
            return this.lastThrottle(fn.apply(new ThrottleState.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ActionStatus build() {
            this._checkSingleUse();
            return new ActionStatus(this);
        }
    }
}

