/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.ui;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.configuration.ConfigurationAwareModule;
import io.airlift.http.server.HttpServer;
import io.trino.server.security.Authenticator;
import io.trino.server.security.CertificateAuthenticator;
import io.trino.server.security.CertificateConfig;
import io.trino.server.security.KerberosAuthenticator;
import io.trino.server.security.KerberosConfig;
import io.trino.server.security.SecurityConfig;
import io.trino.server.security.jwt.JwtAuthenticator;
import io.trino.server.security.jwt.JwtAuthenticatorSupportModule;
import io.trino.server.ui.FixedUiAuthenticatorModule;
import io.trino.server.ui.ForWebUi;
import io.trino.server.ui.FormUiAuthenticatorModule;
import io.trino.server.ui.OAuth2WebUiModule;
import io.trino.server.ui.WebUiAuthenticationConfig;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class WebUiAuthenticationModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(WebUiAuthenticationConfig.class);
        this.installWebUiAuthenticator("insecure", new FormUiAuthenticatorModule(false));
        this.installWebUiAuthenticator("form", new FormUiAuthenticatorModule(true));
        this.installWebUiAuthenticator("fixed", new FixedUiAuthenticatorModule());
        this.installWebUiAuthenticator("oauth2", (Module)new OAuth2WebUiModule());
        this.install(WebUiAuthenticationModule.webUiAuthenticator("certificate", CertificateAuthenticator.class, certificateBinder -> {
            OptionalBinder.newOptionalBinder((Binder)certificateBinder, HttpServer.ClientCertificate.class).setBinding().toInstance((Object)HttpServer.ClientCertificate.REQUESTED);
            ConfigBinder.configBinder((Binder)certificateBinder).bindConfig(CertificateConfig.class);
        }));
        this.installWebUiAuthenticator("kerberos", KerberosAuthenticator.class, KerberosConfig.class);
        this.install(WebUiAuthenticationModule.webUiAuthenticator("jwt", JwtAuthenticator.class, (Module)new JwtAuthenticatorSupportModule()));
    }

    private void installWebUiAuthenticator(String type, Module module) {
        this.install(WebUiAuthenticationModule.webUiAuthenticator(type, module));
    }

    private void installWebUiAuthenticator(String name, Class<? extends Authenticator> authenticator, Class<?> config) {
        this.install(WebUiAuthenticationModule.webUiAuthenticator(name, authenticator, binder -> ConfigBinder.configBinder((Binder)binder).bindConfig(config)));
    }

    public static Module webUiAuthenticator(String type, Module module) {
        return new ConditionalWebUiAuthenticationModule(type, module);
    }

    public static Module webUiAuthenticator(String name, Class<? extends Authenticator> clazz, Module module) {
        Preconditions.checkArgument((boolean)name.toLowerCase(Locale.ENGLISH).equals(name), (String)"name is not lower case: %s", (Object)name);
        Module authModule = binder -> {
            binder.install((Module)new FormUiAuthenticatorModule(false));
            OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(Authenticator.class, ForWebUi.class)).setBinding().to(clazz).in(Scopes.SINGLETON);
        };
        return WebUiAuthenticationModule.webUiAuthenticator(name, ConfigurationAwareModule.combine((Module[])new Module[]{module, authModule}));
    }

    private static class ConditionalWebUiAuthenticationModule
    extends AbstractConfigurationAwareModule {
        private final String type;
        private final Module module;

        public ConditionalWebUiAuthenticationModule(String type, Module module) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.module = Objects.requireNonNull(module, "module is null");
        }

        protected void setup(Binder binder) {
            if (this.type.equals(this.getAuthenticationType())) {
                this.install(this.module);
            }
        }

        private String getAuthenticationType() {
            String authentication = ((WebUiAuthenticationConfig)this.buildConfigObject(WebUiAuthenticationConfig.class)).getAuthentication();
            if (authentication != null) {
                return authentication;
            }
            List authenticationTypes = (List)((SecurityConfig)this.buildConfigObject(SecurityConfig.class)).getAuthenticationTypes().stream().map(type -> type.toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList());
            if (authenticationTypes.contains("password")) {
                return "form";
            }
            return (String)authenticationTypes.stream().findFirst().orElseThrow(() -> new IllegalArgumentException("authenticatorTypes is empty"));
        }
    }
}

