/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.unnest;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.unnest.ArrayOfRowsUnnester;
import io.trino.operator.unnest.ArrayUnnester;
import io.trino.operator.unnest.MapUnnester;
import io.trino.operator.unnest.ReplicatedBlockBuilder;
import io.trino.operator.unnest.Unnester;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.PageBuilderStatus;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class UnnestOperator
implements Operator {
    private static final int MAX_ROWS_PER_BLOCK = 1000;
    private static final int MAX_BYTES_PER_PAGE = 0x100000;
    private static final double OVERFLOW_SKEW = 1.25;
    private static final int estimatedMaxRowsPerBlock = (int)Math.ceil(1250.0);
    private final OperatorContext operatorContext;
    private final List<Integer> replicateChannels;
    private final List<Type> replicateTypes;
    private final List<Integer> unnestChannels;
    private final List<Type> unnestTypes;
    private final boolean withOrdinality;
    private final boolean outer;
    private boolean finishing;
    private Page currentPage;
    private int currentPosition;
    private final List<Unnester> unnesters;
    private final List<ReplicatedBlockBuilder> replicatedBlockBuilders;
    private BlockBuilder ordinalityBlockBuilder;
    private final int outputChannelCount;

    public UnnestOperator(OperatorContext operatorContext, List<Integer> replicateChannels, List<Type> replicateTypes, List<Integer> unnestChannels, List<Type> unnestTypes, boolean withOrdinality, boolean outer) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.replicateChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(replicateChannels, "replicateChannels is null"));
        this.replicateTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(replicateTypes, "replicateTypes is null"));
        Preconditions.checkArgument((replicateChannels.size() == replicateTypes.size() ? 1 : 0) != 0, (Object)"replicate channels or types has wrong size");
        this.replicatedBlockBuilders = (List)replicateTypes.stream().map(type -> new ReplicatedBlockBuilder()).collect(ImmutableList.toImmutableList());
        this.unnestChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(unnestChannels, "unnestChannels is null"));
        this.unnestTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(unnestTypes, "unnestTypes is null"));
        Preconditions.checkArgument((unnestChannels.size() == unnestTypes.size() ? 1 : 0) != 0, (Object)"unnest channels or types has wrong size");
        this.unnesters = (List)unnestTypes.stream().map(UnnestOperator::createUnnester).collect(ImmutableList.toImmutableList());
        int unnestOutputChannelCount = this.unnesters.stream().mapToInt(Unnester::getChannelCount).sum();
        this.withOrdinality = withOrdinality;
        this.outer = outer;
        this.outputChannelCount = unnestOutputChannelCount + replicateTypes.size() + (withOrdinality ? 1 : 0);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.currentPage == null;
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && this.currentPage == null;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((this.currentPage == null ? 1 : 0) != 0, (Object)"currentPage is not null");
        this.currentPage = page;
        this.currentPosition = 0;
        this.resetBlockBuilders();
    }

    private void resetBlockBuilders() {
        int i;
        for (i = 0; i < this.replicateTypes.size(); ++i) {
            Block newInputBlock = this.currentPage.getBlock(this.replicateChannels.get(i).intValue());
            this.replicatedBlockBuilders.get(i).resetInputBlock(newInputBlock);
        }
        for (i = 0; i < this.unnestTypes.size(); ++i) {
            int inputChannel = this.unnestChannels.get(i);
            Block unnestChannelInputBlock = this.currentPage.getBlock(inputChannel);
            this.unnesters.get(i).resetInput(unnestChannelInputBlock);
        }
    }

    @Override
    public Page getOutput() {
        if (this.currentPage == null) {
            return null;
        }
        PageBuilderStatus pageBuilderStatus = new PageBuilderStatus(0x100000);
        this.prepareForNewOutput(pageBuilderStatus);
        int outputRowCount = 0;
        while (this.currentPosition < this.currentPage.getPositionCount()) {
            ++this.currentPosition;
            if ((outputRowCount += this.processCurrentPosition()) < 1000 && !pageBuilderStatus.isFull()) continue;
        }
        Block[] outputBlocks = this.buildOutputBlocks();
        if (this.currentPosition == this.currentPage.getPositionCount()) {
            this.currentPage = null;
            this.currentPosition = 0;
        }
        return new Page(outputBlocks);
    }

    private int processCurrentPosition() {
        int maxEntries = this.getCurrentMaxEntries();
        if (this.outer && maxEntries == 0) {
            this.replicatedBlockBuilders.forEach(blockBuilder -> blockBuilder.appendRepeated(this.currentPosition, 1));
            this.unnesters.forEach(unnester -> {
                unnester.appendNulls(1);
                unnester.advance();
            });
            if (this.withOrdinality) {
                this.ordinalityBlockBuilder.appendNull();
            }
            return 1;
        }
        this.replicatedBlockBuilders.forEach(blockBuilder -> blockBuilder.appendRepeated(this.currentPosition, maxEntries));
        this.unnesters.forEach(unnester -> unnester.processCurrentAndAdvance(maxEntries));
        if (this.withOrdinality) {
            for (long ordinalityCount = 1L; ordinalityCount <= (long)maxEntries; ++ordinalityCount) {
                BigintType.BIGINT.writeLong(this.ordinalityBlockBuilder, ordinalityCount);
            }
        }
        return maxEntries;
    }

    private int getCurrentMaxEntries() {
        return this.unnesters.stream().mapToInt(Unnester::getCurrentUnnestedLength).max().orElse(0);
    }

    private void prepareForNewOutput(PageBuilderStatus pageBuilderStatus) {
        this.unnesters.forEach(unnester -> unnester.startNewOutput(pageBuilderStatus, estimatedMaxRowsPerBlock));
        this.replicatedBlockBuilders.forEach(replicatedBlockBuilder -> replicatedBlockBuilder.startNewOutput(estimatedMaxRowsPerBlock));
        if (this.withOrdinality) {
            this.ordinalityBlockBuilder = BigintType.BIGINT.createBlockBuilder(pageBuilderStatus.createBlockBuilderStatus(), estimatedMaxRowsPerBlock);
        }
    }

    private Block[] buildOutputBlocks() {
        Block[] outputBlocks = new Block[this.outputChannelCount];
        int offset = 0;
        for (int replicateIndex = 0; replicateIndex < this.replicateTypes.size(); ++replicateIndex) {
            outputBlocks[offset++] = this.replicatedBlockBuilders.get(replicateIndex).buildOutputAndFlush();
        }
        for (int unnestIndex = 0; unnestIndex < this.unnesters.size(); ++unnestIndex) {
            Unnester unnester = this.unnesters.get(unnestIndex);
            Block[] block = unnester.buildOutputBlocksAndFlush();
            for (int j = 0; j < unnester.getChannelCount(); ++j) {
                outputBlocks[offset++] = block[j];
            }
        }
        if (this.withOrdinality) {
            outputBlocks[offset] = this.ordinalityBlockBuilder.build();
        }
        return outputBlocks;
    }

    private static Unnester createUnnester(Type nestedType) {
        if (nestedType instanceof ArrayType) {
            Type elementType = ((ArrayType)nestedType).getElementType();
            if (elementType instanceof RowType) {
                return new ArrayOfRowsUnnester((RowType)elementType);
            }
            return new ArrayUnnester(elementType);
        }
        if (nestedType instanceof MapType) {
            Type keyType = ((MapType)nestedType).getKeyType();
            Type valueType = ((MapType)nestedType).getValueType();
            return new MapUnnester(keyType, valueType);
        }
        throw new IllegalArgumentException("Cannot unnest type: " + nestedType);
    }

    public static class UnnestOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Integer> replicateChannels;
        private final List<Type> replicateTypes;
        private final List<Integer> unnestChannels;
        private final List<Type> unnestTypes;
        private final boolean withOrdinality;
        private final boolean outer;
        private boolean closed;

        public UnnestOperatorFactory(int operatorId, PlanNodeId planNodeId, List<Integer> replicateChannels, List<Type> replicateTypes, List<Integer> unnestChannels, List<Type> unnestTypes, boolean withOrdinality, boolean outer) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.replicateChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(replicateChannels, "replicateChannels is null"));
            this.replicateTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(replicateTypes, "replicateTypes is null"));
            Preconditions.checkArgument((replicateChannels.size() == replicateTypes.size() ? 1 : 0) != 0, (Object)"replicateChannels and replicateTypes do not match");
            this.unnestChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(unnestChannels, "unnestChannels is null"));
            this.unnestTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(unnestTypes, "unnestTypes is null"));
            Preconditions.checkArgument((unnestChannels.size() == unnestTypes.size() ? 1 : 0) != 0, (Object)"unnestChannels and unnestTypes do not match");
            this.withOrdinality = withOrdinality;
            this.outer = outer;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, UnnestOperator.class.getSimpleName());
            return new UnnestOperator(operatorContext, this.replicateChannels, this.replicateTypes, this.unnestChannels, this.unnestTypes, this.withOrdinality, this.outer);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new UnnestOperatorFactory(this.operatorId, this.planNodeId, this.replicateChannels, this.replicateTypes, this.unnestChannels, this.unnestTypes, this.withOrdinality, this.outer);
        }
    }
}

