/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamp;

import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.LongTimestamp;

@ScalarOperator(value=OperatorType.CAST)
@ScalarFunction(value="date")
public final class TimestampToDateCast {
    private TimestampToDateCast() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="date")
    public static long cast(ConnectorSession session, @SqlType(value="timestamp(p)") long timestamp) {
        return Math.floorDiv(timestamp, 86400000000L);
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="date")
    public static long cast(ConnectorSession session, @SqlType(value="timestamp(p)") LongTimestamp timestamp) {
        return TimestampToDateCast.cast(session, timestamp.getEpochMicros());
    }
}

