/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.trino.operator.PagesIndex;
import io.trino.operator.SyntheticAddress;
import io.trino.spi.Page;
import io.trino.spi.PageSorter;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class PagesIndexPageSorter
implements PageSorter {
    private final PagesIndex.Factory pagesIndexFactory;

    @Inject
    public PagesIndexPageSorter(PagesIndex.Factory pagesIndexFactory) {
        this.pagesIndexFactory = Objects.requireNonNull(pagesIndexFactory, "pagesIndexFactory is null");
    }

    public long[] sort(List<Type> types, List<Page> pages, List<Integer> sortChannels, List<SortOrder> sortOrders, int expectedPositions) {
        PagesIndex pagesIndex = this.pagesIndexFactory.newPagesIndex(types, expectedPositions);
        pages.forEach(pagesIndex::addPage);
        pagesIndex.sort(sortChannels, sortOrders);
        return pagesIndex.getValueAddresses().toLongArray(null);
    }

    public int decodePageIndex(long address) {
        return SyntheticAddress.decodeSliceIndex(address);
    }

    public int decodePositionIndex(long address) {
        return SyntheticAddress.decodePosition(address);
    }
}

