/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.stats;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.stats.DecayCounter;
import io.airlift.stats.DecayTDigest;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.weakref.jmx.Managed;

@ThreadSafe
public class Distribution {
    @GuardedBy(value="this")
    private final DecayTDigest digest;
    private final DecayCounter total;

    public Distribution() {
        this(0.0);
    }

    public Distribution(double alpha) {
        this(new DecayTDigest(100.0, alpha), new DecayCounter(alpha));
    }

    private Distribution(DecayTDigest digest, DecayCounter total) {
        this.digest = Objects.requireNonNull(digest, "digest is null");
        this.total = Objects.requireNonNull(total, "total is null");
    }

    public synchronized void add(long value) {
        this.digest.add(value);
        this.total.add(value);
    }

    public synchronized void add(long value, long count) {
        this.digest.add(value, count);
        this.total.add(value * count);
    }

    public synchronized Distribution duplicate() {
        return new Distribution(this.digest.duplicate(), this.total.duplicate());
    }

    @Managed
    public synchronized double getCount() {
        return this.digest.getCount();
    }

    @Managed
    public synchronized double getTotal() {
        return this.total.getCount();
    }

    @Managed
    public synchronized double getP01() {
        return this.digest.valueAt(0.01);
    }

    @Managed
    public synchronized double getP05() {
        return this.digest.valueAt(0.05);
    }

    @Managed
    public synchronized double getP10() {
        return this.digest.valueAt(0.1);
    }

    @Managed
    public synchronized double getP25() {
        return this.digest.valueAt(0.25);
    }

    @Managed
    public synchronized double getP50() {
        return this.digest.valueAt(0.5);
    }

    @Managed
    public synchronized double getP75() {
        return this.digest.valueAt(0.75);
    }

    @Managed
    public synchronized double getP90() {
        return this.digest.valueAt(0.9);
    }

    @Managed
    public synchronized double getP95() {
        return this.digest.valueAt(0.95);
    }

    @Managed
    public synchronized double getP99() {
        return this.digest.valueAt(0.99);
    }

    @Managed
    public synchronized double getMin() {
        return this.digest.getMin();
    }

    @Managed
    public synchronized double getMax() {
        return this.digest.getMax();
    }

    @Managed
    public synchronized double getAvg() {
        return this.getTotal() / this.getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public Map<Double, Double> getPercentiles() {
        List<Double> values;
        ArrayList<Double> percentiles = new ArrayList<Double>(100);
        for (int i = 0; i < 100; ++i) {
            percentiles.add((double)i / 100.0);
        }
        Distribution distribution = this;
        synchronized (distribution) {
            values = this.digest.valuesAt(percentiles);
        }
        LinkedHashMap<Double, Double> result = new LinkedHashMap<Double, Double>(values.size());
        for (int i = 0; i < percentiles.size(); ++i) {
            result.put((Double)percentiles.get(i), values.get(i));
        }
        return result;
    }

    public synchronized List<Double> getPercentiles(List<Double> percentiles) {
        return this.digest.valuesAt(percentiles);
    }

    public synchronized DistributionSnapshot snapshot() {
        List<Double> quantiles = this.digest.valuesAt((List<Double>)ImmutableList.of((Object)0.01, (Object)0.05, (Object)0.1, (Object)0.25, (Object)0.5, (Object)0.75, (Object)0.9, (Object)0.95, (Object)0.99));
        return new DistributionSnapshot(this.getCount(), this.getTotal(), quantiles.get(0), quantiles.get(1), quantiles.get(2), quantiles.get(3), quantiles.get(4), quantiles.get(5), quantiles.get(6), quantiles.get(7), quantiles.get(8), this.getMin(), this.getMax(), this.getAvg());
    }

    public static class DistributionSnapshot {
        private final double count;
        private final double total;
        private final double p01;
        private final double p05;
        private final double p10;
        private final double p25;
        private final double p50;
        private final double p75;
        private final double p90;
        private final double p95;
        private final double p99;
        private final double min;
        private final double max;
        private final double avg;

        @JsonCreator
        public DistributionSnapshot(@JsonProperty(value="count") double count, @JsonProperty(value="total") double total, @JsonProperty(value="p01") double p01, @JsonProperty(value="p05") double p05, @JsonProperty(value="p10") double p10, @JsonProperty(value="p25") double p25, @JsonProperty(value="p50") double p50, @JsonProperty(value="p75") double p75, @JsonProperty(value="p90") double p90, @JsonProperty(value="p95") double p95, @JsonProperty(value="p99") double p99, @JsonProperty(value="min") double min, @JsonProperty(value="max") double max, @JsonProperty(value="avg") double avg) {
            this.count = count;
            this.total = total;
            this.p01 = p01;
            this.p05 = p05;
            this.p10 = p10;
            this.p25 = p25;
            this.p50 = p50;
            this.p75 = p75;
            this.p90 = p90;
            this.p95 = p95;
            this.p99 = p99;
            this.min = min;
            this.max = max;
            this.avg = avg;
        }

        @JsonProperty
        public double getCount() {
            return this.count;
        }

        @JsonProperty
        public double getTotal() {
            return this.total;
        }

        @JsonProperty
        public double getP01() {
            return this.p01;
        }

        @JsonProperty
        public double getP05() {
            return this.p05;
        }

        @JsonProperty
        public double getP10() {
            return this.p10;
        }

        @JsonProperty
        public double getP25() {
            return this.p25;
        }

        @JsonProperty
        public double getP50() {
            return this.p50;
        }

        @JsonProperty
        public double getP75() {
            return this.p75;
        }

        @JsonProperty
        public double getP90() {
            return this.p90;
        }

        @JsonProperty
        public double getP95() {
            return this.p95;
        }

        @JsonProperty
        public double getP99() {
            return this.p99;
        }

        @JsonProperty
        public double getMin() {
            return this.min;
        }

        @JsonProperty
        public double getMax() {
            return this.max;
        }

        @JsonProperty
        public double getAvg() {
            return this.avg;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("count", this.count).add("total", this.total).add("p01", this.p01).add("p05", this.p05).add("p10", this.p10).add("p25", this.p25).add("p50", this.p50).add("p75", this.p75).add("p90", this.p90).add("p95", this.p95).add("p99", this.p99).add("min", this.min).add("max", this.max).add("avg", this.avg).toString();
        }
    }
}

