/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.example;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import org.apache.inlong.tubemq.client.common.PeerInfo;
import org.apache.inlong.tubemq.client.config.ConsumerConfig;
import org.apache.inlong.tubemq.client.config.TubeClientConfig;
import org.apache.inlong.tubemq.client.consumer.ConsumePosition;
import org.apache.inlong.tubemq.client.consumer.MessageListener;
import org.apache.inlong.tubemq.client.consumer.PushMessageConsumer;
import org.apache.inlong.tubemq.client.factory.MessageSessionFactory;
import org.apache.inlong.tubemq.client.factory.TubeSingleSessionFactory;
import org.apache.inlong.tubemq.corebase.Message;
import org.apache.inlong.tubemq.corebase.utils.MixedUtils;
import org.apache.inlong.tubemq.example.MsgSendReceiveStats;

public final class MessagePushConsumerExample {
    private static final MsgSendReceiveStats msgRcvStats = new MsgSendReceiveStats(false);
    private static MessageSessionFactory sessionFactory;
    private static final Map<String, PushMessageConsumer> consumerMap;

    public static void main(String[] args) throws Throwable {
        String masterServers = args[0];
        String subTopicAndFiterItems = args[1];
        String groupName = args[2];
        int clientCount = Integer.parseInt(args[3]);
        if (clientCount <= 0) {
            clientCount = 1;
        }
        int paraFetchThreadCnt = -1;
        if (args.length > 5) {
            paraFetchThreadCnt = Integer.parseInt(args[4]);
        }
        int fetchThreadCnt = paraFetchThreadCnt;
        Map topicAndFiltersMap = MixedUtils.parseTopicParam((String)subTopicAndFiterItems);
        ConsumerConfig consumerConfig = new ConsumerConfig(masterServers, groupName);
        consumerConfig.setConsumePosition(ConsumePosition.CONSUMER_FROM_LATEST_OFFSET);
        if (fetchThreadCnt > 0) {
            consumerConfig.setPushFetchThreadCnt(fetchThreadCnt);
        }
        sessionFactory = new TubeSingleSessionFactory((TubeClientConfig)consumerConfig);
        for (int i = 0; i < clientCount; ++i) {
            PushMessageConsumer consumer = sessionFactory.createPushConsumer(consumerConfig);
            for (Map.Entry entry : topicAndFiltersMap.entrySet()) {
                DefaultMessageListener messageListener = new DefaultMessageListener((String)entry.getKey());
                consumer.subscribe((String)entry.getKey(), (TreeSet)entry.getValue(), (MessageListener)messageListener);
            }
            consumer.completeSubscribe();
            consumerMap.put(consumer.getConsumerId(), consumer);
        }
        Thread statisticThread = new Thread((Runnable)msgRcvStats, "Receive Statistic Thread");
        statisticThread.start();
    }

    static {
        consumerMap = new HashMap<String, PushMessageConsumer>();
    }

    public static class DefaultMessageListener
    implements MessageListener {
        private final String topic;

        public DefaultMessageListener(String topic) {
            this.topic = topic;
        }

        public void receiveMessages(PeerInfo peerInfo, List<Message> messages) {
            if (messages != null && !messages.isEmpty()) {
                msgRcvStats.addMsgCount(this.topic, messages.size());
            }
        }

        public Executor getExecutor() {
            return null;
        }

        public void stop() {
        }
    }
}

