/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.metamanage.metastore.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.ConcurrentHashSet;
import org.apache.inlong.tubemq.corebase.utils.KeyBuilderUtils;
import org.apache.inlong.tubemq.server.master.metamanage.DataOpErrCode;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.GroupConsumeCtrlEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.mapper.ConsumeCtrlMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbsConsumeCtrlMapperImpl
implements ConsumeCtrlMapper {
    protected static final Logger logger = LoggerFactory.getLogger(AbsConsumeCtrlMapperImpl.class);
    private final ConcurrentHashMap<String, GroupConsumeCtrlEntity> consumeCtrlCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConcurrentHashSet<String>> topic2RecordCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConcurrentHashSet<String>> group2RecordCache = new ConcurrentHashMap();

    @Override
    public boolean addGroupConsumeCtrlConf(GroupConsumeCtrlEntity entity, StringBuilder strBuff, ProcessResult result) {
        GroupConsumeCtrlEntity curEntity = this.consumeCtrlCache.get(entity.getRecordKey());
        if (curEntity != null) {
            result.setFailResult(DataOpErrCode.DERR_EXISTED.getCode(), strBuff.append("Existed record found for groupName-topicName(").append(entity.getRecordKey()).append(")!").toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        if (this.putConfig2Persistent(entity, strBuff, result)) {
            this.putRecord2Caches(entity);
        }
        return result.isSuccess();
    }

    @Override
    public boolean updGroupConsumeCtrlConf(GroupConsumeCtrlEntity entity, StringBuilder strBuff, ProcessResult result) {
        GroupConsumeCtrlEntity curEntity = this.consumeCtrlCache.get(entity.getRecordKey());
        if (curEntity == null) {
            result.setFailResult(DataOpErrCode.DERR_NOT_EXIST.getCode(), strBuff.append("Not found consume control for through groupName-topicName(").append(entity.getRecordKey()).append(")!").toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        GroupConsumeCtrlEntity newEntity = curEntity.clone();
        newEntity.updBaseModifyInfo(entity);
        if (!newEntity.updModifyInfo(entity.getDataVerId(), entity.getConsumeEnable(), entity.getDisableReason(), entity.getFilterEnable(), entity.getFilterCondStr())) {
            result.setFailResult(DataOpErrCode.DERR_UNCHANGED.getCode(), "Consume control configure not changed!");
            return result.isSuccess();
        }
        if (this.putConfig2Persistent(newEntity, strBuff, result)) {
            this.putRecord2Caches(newEntity);
            result.setSuccResult(null);
        }
        return result.isSuccess();
    }

    @Override
    public boolean isTopicNameInUse(String topicName) {
        ConcurrentHashSet<String> consumeCtrlSet = this.topic2RecordCache.get(topicName);
        return consumeCtrlSet != null && !consumeCtrlSet.isEmpty();
    }

    @Override
    public boolean isGroupNameInUse(String groupName) {
        ConcurrentHashSet<String> keySet = this.group2RecordCache.get(groupName);
        return keySet != null && !keySet.isEmpty();
    }

    @Override
    public boolean delGroupConsumeCtrlConf(String recordKey, StringBuilder strBuff, ProcessResult result) {
        GroupConsumeCtrlEntity curEntity = this.consumeCtrlCache.get(recordKey);
        if (curEntity == null) {
            result.setSuccResult(null);
            return true;
        }
        this.delConfigFromPersistent(recordKey, strBuff);
        this.delRecordFromCaches(recordKey);
        result.setSuccResult(null);
        return true;
    }

    @Override
    public boolean delGroupConsumeCtrlConf(String groupName, String topicName, StringBuilder strBuff, ProcessResult result) {
        ConcurrentHashSet<String> keySet = new ConcurrentHashSet<String>();
        if (groupName == null) {
            if (topicName == null) {
                result.setSuccResult(null);
                return true;
            }
            keySet = this.topic2RecordCache.get(topicName);
        } else if (topicName == null) {
            keySet = this.group2RecordCache.get(groupName);
        } else {
            keySet.add((Object)KeyBuilderUtils.buildGroupTopicRecKey((String)groupName, (String)topicName));
        }
        if (keySet == null || keySet.isEmpty()) {
            result.setSuccResult(null);
            return true;
        }
        for (String key : keySet) {
            if (!this.delGroupConsumeCtrlConf(key, strBuff, result)) {
                return result.isSuccess();
            }
            result.clear();
        }
        result.setSuccResult(null);
        return true;
    }

    @Override
    public GroupConsumeCtrlEntity getGroupConsumeCtrlConfByRecKey(String recordKey) {
        return this.consumeCtrlCache.get(recordKey);
    }

    @Override
    public List<GroupConsumeCtrlEntity> getConsumeCtrlByTopicName(String topicName) {
        ConcurrentHashSet<String> keySet = this.topic2RecordCache.get(topicName);
        if (keySet == null || keySet.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<GroupConsumeCtrlEntity> result = new ArrayList<GroupConsumeCtrlEntity>();
        for (String recordKey : keySet) {
            GroupConsumeCtrlEntity entity;
            if (recordKey == null || (entity = this.consumeCtrlCache.get(recordKey)) == null) continue;
            result.add(entity);
        }
        return result;
    }

    @Override
    public Map<String, List<GroupConsumeCtrlEntity>> getConsumeCtrlByTopicName(Set<String> topicSet) {
        if (topicSet == null || topicSet.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, List<GroupConsumeCtrlEntity>> result = new HashMap<String, List<GroupConsumeCtrlEntity>>();
        for (String topicName : topicSet) {
            ConcurrentHashSet<String> keySet = this.topic2RecordCache.get(topicName);
            if (keySet == null || keySet.isEmpty()) {
                result.put(topicName, Collections.emptyList());
                continue;
            }
            ArrayList<GroupConsumeCtrlEntity> itemRet = new ArrayList<GroupConsumeCtrlEntity>();
            for (String recordKey : keySet) {
                GroupConsumeCtrlEntity entity;
                if (recordKey == null || (entity = this.consumeCtrlCache.get(recordKey)) == null) continue;
                itemRet.add(entity);
            }
            result.put(topicName, itemRet);
        }
        return result;
    }

    @Override
    public List<GroupConsumeCtrlEntity> getConsumeCtrlByGroupName(String groupName) {
        ConcurrentHashSet<String> keySet = this.group2RecordCache.get(groupName);
        if (keySet == null || keySet.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<GroupConsumeCtrlEntity> result = new ArrayList<GroupConsumeCtrlEntity>();
        for (String recordKey : keySet) {
            GroupConsumeCtrlEntity entity = this.consumeCtrlCache.get(recordKey);
            if (entity == null) continue;
            result.add(entity);
        }
        return result;
    }

    @Override
    public Map<String, List<GroupConsumeCtrlEntity>> getConsumeCtrlByGroupName(Set<String> groupSet) {
        if (groupSet == null || groupSet.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, List<GroupConsumeCtrlEntity>> result = new HashMap<String, List<GroupConsumeCtrlEntity>>();
        for (String groupName : groupSet) {
            ConcurrentHashSet<String> keySet = this.group2RecordCache.get(groupName);
            if (keySet == null || keySet.isEmpty()) {
                result.put(groupName, Collections.emptyList());
                continue;
            }
            ArrayList<GroupConsumeCtrlEntity> itemRet = new ArrayList<GroupConsumeCtrlEntity>();
            for (String recordKey : keySet) {
                GroupConsumeCtrlEntity entity;
                if (recordKey == null || (entity = this.consumeCtrlCache.get(recordKey)) == null) continue;
                itemRet.add(entity);
            }
            result.put(groupName, itemRet);
        }
        return result;
    }

    @Override
    public GroupConsumeCtrlEntity getConsumeCtrlByGroupAndTopic(String groupName, String topicName) {
        return this.consumeCtrlCache.get(KeyBuilderUtils.buildGroupTopicRecKey((String)groupName, (String)topicName));
    }

    @Override
    public Map<String, List<GroupConsumeCtrlEntity>> getConsumeCtrlInfoMap(Set<String> groupSet, Set<String> topicSet, GroupConsumeCtrlEntity qryEntry) {
        HashMap<String, List<GroupConsumeCtrlEntity>> retEntityMap = new HashMap<String, List<GroupConsumeCtrlEntity>>();
        Set<String> totalMatchedSet = this.getMatchedRecords(groupSet, topicSet);
        if (totalMatchedSet == null) {
            for (GroupConsumeCtrlEntity entity : this.consumeCtrlCache.values()) {
                if (entity == null || qryEntry != null && !entity.isMatched(qryEntry)) continue;
                List itemLst = retEntityMap.computeIfAbsent(entity.getGroupName(), k -> new ArrayList());
                itemLst.add(entity);
            }
        } else {
            for (String recKey : totalMatchedSet) {
                GroupConsumeCtrlEntity tmpEntity = this.consumeCtrlCache.get(recKey);
                if (tmpEntity == null || qryEntry != null && !tmpEntity.isMatched(qryEntry)) continue;
                List itemLst = retEntityMap.computeIfAbsent(tmpEntity.getGroupName(), k -> new ArrayList());
                itemLst.add(tmpEntity);
            }
        }
        return retEntityMap;
    }

    @Override
    public List<GroupConsumeCtrlEntity> getGroupConsumeCtrlConf(GroupConsumeCtrlEntity qryEntity) {
        ArrayList<GroupConsumeCtrlEntity> retEntities = new ArrayList<GroupConsumeCtrlEntity>();
        if (qryEntity == null) {
            retEntities.addAll(this.consumeCtrlCache.values());
        } else {
            for (GroupConsumeCtrlEntity entity : this.consumeCtrlCache.values()) {
                if (entity == null || !entity.isMatched(qryEntity)) continue;
                retEntities.add(entity);
            }
        }
        return retEntities;
    }

    @Override
    public Set<String> getMatchedRecords(Set<String> groupSet, Set<String> topicSet) {
        ConcurrentHashSet<String> recSet;
        HashSet<String> groupKeySet = null;
        HashSet<String> topicKeySet = null;
        HashSet<String> totalMatchedSet = null;
        if (groupSet != null && !groupSet.isEmpty()) {
            groupKeySet = new HashSet<String>();
            for (String group : groupSet) {
                recSet = this.group2RecordCache.get(group);
                if (recSet == null || recSet.isEmpty()) continue;
                groupKeySet.addAll((Collection<String>)recSet);
            }
            if (groupKeySet.isEmpty()) {
                return Collections.emptySet();
            }
        }
        if (topicSet != null && !topicSet.isEmpty()) {
            topicKeySet = new HashSet<String>();
            for (String topic : topicSet) {
                recSet = this.topic2RecordCache.get(topic);
                if (recSet == null || recSet.isEmpty()) continue;
                topicKeySet.addAll((Collection<String>)recSet);
            }
            if (topicKeySet.isEmpty()) {
                return Collections.emptySet();
            }
        }
        if (groupKeySet != null || topicKeySet != null) {
            if (groupKeySet == null) {
                totalMatchedSet = new HashSet<String>(topicKeySet);
            } else if (topicKeySet == null) {
                totalMatchedSet = new HashSet(groupKeySet);
            } else {
                totalMatchedSet = new HashSet();
                for (String record : groupKeySet) {
                    if (!topicKeySet.contains(record)) continue;
                    totalMatchedSet.add(record);
                }
            }
        }
        return totalMatchedSet;
    }

    protected void clearCachedData() {
        this.topic2RecordCache.clear();
        this.group2RecordCache.clear();
        this.consumeCtrlCache.clear();
    }

    protected void putRecord2Caches(GroupConsumeCtrlEntity entity) {
        ConcurrentHashSet<String> tmpSet;
        this.consumeCtrlCache.put(entity.getRecordKey(), entity);
        ConcurrentHashSet<String> keySet = this.topic2RecordCache.get(entity.getTopicName());
        if (keySet == null) {
            tmpSet = new ConcurrentHashSet<String>();
            keySet = this.topic2RecordCache.putIfAbsent(entity.getTopicName(), tmpSet);
            if (keySet == null) {
                keySet = tmpSet;
            }
        }
        keySet.add((Object)entity.getRecordKey());
        keySet = this.group2RecordCache.get(entity.getGroupName());
        if (keySet == null) {
            tmpSet = new ConcurrentHashSet();
            keySet = this.group2RecordCache.putIfAbsent(entity.getGroupName(), tmpSet);
            if (keySet == null) {
                keySet = tmpSet;
            }
        }
        keySet.add((Object)entity.getRecordKey());
    }

    protected abstract boolean putConfig2Persistent(GroupConsumeCtrlEntity var1, StringBuilder var2, ProcessResult var3);

    protected abstract boolean delConfigFromPersistent(String var1, StringBuilder var2);

    private void delRecordFromCaches(String recordKey) {
        GroupConsumeCtrlEntity curEntity = this.consumeCtrlCache.remove(recordKey);
        if (curEntity == null) {
            return;
        }
        ConcurrentHashSet<String> keySet = this.topic2RecordCache.get(curEntity.getTopicName());
        if (keySet != null) {
            keySet.remove((Object)recordKey);
            if (keySet.isEmpty()) {
                this.topic2RecordCache.remove(curEntity.getTopicName(), new ConcurrentHashSet());
            }
        }
        if ((keySet = this.group2RecordCache.get(curEntity.getGroupName())) != null) {
            keySet.remove((Object)recordKey);
            if (keySet.isEmpty()) {
                this.group2RecordCache.remove(curEntity.getGroupName(), new ConcurrentHashSet());
            }
        }
    }
}

