/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.pattern;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.cep.nfa.aftermatch.AfterMatchSkipStrategy;
import org.apache.flink.cep.pattern.GroupPattern;
import org.apache.flink.cep.pattern.MalformedPatternException;
import org.apache.flink.cep.pattern.Quantifier;
import org.apache.flink.cep.pattern.conditions.BooleanConditions;
import org.apache.flink.cep.pattern.conditions.IterativeCondition;
import org.apache.flink.cep.pattern.conditions.RichAndCondition;
import org.apache.flink.cep.pattern.conditions.RichOrCondition;
import org.apache.flink.cep.pattern.conditions.SubtypeCondition;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.util.Preconditions;

public class Pattern<T, F extends T> {
    private final String name;
    private final Pattern<T, ? extends T> previous;
    private IterativeCondition<F> condition;
    private Time windowTime;
    private Quantifier quantifier = Quantifier.one(Quantifier.ConsumingStrategy.STRICT);
    private IterativeCondition<F> untilCondition;
    private Quantifier.Times times;
    private final AfterMatchSkipStrategy afterMatchSkipStrategy;

    protected Pattern(String name, Pattern<T, ? extends T> previous, Quantifier.ConsumingStrategy consumingStrategy, AfterMatchSkipStrategy afterMatchSkipStrategy) {
        this.name = name;
        this.previous = previous;
        this.quantifier = Quantifier.one(consumingStrategy);
        this.afterMatchSkipStrategy = afterMatchSkipStrategy;
    }

    public Pattern<T, ? extends T> getPrevious() {
        return this.previous;
    }

    public Quantifier.Times getTimes() {
        return this.times;
    }

    public String getName() {
        return this.name;
    }

    public Time getWindowTime() {
        return this.windowTime;
    }

    public Quantifier getQuantifier() {
        return this.quantifier;
    }

    public IterativeCondition<F> getCondition() {
        if (this.condition != null) {
            return this.condition;
        }
        return BooleanConditions.trueFunction();
    }

    public IterativeCondition<F> getUntilCondition() {
        return this.untilCondition;
    }

    public static <X> Pattern<X, X> begin(String name) {
        return new Pattern(name, null, Quantifier.ConsumingStrategy.STRICT, AfterMatchSkipStrategy.noSkip());
    }

    public static <X> Pattern<X, X> begin(String name, AfterMatchSkipStrategy afterMatchSkipStrategy) {
        return new Pattern(name, null, Quantifier.ConsumingStrategy.STRICT, afterMatchSkipStrategy);
    }

    public Pattern<T, F> where(IterativeCondition<F> condition) {
        Preconditions.checkNotNull(condition, (String)"The condition cannot be null.");
        ClosureCleaner.clean(condition, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        this.condition = this.condition == null ? condition : new RichAndCondition<F>(this.condition, condition);
        return this;
    }

    public Pattern<T, F> or(IterativeCondition<F> condition) {
        Preconditions.checkNotNull(condition, (String)"The condition cannot be null.");
        ClosureCleaner.clean(condition, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        this.condition = this.condition == null ? condition : new RichOrCondition<F>(this.condition, condition);
        return this;
    }

    public <S extends F> Pattern<T, S> subtype(Class<S> subtypeClass) {
        Preconditions.checkNotNull(subtypeClass, (String)"The class cannot be null.");
        this.condition = this.condition == null ? new SubtypeCondition<S>(subtypeClass) : new RichAndCondition<F>(this.condition, new SubtypeCondition<S>(subtypeClass));
        Pattern result = this;
        return result;
    }

    public Pattern<T, F> until(IterativeCondition<F> untilCondition) {
        Preconditions.checkNotNull(untilCondition, (String)"The condition cannot be null");
        if (this.untilCondition != null) {
            throw new MalformedPatternException("Only one until condition can be applied.");
        }
        if (!this.quantifier.hasProperty(Quantifier.QuantifierProperty.LOOPING)) {
            throw new MalformedPatternException("The until condition is only applicable to looping states.");
        }
        ClosureCleaner.clean(untilCondition, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        this.untilCondition = untilCondition;
        return this;
    }

    public Pattern<T, F> within(Time windowTime) {
        if (windowTime != null) {
            this.windowTime = windowTime;
        }
        return this;
    }

    public Pattern<T, T> next(String name) {
        return new Pattern<T, F>(name, this, Quantifier.ConsumingStrategy.STRICT, this.afterMatchSkipStrategy);
    }

    public Pattern<T, T> notNext(String name) {
        if (this.quantifier.hasProperty(Quantifier.QuantifierProperty.OPTIONAL)) {
            throw new UnsupportedOperationException("Specifying a pattern with an optional path to NOT condition is not supported yet. You can simulate such pattern with two independent patterns, one with and the other without the optional part.");
        }
        return new Pattern<T, F>(name, this, Quantifier.ConsumingStrategy.NOT_NEXT, this.afterMatchSkipStrategy);
    }

    public Pattern<T, T> followedBy(String name) {
        return new Pattern<T, F>(name, this, Quantifier.ConsumingStrategy.SKIP_TILL_NEXT, this.afterMatchSkipStrategy);
    }

    public Pattern<T, T> notFollowedBy(String name) {
        if (this.quantifier.hasProperty(Quantifier.QuantifierProperty.OPTIONAL)) {
            throw new UnsupportedOperationException("Specifying a pattern with an optional path to NOT condition is not supported yet. You can simulate such pattern with two independent patterns, one with and the other without the optional part.");
        }
        return new Pattern<T, F>(name, this, Quantifier.ConsumingStrategy.NOT_FOLLOW, this.afterMatchSkipStrategy);
    }

    public Pattern<T, T> followedByAny(String name) {
        return new Pattern<T, F>(name, this, Quantifier.ConsumingStrategy.SKIP_TILL_ANY, this.afterMatchSkipStrategy);
    }

    public Pattern<T, F> optional() {
        this.checkIfPreviousPatternGreedy();
        this.quantifier.optional();
        return this;
    }

    public Pattern<T, F> oneOrMore() {
        this.checkIfNoNotPattern();
        this.checkIfQuantifierApplied();
        this.quantifier = Quantifier.looping(this.quantifier.getConsumingStrategy());
        this.times = Quantifier.Times.of(1);
        return this;
    }

    public Pattern<T, F> greedy() {
        this.checkIfNoNotPattern();
        this.checkIfNoGroupPattern();
        this.quantifier.greedy();
        return this;
    }

    public Pattern<T, F> times(int times) {
        this.checkIfNoNotPattern();
        this.checkIfQuantifierApplied();
        Preconditions.checkArgument((times > 0 ? 1 : 0) != 0, (Object)"You should give a positive number greater than 0.");
        this.quantifier = Quantifier.times(this.quantifier.getConsumingStrategy());
        this.times = Quantifier.Times.of(times);
        return this;
    }

    public Pattern<T, F> times(int from, int to) {
        this.checkIfNoNotPattern();
        this.checkIfQuantifierApplied();
        this.quantifier = Quantifier.times(this.quantifier.getConsumingStrategy());
        if (from == 0) {
            this.quantifier.optional();
            from = 1;
        }
        this.times = Quantifier.Times.of(from, to);
        return this;
    }

    public Pattern<T, F> timesOrMore(int times) {
        this.checkIfNoNotPattern();
        this.checkIfQuantifierApplied();
        this.quantifier = Quantifier.looping(this.quantifier.getConsumingStrategy());
        this.times = Quantifier.Times.of(times);
        return this;
    }

    public Pattern<T, F> allowCombinations() {
        this.quantifier.combinations();
        return this;
    }

    public Pattern<T, F> consecutive() {
        this.quantifier.consecutive();
        return this;
    }

    public static <T, F extends T> GroupPattern<T, F> begin(Pattern<T, F> group, AfterMatchSkipStrategy afterMatchSkipStrategy) {
        return new GroupPattern(null, group, Quantifier.ConsumingStrategy.STRICT, afterMatchSkipStrategy);
    }

    public static <T, F extends T> GroupPattern<T, F> begin(Pattern<T, F> group) {
        return new GroupPattern(null, group, Quantifier.ConsumingStrategy.STRICT, (AfterMatchSkipStrategy)AfterMatchSkipStrategy.noSkip());
    }

    public GroupPattern<T, F> followedBy(Pattern<T, F> group) {
        return new GroupPattern(this, group, Quantifier.ConsumingStrategy.SKIP_TILL_NEXT, this.afterMatchSkipStrategy);
    }

    public GroupPattern<T, F> followedByAny(Pattern<T, F> group) {
        return new GroupPattern(this, group, Quantifier.ConsumingStrategy.SKIP_TILL_ANY, this.afterMatchSkipStrategy);
    }

    public GroupPattern<T, F> next(Pattern<T, F> group) {
        return new GroupPattern(this, group, Quantifier.ConsumingStrategy.STRICT, this.afterMatchSkipStrategy);
    }

    private void checkIfNoNotPattern() {
        if (this.quantifier.getConsumingStrategy() == Quantifier.ConsumingStrategy.NOT_FOLLOW || this.quantifier.getConsumingStrategy() == Quantifier.ConsumingStrategy.NOT_NEXT) {
            throw new MalformedPatternException("Option not applicable to NOT pattern");
        }
    }

    private void checkIfQuantifierApplied() {
        if (!this.quantifier.hasProperty(Quantifier.QuantifierProperty.SINGLE)) {
            throw new MalformedPatternException("Already applied quantifier to this Pattern. Current quantifier is: " + this.quantifier);
        }
    }

    public AfterMatchSkipStrategy getAfterMatchSkipStrategy() {
        return this.afterMatchSkipStrategy;
    }

    private void checkIfNoGroupPattern() {
        if (this instanceof GroupPattern) {
            throw new MalformedPatternException("Option not applicable to group pattern");
        }
    }

    private void checkIfPreviousPatternGreedy() {
        if (this.previous != null && this.previous.getQuantifier().hasProperty(Quantifier.QuantifierProperty.GREEDY)) {
            throw new MalformedPatternException("Optional pattern cannot be preceded by greedy pattern");
        }
    }

    public String toString() {
        return "Pattern{name='" + this.name + '\'' + ", previous=" + this.previous + ", condition=" + this.condition + ", windowTime=" + this.windowTime + ", quantifier=" + this.quantifier + ", untilCondition=" + this.untilCondition + ", times=" + this.times + ", afterMatchSkipStrategy=" + this.afterMatchSkipStrategy + '}';
    }
}

