/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"endswith"}, parameter="(String s1, String s2)", descriptions={"- Return \"\" if either argument is NULL;", "- Return whether 's2' ends with 's2'."}, examples={"endswith('Apache InLong', 'Long') = true"})
public class EndsWithFunction
implements ValueParser {
    private ValueParser exprParser;
    private ValueParser endExprParser;

    public EndsWithFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        if (expressions != null && expressions.size() == 2) {
            this.exprParser = OperatorTools.buildParser((Expression)expressions.get(0));
            this.endExprParser = OperatorTools.buildParser((Expression)expressions.get(1));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object exprObj = this.exprParser.parse(sourceData, rowIndex, context);
        Object endExprObj = this.endExprParser.parse(sourceData, rowIndex, context);
        if (exprObj == null || endExprObj == null) {
            return null;
        }
        if (!this.isSameType(exprObj, endExprObj)) {
            throw new IllegalArgumentException("Both arguments must be of the same type.");
        }
        if (exprObj instanceof byte[] && endExprObj instanceof byte[]) {
            String exprString = new String((byte[])exprObj);
            String endExprString = new String((byte[])endExprObj);
            if (endExprString.isEmpty()) {
                return true;
            }
            return exprString.endsWith(endExprString);
        }
        String exprString = OperatorTools.parseString(exprObj);
        String endExprString = OperatorTools.parseString(endExprObj);
        if (endExprString.isEmpty()) {
            return true;
        }
        return exprString.endsWith(endExprString);
    }

    private boolean isSameType(Object a, Object b) {
        return a instanceof String && b instanceof String || a instanceof byte[] && b instanceof byte[];
    }
}

