/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONPath;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="json", names={"json_remove"}, parameter="(String json_doc, String path1[, String path2, ...])", descriptions={"- Return \"\" if any argument is NULL or the 'json_doc' argument is not a valid JSON document or any path argument is not a valid path expression or is $ or contains a * or ** wildcard;", "- Return the result of removing data from 'json_doc'."}, examples={"json_remove(\"{\\\"name\\\":\\\"Charlie\\\",\\\"hobbies\\\":[[\\\"swimming1\\\",\\\"swimming2\\\"], \\\"reading\\\",\\\"coding\\\"]}\",\"$.age\") = {\"hobbies\":[[\"swimming2\"],\"coding\"],\"name\":\"Charlie\"}"})
public class JsonRemoveFunction
implements ValueParser {
    private ValueParser jsonDocParser;
    private List<ValueParser> pathsParser;

    public JsonRemoveFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.jsonDocParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.pathsParser = new ArrayList<ValueParser>();
        for (int i = 1; i < expressions.size(); ++i) {
            this.pathsParser.add(OperatorTools.buildParser((Expression)expressions.get(i)));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object jsonDocObj = this.jsonDocParser.parse(sourceData, rowIndex, context);
        if (jsonDocObj == null) {
            return null;
        }
        ArrayList<String> pathValuePairs = new ArrayList<String>();
        for (ValueParser valueParser : this.pathsParser) {
            pathValuePairs.add(valueParser.parse(sourceData, rowIndex, context).toString());
        }
        return this.jsonRemove(jsonDocObj.toString(), pathValuePairs);
    }

    private String jsonRemove(String jsonDoc, ArrayList<String> paths) {
        if (jsonDoc == null || paths == null) {
            return null;
        }
        Object json = JSON.parse((String)jsonDoc);
        for (String path : paths) {
            if (path.equals("$") || path.contains("*") || path.contains("**")) {
                throw new IllegalArgumentException("Invalid path expression: " + path);
            }
            JSONPath.remove((Object)json, (String)path);
        }
        return json.toString();
    }
}

