/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.json;

import com.alibaba.fastjson.JSON;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="json", names={"json_quote", "json_string"}, parameter="(String data)", descriptions={"- Return \"\" if data is NULL;", "- Return a valid JSON string converted from a string (JSON_QUOTE) or any type of data (JSON_STRING).", "Note: JSON_QUOTE will escape interior quote and special characters (\u2019\"\u2019, \u2018', \u2018/\u2019, \u2018b\u2019, \u2018f\u2019, \u2019n\u2019, \u2018r\u2019, \u2019t\u2019)"}, examples={"json_quote('Column1\\tColumn2) = \\\"Column1\\\\tColumn2\\\"", "json_string(true) = \"true\""})
public class JsonQuoteFunction
implements ValueParser {
    private ValueParser jsonParser;

    public JsonQuoteFunction(Function expr) {
        this.jsonParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        if (this.jsonParser == null) {
            return null;
        }
        Object parse = this.jsonParser.parse(sourceData, rowIndex, context);
        if (parse == null) {
            return null;
        }
        return JSON.toJSONString((Object)parse);
    }
}

