/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.arithmetic;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="arithmetic", names={"round"}, parameter="(String str)", descriptions={"- Return \"\" if 'x' is NULL;", "- Return the nearest integer to 'x', with optional parameter 'y' indicating the number of decimal places to be rounded."}, examples={"round(3.5) = 4", "round(3.14159265358979323846,10) = 3.1415926536"})
public class RoundFunction
implements ValueParser {
    private ValueParser numberParser;
    private ValueParser reservedDigitsParser;

    public RoundFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.numberParser = OperatorTools.buildParser((Expression)expressions.get(0));
        if (expressions.size() == 2) {
            this.reservedDigitsParser = OperatorTools.buildParser((Expression)expressions.get(1));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object numberObj = this.numberParser.parse(sourceData, rowIndex, context);
        if (numberObj == null) {
            return null;
        }
        BigDecimal number = OperatorTools.parseBigDecimal(numberObj);
        if (this.reservedDigitsParser != null) {
            Object reservedDigitsObj = this.reservedDigitsParser.parse(sourceData, rowIndex, context);
            int reservedDigits = OperatorTools.parseBigDecimal(reservedDigitsObj).intValue();
            return number.setScale(reservedDigits, RoundingMode.HALF_UP).doubleValue();
        }
        return Math.round(number.doubleValue());
    }
}

