/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.cmd.parser;

import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.CommandParsers;
import com.moilioncircle.redis.replicator.cmd.impl.Limit;
import com.moilioncircle.redis.replicator.cmd.impl.MaxLen;
import com.moilioncircle.redis.replicator.cmd.impl.MinId;
import com.moilioncircle.redis.replicator.cmd.impl.XAddCommand;
import com.moilioncircle.redis.replicator.util.ByteArrayMap;
import com.moilioncircle.redis.replicator.util.Strings;
import java.util.Objects;

public class XAddParser
implements CommandParser<XAddCommand> {
    @Override
    public XAddCommand parse(Object[] command) {
        int idx = 1;
        byte[] key = CommandParsers.toBytes(command[idx]);
        ++idx;
        MaxLen maxLen = null;
        MinId minId = null;
        Limit limit = null;
        boolean nomkstream = false;
        byte[] id = null;
        ByteArrayMap fields = new ByteArrayMap();
        while (idx < command.length) {
            String token = CommandParsers.toRune(command[idx]);
            if (Strings.isEquals(token, "MAXLEN")) {
                boolean approximation = false;
                if (Objects.equals(CommandParsers.toRune(command[++idx]), "~")) {
                    approximation = true;
                    ++idx;
                } else if (Objects.equals(CommandParsers.toRune(command[idx]), "=")) {
                    ++idx;
                }
                long count = CommandParsers.toLong(command[idx]);
                maxLen = new MaxLen(approximation, count);
            } else if (Strings.isEquals(token, "MINID")) {
                boolean approximation = false;
                if (Objects.equals(CommandParsers.toRune(command[++idx]), "~")) {
                    approximation = true;
                    ++idx;
                } else if (Objects.equals(CommandParsers.toRune(command[idx]), "=")) {
                    ++idx;
                }
                byte[] mid = CommandParsers.toBytes(command[idx]);
                minId = new MinId(approximation, mid);
            } else if (Strings.isEquals(token, "LIMIT")) {
                long count = CommandParsers.toLong(command[++idx]);
                limit = new Limit(0L, count);
            } else if (Strings.isEquals(token, "NOMKSTREAM")) {
                nomkstream = true;
            } else {
                id = CommandParsers.toBytes(command[idx]);
                ++idx;
                while (idx < command.length) {
                    byte[] field = CommandParsers.toBytes(command[idx]);
                    byte[] value = ++idx == command.length ? null : CommandParsers.toBytes(command[idx]);
                    ++idx;
                    fields.put(field, value);
                }
            }
            ++idx;
        }
        return new XAddCommand(key, maxLen, minId, limit, nomkstream, id, fields);
    }
}

