/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;
import org.apache.flink.runtime.operators.coordination.OperatorEventGateway;
import org.apache.flink.runtime.source.coordinator.SourceCoordinatorProvider;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.CoordinatedOperatorFactory;
import org.apache.flink.streaming.api.operators.SourceOperator;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeServiceAware;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.FunctionWithException;

public class SourceOperatorFactory<OUT>
extends AbstractStreamOperatorFactory<OUT>
implements CoordinatedOperatorFactory<OUT>,
ProcessingTimeServiceAware {
    private static final long serialVersionUID = 1L;
    private final Source<OUT, ?, ?> source;
    private final WatermarkStrategy<OUT> watermarkStrategy;
    private final boolean emitProgressiveWatermarks;
    private final int numCoordinatorWorkerThread;

    public SourceOperatorFactory(Source<OUT, ?, ?> source, WatermarkStrategy<OUT> watermarkStrategy) {
        this(source, watermarkStrategy, true, 1);
    }

    public SourceOperatorFactory(Source<OUT, ?, ?> source, WatermarkStrategy<OUT> watermarkStrategy, boolean emitProgressiveWatermarks) {
        this(source, watermarkStrategy, emitProgressiveWatermarks, 1);
    }

    public SourceOperatorFactory(Source<OUT, ?, ?> source, WatermarkStrategy<OUT> watermarkStrategy, boolean emitProgressiveWatermarks, int numCoordinatorWorkerThread) {
        this.source = (Source)Preconditions.checkNotNull(source);
        this.watermarkStrategy = (WatermarkStrategy)Preconditions.checkNotNull(watermarkStrategy);
        this.emitProgressiveWatermarks = emitProgressiveWatermarks;
        this.numCoordinatorWorkerThread = numCoordinatorWorkerThread;
    }

    public Boundedness getBoundedness() {
        return this.source.getBoundedness();
    }

    @Override
    public <T extends StreamOperator<OUT>> T createStreamOperator(StreamOperatorParameters<OUT> parameters) {
        OperatorID operatorId = parameters.getStreamConfig().getOperatorID();
        OperatorEventGateway gateway = parameters.getOperatorEventDispatcher().getOperatorEventGateway(operatorId);
        SourceOperator sourceOperator = SourceOperatorFactory.instantiateSourceOperator(arg_0 -> this.source.createReader(arg_0), gateway, this.source.getSplitSerializer(), this.watermarkStrategy, parameters.getProcessingTimeService(), parameters.getContainingTask().getEnvironment().getTaskManagerInfo().getConfiguration(), parameters.getContainingTask().getEnvironment().getTaskManagerInfo().getTaskManagerExternalAddress(), this.emitProgressiveWatermarks);
        sourceOperator.setup(parameters.getContainingTask(), parameters.getStreamConfig(), parameters.getOutput());
        parameters.getOperatorEventDispatcher().registerEventHandler(operatorId, sourceOperator);
        SourceOperator castedOperator = sourceOperator;
        return (T)castedOperator;
    }

    @Override
    public OperatorCoordinator.Provider getCoordinatorProvider(String operatorName, OperatorID operatorID) {
        return new SourceCoordinatorProvider(operatorName, operatorID, this.source, this.numCoordinatorWorkerThread, this.watermarkStrategy.getAlignmentParameters());
    }

    @Override
    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        return SourceOperator.class;
    }

    @Override
    public boolean isStreamSource() {
        return true;
    }

    private static <T, SplitT extends SourceSplit> SourceOperator<T, SplitT> instantiateSourceOperator(FunctionWithException<SourceReaderContext, SourceReader<T, ?>, Exception> readerFactory, OperatorEventGateway eventGateway, SimpleVersionedSerializer<?> splitSerializer, WatermarkStrategy<T> watermarkStrategy, ProcessingTimeService timeService, Configuration config, String localHostName, boolean emitProgressiveWatermarks) {
        FunctionWithException<SourceReaderContext, SourceReader<T, ?>, Exception> typedReaderFactory = readerFactory;
        SimpleVersionedSerializer<?> typedSplitSerializer = splitSerializer;
        return new SourceOperator(typedReaderFactory, eventGateway, typedSplitSerializer, watermarkStrategy, timeService, config, localHostName, emitProgressiveWatermarks);
    }
}

