/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientWrapper;

public class SynchronizedMetaStoreClient
extends MetaStoreClientWrapper
implements IMetaStoreClient {
    public static SynchronizedMetaStoreClient newClient(Configuration conf, IMetaStoreClient delegate) {
        return new SynchronizedMetaStoreClient(conf, delegate);
    }

    public SynchronizedMetaStoreClient(Configuration conf, IMetaStoreClient delegate) {
        super(SynchronizedMetaStoreClient.newSynchronizedClient(delegate), conf);
    }

    public static IMetaStoreClient newSynchronizedClient(IMetaStoreClient client) {
        return (IMetaStoreClient)Proxy.newProxyInstance(SynchronizedMetaStoreClient.class.getClassLoader(), new Class[]{IMetaStoreClient.class}, (InvocationHandler)new SynchronizedHandler(client));
    }

    private static class SynchronizedHandler
    implements InvocationHandler {
        private final IMetaStoreClient client;

        SynchronizedHandler(IMetaStoreClient client) {
            this.client = client;
        }

        @Override
        public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke((Object)this.client, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }
}

