/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.rewrite;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.rewrite.MergeRewriter;
import org.apache.hadoop.hive.ql.parse.rewrite.MergeStatement;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.COWWithClauseBuilder;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.MultiInsertSqlGenerator;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.SqlGeneratorFactory;

public class CopyOnWriteMergeRewriter
extends MergeRewriter {
    public CopyOnWriteMergeRewriter(Hive db, HiveConf conf, SqlGeneratorFactory sqlGeneratorFactory) {
        super(db, conf, sqlGeneratorFactory);
    }

    @Override
    public ParseUtils.ReparseResult rewrite(Context ctx, MergeStatement mergeStatement) throws SemanticException {
        this.setOperation(ctx);
        MultiInsertSqlGenerator sqlGenerator = this.sqlGeneratorFactory.createSqlGenerator();
        this.handleSource(mergeStatement, sqlGenerator);
        sqlGenerator.append('\n');
        sqlGenerator.append("INSERT INTO ").appendTargetTableName();
        sqlGenerator.append('\n');
        ArrayList whenClauses = Lists.newArrayList(mergeStatement.getWhenClauses());
        Optional<String> extraPredicate = whenClauses.stream().filter(whenClause -> !(whenClause instanceof MergeStatement.InsertClause)).map(MergeStatement.WhenClause::getExtraPredicate).map(Strings::nullToEmpty).reduce((p1, p2) -> StringUtils.isNotBlank((CharSequence)p2) ? p1 + " OR " + p2 : p2);
        whenClauses.removeIf(whenClause -> whenClause instanceof MergeStatement.DeleteClause);
        extraPredicate.ifPresent(p -> whenClauses.add(new MergeStatement.DeleteClause((String)p, null)));
        CopyOnWriteMergeWhenClauseSqlGenerator mergeSqlGenerator = this.createMergeSqlGenerator(mergeStatement, sqlGenerator);
        for (MergeStatement.WhenClause whenClause2 : whenClauses) {
            whenClause2.toSql(mergeSqlGenerator);
        }
        ParseUtils.ReparseResult rr = ParseUtils.parseRewrittenQuery(ctx, sqlGenerator.toString());
        Context rewrittenCtx = rr.rewrittenCtx;
        this.setOperation(rewrittenCtx);
        rewrittenCtx.addDestNamePrefix(1, Context.DestClausePrefix.MERGE);
        return rr;
    }

    @Override
    protected CopyOnWriteMergeWhenClauseSqlGenerator createMergeSqlGenerator(MergeStatement mergeStatement, MultiInsertSqlGenerator sqlGenerator) {
        return new CopyOnWriteMergeWhenClauseSqlGenerator(this.conf, sqlGenerator, mergeStatement);
    }

    private void handleSource(MergeStatement mergeStatement, MultiInsertSqlGenerator sqlGenerator) {
        boolean hasWhenNotMatchedInsertClause = mergeStatement.hasWhenNotMatchedInsertClause();
        String sourceName = mergeStatement.getSourceName();
        String sourceAlias = mergeStatement.getSourceAlias();
        String targetAlias = mergeStatement.getTargetAlias();
        String onClauseAsString = CopyOnWriteMergeRewriter.replaceColumnRefsWithTargetPrefix(targetAlias, mergeStatement.getOnClauseAsText());
        sqlGenerator.newCteExpr();
        sqlGenerator.append(sourceName + " AS ( SELECT * FROM\n");
        sqlGenerator.append("(SELECT ");
        sqlGenerator.appendAcidSelectColumns(Context.Operation.MERGE);
        sqlGenerator.appendAllColsOfTargetTable("t__");
        sqlGenerator.append(" FROM ").appendTargetTableName().append(") ");
        sqlGenerator.append(targetAlias);
        sqlGenerator.append('\n');
        sqlGenerator.indent().append(hasWhenNotMatchedInsertClause ? "FULL OUTER JOIN" : "LEFT OUTER JOIN").append("\n");
        sqlGenerator.indent().append(sourceAlias);
        sqlGenerator.append('\n');
        sqlGenerator.indent().append("ON ").append(onClauseAsString);
        sqlGenerator.append('\n');
        sqlGenerator.append(")");
        sqlGenerator.addCteExpr();
    }

    private static String replaceColumnRefsWithTargetPrefix(String columnRef, String strValue) {
        return strValue.replaceAll(columnRef + "\\.(`?)", "$1t__");
    }

    static class CopyOnWriteMergeWhenClauseSqlGenerator
    extends MergeRewriter.MergeWhenClauseSqlGenerator {
        private final COWWithClauseBuilder cowWithClauseBuilder = new COWWithClauseBuilder();
        private int subQueryCount = 0;

        CopyOnWriteMergeWhenClauseSqlGenerator(HiveConf conf, MultiInsertSqlGenerator sqlGenerator, MergeStatement mergeStatement) {
            super(conf, sqlGenerator, mergeStatement);
        }

        @Override
        public void appendWhenNotMatchedInsertClause(MergeStatement.InsertClause insertClause) {
            String targetAlias = this.mergeStatement.getTargetAlias();
            if (++this.subQueryCount > 1) {
                this.sqlGenerator.append("union all\n");
            }
            this.sqlGenerator.append("    -- insert clause\n").append("SELECT ");
            if (StringUtils.isNotBlank((CharSequence)this.hintStr)) {
                this.sqlGenerator.append(this.hintStr);
                this.hintStr = null;
            }
            List<String> values = this.sqlGenerator.getDeleteValues(Context.Operation.MERGE);
            if (insertClause.getColumnList() != null) {
                List<String> columnNames = insertClause.getColumnList();
                List<String> columnValues = insertClause.getValuesClause();
                Map<String, String> columnMap = IntStream.range(0, columnNames.size()).boxed().collect(Collectors.toMap(columnNames::get, columnValues::get));
                for (FieldSchema col : this.mergeStatement.getTargetTable().getAllCols()) {
                    values.add(columnMap.getOrDefault(col.getName(), "null"));
                }
            } else {
                values.addAll(insertClause.getValuesClause());
            }
            this.sqlGenerator.append(StringUtils.join(values, (String)","));
            this.sqlGenerator.append("\nFROM " + this.mergeStatement.getSourceName());
            this.sqlGenerator.append("\n   WHERE ");
            StringBuilder whereClause = new StringBuilder(insertClause.getPredicate());
            if (insertClause.getExtraPredicate() != null) {
                whereClause.append(" AND ").append(insertClause.getExtraPredicate());
            }
            this.sqlGenerator.append(CopyOnWriteMergeRewriter.replaceColumnRefsWithTargetPrefix(targetAlias, whereClause.toString()));
            this.sqlGenerator.append('\n');
        }

        @Override
        public void appendWhenMatchedUpdateClause(MergeStatement.UpdateClause updateClause) {
            Table targetTable = this.mergeStatement.getTargetTable();
            String targetAlias = this.mergeStatement.getTargetAlias();
            String onClauseAsString = this.mergeStatement.getOnClauseAsText();
            UnaryOperator columnRefsFunc = value -> CopyOnWriteMergeRewriter.replaceColumnRefsWithTargetPrefix(targetAlias, value);
            this.sqlGenerator.append("    -- update clause (insert part)\n").append("SELECT ");
            ++this.subQueryCount;
            if (StringUtils.isNotBlank((CharSequence)this.hintStr)) {
                this.sqlGenerator.append(this.hintStr);
                this.hintStr = null;
            }
            ArrayList<String> values = new ArrayList<String>(targetTable.getCols().size() + targetTable.getPartCols().size());
            values.addAll(this.sqlGenerator.getDeleteValues(Context.Operation.MERGE));
            this.addValues(targetTable, targetAlias, updateClause.getNewValuesMap(), values);
            this.sqlGenerator.append((String)columnRefsFunc.apply(StringUtils.join(values, (String)",")));
            this.sqlGenerator.append("\nFROM " + this.mergeStatement.getSourceName());
            this.addWhereClauseOfUpdate(onClauseAsString, updateClause.getExtraPredicate(), updateClause.getDeleteExtraPredicate(), this.sqlGenerator, columnRefsFunc);
            this.sqlGenerator.append("\n");
        }

        @Override
        protected String getRhsExpValue(String newValue, String alias) {
            return String.format("%s AS %s", newValue, alias);
        }

        @Override
        protected void handleWhenMatchedDelete(String onClauseAsString, String extraPredicate, String updateExtraPredicate, String hintStr, MultiInsertSqlGenerator sqlGenerator) {
            String targetAlias = this.mergeStatement.getTargetAlias();
            String sourceName = this.mergeStatement.getSourceName();
            String onClausePredicate = this.mergeStatement.getOnClausePredicate();
            UnaryOperator columnRefsFunc = value -> CopyOnWriteMergeRewriter.replaceColumnRefsWithTargetPrefix(targetAlias, value);
            List<String> deleteValues = sqlGenerator.getDeleteValues(Context.Operation.DELETE);
            if (++this.subQueryCount > 1) {
                sqlGenerator.append("union all\n");
            }
            sqlGenerator.append("    -- delete clause\n").append("SELECT ");
            if (StringUtils.isNotBlank((CharSequence)hintStr)) {
                sqlGenerator.append(hintStr);
            }
            sqlGenerator.append(StringUtils.join(deleteValues, (String)","));
            sqlGenerator.append("\nFROM " + sourceName);
            sqlGenerator.indent().append("WHERE ");
            StringBuilder whereClause = new StringBuilder(onClauseAsString);
            if (StringUtils.isNotBlank((CharSequence)extraPredicate)) {
                whereClause.append(" AND ").append(extraPredicate);
            }
            String whereClauseStr = (String)columnRefsFunc.apply(whereClause.toString());
            String filePathCol = HiveUtils.unparseIdentifier("t__" + VirtualColumn.FILE_PATH.getName(), (Configuration)this.conf);
            if (StringUtils.isNotBlank((CharSequence)onClausePredicate)) {
                whereClause.append(" OR ").append(onClausePredicate);
            }
            sqlGenerator.append("\n").indent();
            sqlGenerator.append("( NOT(%s) OR (%s) IS NULL )".replace("%s", (CharSequence)columnRefsFunc.apply(whereClause.toString())));
            sqlGenerator.append("\n").indent();
            sqlGenerator.append("AND ").append(filePathCol);
            sqlGenerator.append(" IN ( select ").append(filePathCol).append(" from t )");
            sqlGenerator.append("\nunion all");
            sqlGenerator.append("\nselect * from t");
            this.cowWithClauseBuilder.appendWith(sqlGenerator, sourceName, filePathCol, whereClauseStr, false);
        }
    }
}

