/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClearUserNamespacesAndTablesRule
extends ExternalResource {
    private static final Logger logger = LoggerFactory.getLogger(ClearUserNamespacesAndTablesRule.class);
    private final Supplier<AsyncConnection> connectionSupplier;
    private AsyncAdmin admin;

    public ClearUserNamespacesAndTablesRule(Supplier<AsyncConnection> connectionSupplier) {
        this.connectionSupplier = connectionSupplier;
    }

    protected void before() throws Throwable {
        AsyncConnection connection = Objects.requireNonNull(this.connectionSupplier.get());
        this.admin = connection.getAdmin();
        this.clearTablesAndNamespaces().join();
    }

    private CompletableFuture<Void> clearTablesAndNamespaces() {
        return this.deleteUserTables().thenCompose(_void -> this.deleteUserNamespaces());
    }

    private CompletableFuture<Void> deleteUserTables() {
        return ((CompletableFuture)this.listTableNames().thenApply(tableNames -> (CompletableFuture[])tableNames.stream().map(tableName -> this.disableIfEnabled((TableName)tableName).thenCompose(_void -> this.deleteTable((TableName)tableName))).toArray(CompletableFuture[]::new))).thenCompose(CompletableFuture::allOf);
    }

    private CompletableFuture<List<TableName>> listTableNames() {
        return ((CompletableFuture)CompletableFuture.runAsync(() -> logger.trace("listing tables")).thenCompose(_void -> this.admin.listTableNames(false))).thenApply(tableNames -> {
            if (logger.isTraceEnabled()) {
                StringJoiner joiner = new StringJoiner(", ", "[", "]");
                tableNames.stream().map(TableName::getNameAsString).forEach(joiner::add);
                logger.trace("found existing tables {}", (Object)joiner.toString());
            }
            return tableNames;
        });
    }

    private CompletableFuture<Boolean> isTableEnabled(TableName tableName) {
        return this.admin.isTableEnabled(tableName).thenApply(isEnabled -> {
            logger.trace("table {} is enabled.", (Object)tableName);
            return isEnabled;
        });
    }

    private CompletableFuture<Void> disableIfEnabled(TableName tableName) {
        return this.isTableEnabled(tableName).thenCompose(isEnabled -> isEnabled != false ? this.disableTable(tableName) : CompletableFuture.completedFuture(null));
    }

    private CompletableFuture<Void> disableTable(TableName tableName) {
        return CompletableFuture.runAsync(() -> logger.trace("disabling enabled table {}", (Object)tableName)).thenCompose(_void -> this.admin.disableTable(tableName));
    }

    private CompletableFuture<Void> deleteTable(TableName tableName) {
        return CompletableFuture.runAsync(() -> logger.trace("deleting disabled table {}", (Object)tableName)).thenCompose(_void -> this.admin.deleteTable(tableName));
    }

    private CompletableFuture<List<String>> listUserNamespaces() {
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.runAsync(() -> logger.trace("listing namespaces")).thenCompose(_void -> this.admin.listNamespaceDescriptors())).thenApply(namespaceDescriptors -> {
            StringJoiner joiner = new StringJoiner(", ", "[", "]");
            List names = namespaceDescriptors.stream().map(NamespaceDescriptor::getName).peek(joiner::add).collect(Collectors.toList());
            logger.trace("found existing namespaces {}", (Object)joiner);
            return names;
        })).thenApply(namespaces -> namespaces.stream().filter(namespace -> !Objects.equals(namespace, NamespaceDescriptor.SYSTEM_NAMESPACE.getName())).filter(namespace -> !Objects.equals(namespace, NamespaceDescriptor.DEFAULT_NAMESPACE.getName())).collect(Collectors.toList()));
    }

    private CompletableFuture<Void> deleteNamespace(String namespace) {
        return CompletableFuture.runAsync(() -> logger.trace("deleting namespace {}", (Object)namespace)).thenCompose(_void -> this.admin.deleteNamespace(namespace));
    }

    private CompletableFuture<Void> deleteUserNamespaces() {
        return this.listUserNamespaces().thenCompose(namespaces -> CompletableFuture.allOf((CompletableFuture[])namespaces.stream().map(this::deleteNamespace).toArray(CompletableFuture[]::new)));
    }
}

