/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpSpanNameExtractorBuilder;
import java.util.Set;
import java.util.function.Function;

public final class HttpSpanNameExtractor {
    public static <REQUEST> SpanNameExtractor<REQUEST> create(HttpClientAttributesGetter<REQUEST, ?> getter) {
        return HttpSpanNameExtractor.builder(getter).build();
    }

    public static <REQUEST> SpanNameExtractor<REQUEST> create(HttpServerAttributesGetter<REQUEST, ?> getter) {
        return HttpSpanNameExtractor.builder(getter).build();
    }

    public static <REQUEST> HttpSpanNameExtractorBuilder<REQUEST> builder(HttpClientAttributesGetter<REQUEST, ?> getter) {
        return new HttpSpanNameExtractorBuilder<REQUEST>(getter, null);
    }

    public static <REQUEST> HttpSpanNameExtractorBuilder<REQUEST> builder(HttpServerAttributesGetter<REQUEST, ?> getter) {
        return new HttpSpanNameExtractorBuilder<REQUEST>(null, getter);
    }

    private HttpSpanNameExtractor() {
    }

    static final class Server<REQUEST>
    implements SpanNameExtractor<REQUEST> {
        private final HttpServerAttributesGetter<REQUEST, ?> getter;
        private final Set<String> knownMethods;

        Server(HttpServerAttributesGetter<REQUEST, ?> getter, Set<String> knownMethods) {
            this.getter = getter;
            this.knownMethods = knownMethods;
        }

        @Override
        public String extract(REQUEST request) {
            String route;
            String method = this.getter.getHttpRequestMethod(request);
            if (method == null) {
                return "HTTP";
            }
            if (!this.knownMethods.contains(method)) {
                method = "HTTP";
            }
            return (route = this.getter.getHttpRoute(request)) == null ? method : method + " " + route;
        }
    }

    static final class Client<REQUEST>
    implements SpanNameExtractor<REQUEST> {
        private final HttpClientAttributesGetter<REQUEST, ?> getter;
        private final Set<String> knownMethods;
        private final Function<REQUEST, String> urlTemplateExtractor;

        Client(HttpClientAttributesGetter<REQUEST, ?> getter, Set<String> knownMethods, Function<REQUEST, String> urlTemplateExtractor) {
            this.getter = getter;
            this.knownMethods = knownMethods;
            this.urlTemplateExtractor = urlTemplateExtractor;
        }

        @Override
        public String extract(REQUEST request) {
            String template;
            String method = this.getter.getHttpRequestMethod(request);
            if (method == null) {
                return "HTTP";
            }
            if (!this.knownMethods.contains(method)) {
                method = "HTTP";
            }
            return (template = this.urlTemplateExtractor.apply(request)) == null ? method : method + " " + template;
        }
    }
}

