/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import com.headius.backport9.buffer.Buffers;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channel;
import jnr.constants.platform.Fcntl;
import jnr.constants.platform.OpenFlags;
import jnr.constants.platform.SocketLevel;
import jnr.constants.platform.SocketOption;
import jnr.ffi.LastError;
import jnr.ffi.Runtime;
import jnr.posix.CmsgHdr;
import jnr.posix.MsgHdr;
import jnr.posix.POSIX;
import jnr.unixsocket.UnixServerSocket;
import jnr.unixsocket.UnixServerSocketChannel;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.socket.RubyBasicSocket;
import org.jruby.ext.socket.SocketUtils;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.StringSupport;
import org.jruby.util.io.FilenoUtil;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.OpenFile;

@JRubyClass(name={"UNIXSocket"}, parent="BasicSocket")
public class RubyUNIXSocket
extends RubyBasicSocket {
    protected static final int F_GETFL = Fcntl.F_GETFL.intValue();
    protected static final int F_SETFL = Fcntl.F_SETFL.intValue();
    protected static final int O_NONBLOCK = OpenFlags.O_NONBLOCK.intValue();

    static void createUNIXSocket(Ruby runtime2) {
        RubyClass rb_cUNIXSocket = runtime2.defineClass("UNIXSocket", runtime2.getClass("BasicSocket"), RubyUNIXSocket::new);
        runtime2.getObject().setConstant("UNIXsocket", rb_cUNIXSocket);
        rb_cUNIXSocket.defineAnnotatedMethods(RubyUNIXSocket.class);
    }

    public RubyUNIXSocket(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject for_fd(ThreadContext context, IRubyObject recv2, IRubyObject _fileno) {
        Ruby runtime2 = context.runtime;
        int fileno2 = (int)_fileno.convertToInteger().getLongValue();
        RubyClass klass = (RubyClass)recv2;
        RubyUNIXSocket unixSocket = (RubyUNIXSocket)Helpers.invoke(context, klass, "allocate");
        UnixSocketChannel channel = UnixSocketChannel.fromFD(fileno2);
        unixSocket.init_sock(runtime2, channel);
        return unixSocket;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject path2) {
        this.init_unixsock(context.runtime, path2, false);
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject path(ThreadContext context) {
        return RubyString.newEmptyString(context.runtime);
    }

    @JRubyMethod
    public IRubyObject addr(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        return runtime2.newArray((IRubyObject)runtime2.newString("AF_UNIX"), (IRubyObject)RubyString.newEmptyString(runtime2));
    }

    @JRubyMethod
    public IRubyObject peeraddr(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        String _path = this.getUnixRemoteSocket().path();
        RubyString path2 = _path == null ? RubyString.newEmptyString(runtime2) : runtime2.newString(_path);
        return runtime2.newArray((IRubyObject)runtime2.newString("AF_UNIX"), (IRubyObject)path2);
    }

    @JRubyMethod(name={"recvfrom"}, required=1, optional=1)
    public IRubyObject recvfrom(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.runtime;
        IRubyObject _length = args2[0];
        IRubyObject _flags = args2.length == 2 ? args2[1] : runtime2.getNil();
        _length = args2[0];
        if (_flags.isNil()) {
            boolean flags2 = false;
        } else {
            int flags3 = RubyNumeric.fix2int(_flags);
        }
        return runtime2.newArray(this.recv(context, _length), this.peeraddr(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject send_io(ThreadContext context, IRubyObject arg2) {
        int fd;
        Ruby runtime2 = context.runtime;
        POSIX posix = runtime2.getPosix();
        OpenFile fptr = this.getOpenFileChecked();
        if (arg2.callMethod(context, "kind_of?", runtime2.getIO()).isTrue()) {
            fd = ((RubyIO)arg2).getOpenFileChecked().getFileno();
        } else if (arg2.callMethod(context, "kind_of?", runtime2.getFixnum()).isTrue()) {
            fd = ((RubyFixnum)arg2).getIntValue();
        } else {
            throw runtime2.newTypeError("neither IO nor file descriptor");
        }
        if (FilenoUtil.isFake(fd)) {
            throw runtime2.newTypeError("file descriptor is not native");
        }
        byte[] dataBytes = new byte[]{0};
        MsgHdr outMessage = posix.allocateMsgHdr();
        ByteBuffer[] outIov = new ByteBuffer[]{ByteBuffer.allocateDirect(dataBytes.length)};
        outIov[0].put(dataBytes);
        Buffers.flipBuffer(outIov[0]);
        outMessage.setIov(outIov);
        CmsgHdr outControl = outMessage.allocateControl(4);
        outControl.setLevel(SocketLevel.SOL_SOCKET.intValue());
        outControl.setType(1);
        ByteBuffer fdBuf = ByteBuffer.allocateDirect(4);
        fdBuf.order(ByteOrder.nativeOrder());
        fdBuf.putInt(0, fd);
        outControl.setData(fdBuf);
        boolean locked = fptr.lock();
        try {
            while (posix.sendmsg(fptr.getFileno(), outMessage, 0) == -1) {
                if (fptr.waitWritable(context)) continue;
                throw runtime2.newErrnoFromInt(posix.errno(), "sendmsg(2)");
            }
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
        return runtime2.getNil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(optional=2)
    public IRubyObject recv_io(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.runtime;
        POSIX posix = runtime2.getPosix();
        OpenFile fptr = this.getOpenFileChecked();
        IRubyObject klass = runtime2.getIO();
        IRubyObject mode2 = runtime2.getNil();
        if (args2.length > 0) {
            klass = args2[0];
        }
        if (args2.length > 1) {
            mode2 = args2[1];
        }
        MsgHdr inMessage = posix.allocateMsgHdr();
        ByteBuffer[] inIov = new ByteBuffer[]{ByteBuffer.allocateDirect(1)};
        inMessage.setIov(inIov);
        CmsgHdr inControl = inMessage.allocateControl(4);
        inControl.setLevel(SocketLevel.SOL_SOCKET.intValue());
        inControl.setType(1);
        ByteBuffer fdBuf = ByteBuffer.allocateDirect(4);
        fdBuf.order(ByteOrder.nativeOrder());
        fdBuf.putInt(0, -1);
        inControl.setData(fdBuf);
        boolean locked = fptr.lock();
        try {
            while (posix.recvmsg(fptr.getFileno(), inMessage, 0) == -1) {
                if (fptr.waitReadable(context)) continue;
                throw runtime2.newErrnoFromInt(posix.errno(), "recvmsg(2)");
            }
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
        ByteBuffer inFdBuf = inMessage.getControls()[0].getData();
        inFdBuf.order(ByteOrder.nativeOrder());
        RubyFixnum fd = runtime2.newFixnum(inFdBuf.getInt());
        if (klass.isNil()) {
            return fd;
        }
        if (mode2.isNil()) {
            return Helpers.invoke(context, klass, "for_fd", (IRubyObject)fd);
        }
        return Helpers.invoke(context, klass, "for_fd", (IRubyObject)fd, mode2);
    }

    @JRubyMethod(name={"socketpair", "pair"}, optional=2, meta=true)
    public static IRubyObject socketpair(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.runtime;
        try {
            UnixSocketChannel[] sp = UnixSocketChannel.pair();
            RubyClass UNIXSocket = runtime2.getClass("UNIXSocket");
            RubyUNIXSocket sock = (RubyUNIXSocket)Helpers.invoke(context, UNIXSocket, "allocate");
            sock.init_sock(runtime2, sp[0], "");
            RubyUNIXSocket sock2 = (RubyUNIXSocket)Helpers.invoke(context, UNIXSocket, "allocate");
            sock2.init_sock(runtime2, sp[1], "");
            return runtime2.newArray((IRubyObject)sock, (IRubyObject)sock2);
        }
        catch (IOException ioe) {
            throw runtime2.newIOErrorFromException(ioe);
        }
    }

    @Override
    public IRubyObject setsockopt(ThreadContext context, IRubyObject _level, IRubyObject _opt, IRubyObject val) {
        SocketLevel level2 = SocketUtils.levelFromArg(_level);
        SocketOption opt = SocketUtils.optionFromArg(_opt);
        block0 : switch (level2) {
            case SOL_SOCKET: {
                switch (opt) {
                    case SO_KEEPALIVE: {
                        break block0;
                    }
                }
                throw context.runtime.newErrnoENOPROTOOPTError();
            }
            default: {
                throw context.runtime.newErrnoENOPROTOOPTError();
            }
        }
        return context.runtime.newFixnum(0);
    }

    protected static void rb_sys_fail(Ruby runtime2, String message2) {
        int n = LastError.getLastError(Runtime.getSystemRuntime());
        RubyClass instance = runtime2.getErrno(n);
        if (instance == null) {
            throw runtime2.newSystemCallError(message2);
        }
        throw runtime2.newErrnoFromInt(n, message2);
    }

    protected void init_unixsock(Ruby runtime2, IRubyObject _path, boolean server) {
        RubyString strPath = RubyUNIXSocket.unixsockPathValue(runtime2, _path);
        ByteList path2 = strPath.getByteList();
        String fpath = Helpers.decodeByteList(runtime2, path2);
        int maxSize = 103;
        if (fpath.length() > 103) {
            throw runtime2.newArgumentError("too long unix socket path (max: " + maxSize + "bytes)");
        }
        Closeable closeable = null;
        try {
            if (server) {
                UnixServerSocketChannel channel = UnixServerSocketChannel.open();
                UnixServerSocket socket2 = channel.socket();
                closeable = channel;
                socket2.bind(new UnixSocketAddress(new File(fpath)));
                this.init_sock(runtime2, channel, fpath);
            } else {
                File fpathFile = new File(fpath);
                if (!fpathFile.exists()) {
                    throw runtime2.newErrnoENOENTError("unix socket");
                }
                UnixSocketChannel channel = UnixSocketChannel.open();
                closeable = channel;
                channel.connect(new UnixSocketAddress(fpathFile));
                this.init_sock(runtime2, channel);
            }
            closeable = null;
        }
        catch (IOException ioe) {
            throw runtime2.newIOErrorFromException(ioe);
        }
        finally {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static RubyString unixsockPathValue(Ruby runtime2, IRubyObject path2) {
        return StringSupport.checkEmbeddedNulls(runtime2, path2.convertToString());
    }

    protected void init_sock(Ruby runtime2, Channel channel, String path2) {
        this.MakeOpenFile();
        ModeFlags modes = RubyUNIXSocket.newModeFlags(runtime2, ModeFlags.RDWR);
        this.openFile.setFD(RubyUNIXSocket.newChannelFD(runtime2, channel));
        this.openFile.setMode(modes.getOpenFileFlags());
        this.openFile.setSync(true);
        this.openFile.setPath(path2);
    }

    protected void init_sock(Ruby runtime2, Channel channel) {
        this.init_sock(runtime2, channel, null);
    }
}

