/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.CatalogModel;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogModel;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.CreateOperation;

@Internal
public class CreateModelOperation
implements CreateOperation {
    private final ObjectIdentifier modelIdentifier;
    private final ResolvedCatalogModel catalogModel;
    private final boolean ignoreIfExists;
    private final boolean isTemporary;

    public CreateModelOperation(ObjectIdentifier modelIdentifier, ResolvedCatalogModel catalogModel, boolean ignoreIfExists, boolean isTemporary) {
        this.modelIdentifier = modelIdentifier;
        this.catalogModel = catalogModel;
        this.ignoreIfExists = ignoreIfExists;
        this.isTemporary = isTemporary;
    }

    public CatalogModel getCatalogModel() {
        return this.catalogModel;
    }

    public ObjectIdentifier getModelIdentifier() {
        return this.modelIdentifier;
    }

    public boolean isIgnoreIfExists() {
        return this.ignoreIfExists;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("catalogModel", this.catalogModel.toProperties());
        params.put("identifier", this.modelIdentifier);
        params.put("ignoreIfExists", this.ignoreIfExists);
        params.put("isTemporary", this.isTemporary);
        return OperationUtils.formatWithChildren("CREATE MODEL", params, Collections.emptyList(), Operation::asSummaryString);
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        if (this.isTemporary) {
            ctx.getCatalogManager().createTemporaryModel(this.catalogModel, this.modelIdentifier, this.ignoreIfExists);
        } else {
            ctx.getCatalogManager().createModel(this.catalogModel, this.modelIdentifier, this.ignoreIfExists);
        }
        return TableResultImpl.TABLE_RESULT_OK;
    }
}

