/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.pages;

import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.jsf2.pages.Page;

public class PageElement<P extends Page> {
    protected final P page;
    private final String propertyName;

    protected PageElement(P page, String name) {
        if (page == null) {
            throw new InvalidArgumentException("page", page);
        }
        if (StringUtils.isEmpty((String)name)) {
            throw new InvalidArgumentException("name", (Object)name);
        }
        this.page = page;
        this.propertyName = name;
        ((Page)page).registerPageElement(this);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public P getPage() {
        return this.page;
    }

    protected void onInitPage() {
    }

    protected void onRefreshPage() {
    }

    protected <T> T getSessionObject(Class<T> type) {
        String beanName = StringUtils.concat((String[])new String[]{((Page)this.page).getPageName(), ".", this.propertyName, ".", type.getSimpleName()});
        Map map = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        return (T)map.get(beanName);
    }

    protected <T> void setSessionObject(Class<T> type, T object) {
        String beanName = StringUtils.concat((String[])new String[]{((Page)this.page).getPageName(), ".", this.propertyName, ".", type.getSimpleName()});
        Map map = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        if (object != null) {
            map.put(beanName, object);
        } else {
            map.remove(beanName);
        }
    }

    protected final <T> void removeSessionObject(Class<T> type) {
        this.setSessionObject(type, null);
    }

    protected static String getDefaultPropertyName(DBRowSet rowset) {
        String name = rowset.getName();
        if (name == null) {
            return "unknown";
        }
        name = name.toLowerCase();
        String res = "";
        int beg = 0;
        while (beg < name.length()) {
            int end = name.indexOf(95, beg);
            if (end < 0) {
                end = name.length();
            }
            if (end > beg) {
                if (beg == 0) {
                    res = name.substring(beg, end);
                } else {
                    res = res + name.substring(beg, beg + 1).toUpperCase();
                    if (end - beg > 1) {
                        res = res + name.substring(beg + 1, end);
                    }
                }
            }
            beg = end + 1;
        }
        return res;
    }
}

