/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2;

import java.time.Duration;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PoolTest {
    private static final CharSequence COMMONS_POOL_EVICTIONS_TIMER_THREAD_NAME = "commons-pool-EvictionTimer";
    private static final long EVICTION_PERIOD_IN_MILLIS = 100L;

    PoolTest() {
    }

    @Test
    void testPool() throws Exception {
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setTestWhileIdle(true);
        PooledFooFactory pooledFooFactory = new PooledFooFactory();
        try (GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)pooledFooFactory, poolConfig);){
            pool.setTimeBetweenEvictionRunsMillis(100L);
            Assertions.assertEquals((long)100L, (long)pool.getDurationBetweenEvictionRuns().toMillis());
            Assertions.assertEquals((long)100L, (long)pool.getTimeBetweenEvictionRuns().toMillis());
            pool.setDurationBetweenEvictionRuns(Duration.ofMillis(100L));
            Assertions.assertEquals((long)100L, (long)pool.getTimeBetweenEvictionRuns().toMillis());
            pool.addObject();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
        Thread[] threads = new Thread[Thread.activeCount()];
        Thread.enumerate(threads);
        for (Thread thread : threads) {
            if (thread == null) continue;
            String name = thread.getName();
            Assertions.assertFalse((boolean)name.contains(COMMONS_POOL_EVICTIONS_TIMER_THREAD_NAME), (String)name);
        }
    }

    private static final class PooledFooFactory
    implements PooledObjectFactory<Foo> {
        private static final long VALIDATION_WAIT_IN_MILLIS = 1000L;

        private PooledFooFactory() {
        }

        public void activateObject(PooledObject<Foo> pooledObject) {
        }

        public void destroyObject(PooledObject<Foo> pooledObject) {
        }

        public PooledObject<Foo> makeObject() {
            return new DefaultPooledObject((Object)new Foo());
        }

        public void passivateObject(PooledObject<Foo> pooledObject) {
        }

        public boolean validateObject(PooledObject<Foo> pooledObject) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            return false;
        }
    }

    private static final class Foo {
        private Foo() {
        }
    }
}

