/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.pager;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hyperic.sigar.pager.PageControl;
import org.hyperic.sigar.pager.PageList;
import org.hyperic.sigar.pager.PagerEventHandler;
import org.hyperic.sigar.pager.PagerProcessor;
import org.hyperic.sigar.pager.PagerProcessorExt;

public class Pager {
    public static final String DEFAULT_PROCESSOR_CLASSNAME = "org.hyperic.sigar.pager.DefaultPagerProcessor";
    private static Map PagerProcessorMap = Collections.synchronizedMap(new HashMap());
    private PagerProcessor processor = null;
    private boolean skipNulls = false;
    private PagerEventHandler eventHandler = null;

    private Pager(PagerProcessor processor) {
        this.processor = processor;
        this.skipNulls = false;
        this.eventHandler = null;
        if (this.processor instanceof PagerProcessorExt) {
            this.skipNulls = ((PagerProcessorExt)this.processor).skipNulls();
            this.eventHandler = ((PagerProcessorExt)this.processor).getEventHandler();
        }
    }

    public static Pager getDefaultPager() {
        try {
            return Pager.getPager(DEFAULT_PROCESSOR_CLASSNAME);
        }
        catch (Exception e) {
            throw new IllegalStateException("This should never happen: " + e);
        }
    }

    public static Pager getPager(String pageProcessorClassName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Pager p = null;
        p = (Pager)PagerProcessorMap.get(pageProcessorClassName);
        if (p == null) {
            PagerProcessor processor = (PagerProcessor)Class.forName(pageProcessorClassName).newInstance();
            p = new Pager(processor);
            PagerProcessorMap.put(pageProcessorClassName, p);
        }
        return p;
    }

    public PageList seek(Collection source, int pagenum, int pagesize) {
        return this.seek(source, pagenum, pagesize, null);
    }

    public PageList seek(Collection source, PageControl pc) {
        if (pc == null) {
            pc = new PageControl();
        }
        return this.seek(source, pc.getPagenum(), pc.getPagesize(), null);
    }

    public PageList seek(Collection source, int pagenum, int pagesize, Object procData) {
        PageList dest = new PageList();
        this.seek(source, dest, pagenum, pagesize, procData);
        dest.setTotalSize(source.size());
        return dest;
    }

    public void seek(Collection source, Collection dest, int pagenum, int pagesize) {
        this.seek(source, dest, pagenum, pagesize, null);
    }

    public void seek(Collection source, Collection dest, int pagenum, int pagesize, Object procData) {
        Iterator iter2 = source.iterator();
        if (pagesize == -1 || pagenum == -1) {
            pagenum = 0;
            pagesize = Integer.MAX_VALUE;
        }
        int i = 0;
        for (int currentPage = 0; iter2.hasNext() && currentPage < pagenum; currentPage += ++i % pagesize == 0 ? 1 : 0) {
            iter2.next();
        }
        if (this.eventHandler != null) {
            this.eventHandler.init();
        }
        if (this.skipNulls) {
            while (iter2.hasNext() && dest.size() < pagesize) {
                Object elt = this.processor instanceof PagerProcessorExt ? ((PagerProcessorExt)this.processor).processElement(iter2.next(), procData) : this.processor.processElement(iter2.next());
                if (elt == null) continue;
                dest.add(elt);
            }
        } else {
            while (iter2.hasNext() && dest.size() < pagesize) {
                dest.add(this.processor.processElement(iter2.next()));
            }
        }
        if (this.eventHandler != null) {
            this.eventHandler.cleanup();
        }
    }

    public PageList seekAll(Collection source, int pagenum, int pagesize, Object procData) {
        PageList dest = new PageList();
        this.seekAll(source, dest, pagenum, pagesize, procData);
        dest.setTotalSize(source.size());
        return dest;
    }

    public void seekAll(Collection source, Collection dest, int pagenum, int pagesize, Object procData) {
        Object elt;
        Iterator iter2 = source.iterator();
        if (pagesize == -1 || pagenum == -1) {
            pagenum = 0;
            pagesize = Integer.MAX_VALUE;
        }
        int i = 0;
        for (int currentPage = 0; iter2.hasNext() && currentPage < pagenum; currentPage += i != 0 && i % pagesize == 0 ? 1 : 0) {
            if (this.processor instanceof PagerProcessorExt) {
                Object ret = ((PagerProcessorExt)this.processor).processElement(iter2.next(), procData);
                if (ret == null) continue;
                ++i;
                continue;
            }
            this.processor.processElement(iter2.next());
            ++i;
        }
        if (this.eventHandler != null) {
            this.eventHandler.init();
        }
        if (this.skipNulls) {
            while (iter2.hasNext()) {
                elt = this.processor instanceof PagerProcessorExt ? ((PagerProcessorExt)this.processor).processElement(iter2.next(), procData) : this.processor.processElement(iter2.next());
                if (elt == null || dest.size() >= pagesize) continue;
                dest.add(elt);
            }
        } else {
            while (iter2.hasNext()) {
                elt = this.processor.processElement(iter2.next());
                if (dest.size() >= pagesize) continue;
                dest.add(elt);
            }
        }
        if (this.eventHandler != null) {
            this.eventHandler.cleanup();
        }
    }

    public PageList processAll(PageList source) {
        PageList dest = new PageList();
        Iterator it = source.iterator();
        while (it.hasNext()) {
            Object elt = this.processor.processElement(it.next());
            if (elt == null) continue;
            dest.add(elt);
        }
        dest.setTotalSize(source.getTotalSize());
        return dest;
    }
}

