/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.streaming.OutgoingStream;
import org.apache.cassandra.streaming.StreamHook;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.StreamTask;
import org.apache.cassandra.streaming.messages.OutgoingStreamMessage;
import org.apache.cassandra.utils.ExecutorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamTransferTask
extends StreamTask {
    private static final Logger logger = LoggerFactory.getLogger(StreamTransferTask.class);
    private static final ScheduledThreadPoolExecutor timeoutExecutor = StreamTransferTask.createTimeoutExecutor();
    private final AtomicInteger sequenceNumber = new AtomicInteger(0);
    private boolean aborted = false;
    @VisibleForTesting
    protected final Map<Integer, OutgoingStreamMessage> streams = new HashMap<Integer, OutgoingStreamMessage>();
    private final Map<Integer, ScheduledFuture<?>> timeoutTasks = new HashMap();
    private long totalSize = 0L;
    private int totalFiles = 0;

    public StreamTransferTask(StreamSession session, TableId tableId) {
        super(session, tableId);
    }

    public synchronized void addTransferStream(OutgoingStream stream) {
        Preconditions.checkArgument(this.tableId.equals(stream.getTableId()));
        OutgoingStreamMessage message = new OutgoingStreamMessage(this.tableId, this.session, stream, this.sequenceNumber.getAndIncrement());
        message = StreamHook.instance.reportOutgoingStream(this.session, stream, message);
        this.streams.put(message.header.sequenceNumber, message);
        this.totalSize += message.stream.getEstimatedSize();
        this.totalFiles += message.stream.getNumFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(int sequenceNumber) {
        boolean signalComplete;
        StreamTransferTask streamTransferTask = this;
        synchronized (streamTransferTask) {
            OutgoingStreamMessage stream;
            ScheduledFuture<?> timeout = this.timeoutTasks.remove(sequenceNumber);
            if (timeout != null) {
                timeout.cancel(false);
            }
            if ((stream = this.streams.remove(sequenceNumber)) != null) {
                stream.complete();
            }
            logger.debug("recevied sequenceNumber {}, remaining files {}", (Object)sequenceNumber, this.streams.keySet());
            signalComplete = this.streams.isEmpty();
        }
        if (signalComplete) {
            this.session.taskCompleted(this);
        }
    }

    @Override
    public synchronized void abort() {
        if (this.aborted) {
            return;
        }
        this.aborted = true;
        for (ScheduledFuture<?> future : this.timeoutTasks.values()) {
            future.cancel(false);
        }
        this.timeoutTasks.clear();
        Throwable fail = null;
        for (OutgoingStreamMessage stream : this.streams.values()) {
            try {
                stream.complete();
            }
            catch (Throwable t) {
                if (fail == null) {
                    fail = t;
                    continue;
                }
                fail.addSuppressed(t);
            }
        }
        this.streams.clear();
        if (fail != null) {
            Throwables.propagate(fail);
        }
    }

    @Override
    public synchronized int getTotalNumberOfFiles() {
        return this.totalFiles;
    }

    @Override
    public long getTotalSize() {
        return this.totalSize;
    }

    public synchronized Collection<OutgoingStreamMessage> getFileMessages() {
        return new ArrayList<OutgoingStreamMessage>(this.streams.values());
    }

    public synchronized OutgoingStreamMessage createMessageForRetry(int sequenceNumber) {
        ScheduledFuture<?> future = this.timeoutTasks.remove(sequenceNumber);
        if (future != null) {
            future.cancel(false);
        }
        return this.streams.get(sequenceNumber);
    }

    public synchronized ScheduledFuture<?> scheduleTimeout(final int sequenceNumber, long time, TimeUnit unit) {
        if (!this.streams.containsKey(sequenceNumber)) {
            return null;
        }
        ScheduledFuture<?> future = timeoutExecutor.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                StreamTransferTask streamTransferTask = StreamTransferTask.this;
                synchronized (streamTransferTask) {
                    StreamTransferTask.this.timeoutTasks.remove(sequenceNumber);
                    StreamTransferTask.this.complete(sequenceNumber);
                }
            }
        }, time, unit);
        ScheduledFuture<?> prev = this.timeoutTasks.put(sequenceNumber, future);
        assert (prev == null);
        return future;
    }

    private static ScheduledThreadPoolExecutor createTimeoutExecutor() {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("StreamingTransferTaskTimeouts"));
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        return executor;
    }

    @VisibleForTesting
    public static void shutdownAndWait(long timeout, TimeUnit units) throws InterruptedException, TimeoutException {
        ExecutorUtils.shutdown(timeoutExecutor);
        ExecutorUtils.awaitTermination(timeout, units, timeoutExecutor);
    }
}

