/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.utils.vint.VIntCoding;

public final class ForwardingInfo
implements Serializable {
    final List<InetAddressAndPort> targets;
    final long[] messageIds;
    static final IVersionedSerializer<ForwardingInfo> serializer = new IVersionedSerializer<ForwardingInfo>(){

        @Override
        public void serialize(ForwardingInfo forwardTo, DataOutputPlus out, int version) throws IOException {
            long[] ids = forwardTo.messageIds;
            List<InetAddressAndPort> targets = forwardTo.targets;
            int count = ids.length;
            if (version >= 12) {
                out.writeUnsignedVInt(count);
            } else {
                out.writeInt(count);
            }
            for (int i = 0; i < count; ++i) {
                InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serialize(targets.get(i), out, version);
                if (version >= 12) {
                    out.writeUnsignedVInt(ids[i]);
                    continue;
                }
                out.writeInt(Ints.checkedCast(ids[i]));
            }
        }

        @Override
        public long serializedSize(ForwardingInfo forwardTo, int version) {
            long[] ids = forwardTo.messageIds;
            List<InetAddressAndPort> targets = forwardTo.targets;
            int count = ids.length;
            long size = version >= 12 ? (long)VIntCoding.computeUnsignedVIntSize(count) : (long)TypeSizes.sizeof(count);
            for (int i = 0; i < count; ++i) {
                size += InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serializedSize(targets.get(i), version);
                size += version >= 12 ? (long)VIntCoding.computeUnsignedVIntSize(ids[i]) : 4L;
            }
            return size;
        }

        @Override
        public ForwardingInfo deserialize(DataInputPlus in, int version) throws IOException {
            int count = version >= 12 ? Ints.checkedCast(in.readUnsignedVInt()) : in.readInt();
            long[] ids = new long[count];
            ArrayList<InetAddressAndPort> targets = new ArrayList<InetAddressAndPort>(count);
            for (int i = 0; i < count; ++i) {
                targets.add(InetAddressAndPort.Serializer.inetAddressAndPortSerializer.deserialize(in, version));
                ids[i] = version >= 12 ? (long)Ints.checkedCast(in.readUnsignedVInt()) : (long)in.readInt();
            }
            return new ForwardingInfo(targets, ids);
        }
    };

    public ForwardingInfo(List<InetAddressAndPort> targets, long[] messageIds) {
        Preconditions.checkArgument(targets.size() == messageIds.length);
        this.targets = targets;
        this.messageIds = messageIds;
    }

    public boolean useSameMessageID(long id) {
        for (int i = 0; i < this.messageIds.length; ++i) {
            if (id == this.messageIds[i]) continue;
            return false;
        }
        return true;
    }

    public void forEach(BiConsumer<Long, InetAddressAndPort> biConsumer) {
        for (int i = 0; i < this.messageIds.length; ++i) {
            biConsumer.accept(this.messageIds[i], this.targets.get(i));
        }
    }
}

