/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.diag;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.diag.DiagnosticEvent;
import org.apache.cassandra.diag.DiagnosticEventPersistence;
import org.apache.cassandra.diag.DiagnosticEventServiceMBean;
import org.apache.cassandra.utils.MBeanWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiagnosticEventService
implements DiagnosticEventServiceMBean {
    private static final Logger logger = LoggerFactory.getLogger(DiagnosticEventService.class);
    private ImmutableSet<Consumer<DiagnosticEvent>> subscribersAll = ImmutableSet.of();
    private ImmutableSetMultimap<Class<? extends DiagnosticEvent>, Consumer<DiagnosticEvent>> subscribersByClass = ImmutableSetMultimap.of();
    private ImmutableMap<Class, ImmutableSetMultimap<Enum<?>, Consumer<DiagnosticEvent>>> subscribersByClassAndType = ImmutableMap.of();
    private static final DiagnosticEventService instance = new DiagnosticEventService();

    private DiagnosticEventService() {
        MBeanWrapper.instance.registerMBean((Object)this, "org.apache.cassandra.diag:type=DiagnosticEventService");
        DiagnosticEventPersistence.start();
    }

    public void publish(DiagnosticEvent event) {
        ImmutableCollection consumersByEvents;
        Collection consumers;
        if (!DatabaseDescriptor.diagnosticEventsEnabled()) {
            return;
        }
        logger.trace("Publishing: {}={}", (Object)event.getClass().getName(), event.toMap());
        ImmutableMultimap consumersByType = this.subscribersByClassAndType.get(event.getClass());
        if (consumersByType != null && (consumers = consumersByType.get(event.getType())) != null) {
            for (Consumer consumer : consumers) {
                consumer.accept(event);
            }
        }
        if ((consumersByEvents = this.subscribersByClass.get(event.getClass())) != null) {
            for (Consumer consumer : consumersByEvents) {
                consumer.accept(event);
            }
        }
        for (Consumer consumer : this.subscribersAll) {
            consumer.accept(event);
        }
    }

    public synchronized <E extends DiagnosticEvent> void subscribe(Class<E> event, Consumer<E> consumer) {
        logger.debug("Adding subscriber: {}", consumer);
        this.subscribersByClass = ((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)ImmutableSetMultimap.builder().putAll(this.subscribersByClass)).put(event, new TypedConsumerWrapper(consumer))).build();
        logger.debug("Total subscribers: {}", (Object)((AbstractCollection)this.subscribersByClass.values()).size());
    }

    public synchronized <E extends DiagnosticEvent, T extends Enum<T>> void subscribe(Class<E> event, T eventType, Consumer<E> consumer) {
        ImmutableSetMultimap.Builder byTypeBuilder = ImmutableSetMultimap.builder();
        if (this.subscribersByClassAndType.containsKey(event)) {
            byTypeBuilder.putAll(this.subscribersByClassAndType.get(event));
        }
        byTypeBuilder.put(eventType, new TypedConsumerWrapper(consumer));
        ImmutableMap.Builder<Class<E>, ImmutableMultimap> byClassBuilder = ImmutableMap.builder();
        for (Class clazz : this.subscribersByClassAndType.keySet()) {
            if (clazz.equals(event)) continue;
            byClassBuilder.put(clazz, this.subscribersByClassAndType.get(clazz));
        }
        this.subscribersByClassAndType = byClassBuilder.put(event, byTypeBuilder.build()).build();
    }

    public synchronized void subscribeAll(Consumer<DiagnosticEvent> consumer) {
        this.subscribersAll = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(this.subscribersAll)).add(consumer)).build();
    }

    public synchronized <E extends DiagnosticEvent> void unsubscribe(Consumer<E> consumer) {
        this.unsubscribe(null, consumer);
    }

    public synchronized <E extends DiagnosticEvent> void unsubscribe(@Nullable Class<E> event, Consumer<E> consumer) {
        this.subscribersAll = ImmutableSet.copyOf(Iterables.filter(this.subscribersAll, c -> c != consumer));
        ImmutableMultimap.Builder byClassBuilder = ImmutableSetMultimap.builder();
        ImmutableCollection entries = this.subscribersByClass.entries();
        for (Map.Entry entry : entries) {
            Consumer subscriber = (Consumer)entry.getValue();
            if (subscriber instanceof TypedConsumerWrapper) {
                subscriber = ((TypedConsumerWrapper)subscriber).wrapped;
            }
            if (subscriber == consumer && (event == null || ((Class)entry.getKey()).equals(event))) continue;
            byClassBuilder = byClassBuilder.put(entry);
        }
        this.subscribersByClass = byClassBuilder.build();
        ImmutableMap.Builder byClassAndTypeBuilder = ImmutableMap.builder();
        for (Map.Entry byClassEntry : this.subscribersByClassAndType.entrySet()) {
            ImmutableSetMultimap.Builder byTypeBuilder = ImmutableSetMultimap.builder();
            ImmutableSetMultimap byTypeConsumers = (ImmutableSetMultimap)byClassEntry.getValue();
            Iterables.filter(byTypeConsumers.entries(), e -> {
                if (e == null || e.getValue() == null) {
                    return false;
                }
                Consumer subscriber = (Consumer)e.getValue();
                if (subscriber instanceof TypedConsumerWrapper) {
                    subscriber = ((TypedConsumerWrapper)subscriber).wrapped;
                }
                return subscriber != consumer || event != null && !((Class)byClassEntry.getKey()).equals(event);
            }).forEach(byTypeBuilder::put);
            ImmutableMultimap byType = byTypeBuilder.build();
            if (byType.isEmpty()) continue;
            byClassAndTypeBuilder.put(byClassEntry.getKey(), byType);
        }
        this.subscribersByClassAndType = byClassAndTypeBuilder.build();
    }

    public <E extends DiagnosticEvent> boolean hasSubscribers(Class<E> event) {
        return !this.subscribersAll.isEmpty() || this.subscribersByClass.containsKey(event) || this.subscribersByClassAndType.containsKey(event);
    }

    public <E extends DiagnosticEvent, T extends Enum<T>> boolean hasSubscribers(Class<E> event, T eventType) {
        if (!this.subscribersAll.isEmpty()) {
            return true;
        }
        ImmutableCollection subscribers = this.subscribersByClass.get(event);
        if (subscribers != null && !subscribers.isEmpty()) {
            return true;
        }
        ImmutableSetMultimap<Enum<?>, Consumer<DiagnosticEvent>> byType = this.subscribersByClassAndType.get(event);
        if (byType == null || byType.isEmpty()) {
            return false;
        }
        ImmutableCollection consumers = byType.get((Object)eventType);
        return consumers != null && !consumers.isEmpty();
    }

    public <E extends DiagnosticEvent> boolean isEnabled(Class<E> event) {
        return DatabaseDescriptor.diagnosticEventsEnabled() && this.hasSubscribers(event);
    }

    public <E extends DiagnosticEvent, T extends Enum<T>> boolean isEnabled(Class<E> event, T eventType) {
        return DatabaseDescriptor.diagnosticEventsEnabled() && this.hasSubscribers(event, eventType);
    }

    public static DiagnosticEventService instance() {
        return instance;
    }

    public synchronized void cleanup() {
        this.subscribersByClass = ImmutableSetMultimap.of();
        this.subscribersAll = ImmutableSet.of();
        this.subscribersByClassAndType = ImmutableMap.of();
    }

    @Override
    public boolean isDiagnosticsEnabled() {
        return DatabaseDescriptor.diagnosticEventsEnabled();
    }

    @Override
    public void disableDiagnostics() {
        DatabaseDescriptor.setDiagnosticEventsEnabled(false);
    }

    @Override
    public SortedMap<Long, Map<String, Serializable>> readEvents(String eventClazz, Long lastKey, int limit) {
        return DiagnosticEventPersistence.instance().getEvents(eventClazz, lastKey, limit, false);
    }

    @Override
    public void enableEventPersistence(String eventClazz) {
        DiagnosticEventPersistence.instance().enableEventPersistence(eventClazz);
    }

    @Override
    public void disableEventPersistence(String eventClazz) {
        DiagnosticEventPersistence.instance().disableEventPersistence(eventClazz);
    }

    private static class TypedConsumerWrapper<E>
    implements Consumer<DiagnosticEvent> {
        private final Consumer<E> wrapped;

        private TypedConsumerWrapper(Consumer<E> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public void accept(DiagnosticEvent e) {
            this.wrapped.accept(e);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypedConsumerWrapper that = (TypedConsumerWrapper)o;
            return Objects.equals(this.wrapped, that.wrapped);
        }

        public int hashCode() {
            return Objects.hash(this.wrapped);
        }
    }
}

