/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import java.util.Iterator;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.partitions.ImmutableBTreePartition;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.schema.TableMetadata;

public class FilteredPartition
extends ImmutableBTreePartition {
    public FilteredPartition(RowIterator rows) {
        super(rows.metadata(), rows.partitionKey(), FilteredPartition.build(rows, DeletionInfo.LIVE, false));
    }

    public static FilteredPartition create(RowIterator iterator) {
        return new FilteredPartition(iterator);
    }

    public RowIterator rowIterator() {
        final Iterator<Row> iter2 = this.iterator();
        return new RowIterator(){

            @Override
            public TableMetadata metadata() {
                return FilteredPartition.this.metadata();
            }

            @Override
            public boolean isReverseOrder() {
                return false;
            }

            @Override
            public RegularAndStaticColumns columns() {
                return FilteredPartition.this.columns();
            }

            @Override
            public DecoratedKey partitionKey() {
                return FilteredPartition.this.partitionKey();
            }

            @Override
            public Row staticRow() {
                return FilteredPartition.this.staticRow();
            }

            @Override
            public void close() {
            }

            @Override
            public boolean hasNext() {
                return iter2.hasNext();
            }

            @Override
            public Row next() {
                return (Row)iter2.next();
            }

            @Override
            public boolean isEmpty() {
                return this.staticRow().isEmpty() && !FilteredPartition.this.hasRows();
            }
        };
    }
}

