/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.sidecar;

import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.ThreadLocalMonotonicTimestampGenerator;
import com.esotericsoftware.kryo.Kryo;
import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.bridge.CdcBridgeFactory;
import org.apache.cassandra.bridge.TokenRange;
import org.apache.cassandra.cdc.CdcKryoRegister;
import org.apache.cassandra.cdc.api.CdcOptions;
import org.apache.cassandra.cdc.api.StatePersister;
import org.apache.cassandra.cdc.sidecar.SidecarCdcCassandraClient;
import org.apache.cassandra.cdc.sidecar.SidecarCdcOptions;
import org.apache.cassandra.cdc.sidecar.SidecarCdcStats;
import org.apache.cassandra.cdc.state.CdcState;
import org.apache.cassandra.spark.utils.AsyncExecutor;
import org.apache.cassandra.spark.utils.ThrowableUtils;
import org.apache.cassandra.util.CompressionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SidecarStatePersister
implements StatePersister {
    private static final Logger LOGGER = LoggerFactory.getLogger(SidecarStatePersister.class);
    protected final ConcurrentHashMap<PersistWrapper.Key, PersistWrapper> latestState = new ConcurrentHashMap();
    protected final ConcurrentLinkedQueue<TimedFutureWrapper> activeFlush = new ConcurrentLinkedQueue();
    private final ThreadLocalMonotonicTimestampGenerator timestampGenerator = new ThreadLocalMonotonicTimestampGenerator();
    private final SidecarCdcOptions sidecarCdcOptions;
    private final CdcOptions cdcOptions;
    private final SidecarCdcCassandraClient cassandraClient;
    private final SidecarCdcStats sidecarCdcStats;
    private final AsyncExecutor asyncExecutor;
    volatile long timerId = -1L;

    public SidecarStatePersister(SidecarCdcOptions sidecarCdcOptions, CdcOptions cdcOptions, SidecarCdcStats sidecarCdcStats, SidecarCdcCassandraClient cassandraClient, AsyncExecutor asyncExecutor) {
        this.sidecarCdcOptions = sidecarCdcOptions;
        this.cdcOptions = cdcOptions;
        this.sidecarCdcStats = sidecarCdcStats;
        this.cassandraClient = cassandraClient;
        this.asyncExecutor = asyncExecutor;
    }

    public void persist(String jobId, int partitionId, @Nullable TokenRange tokenRange, @NotNull ByteBuffer buf) {
        PersistWrapper.Key key;
        PersistWrapper latest = new PersistWrapper(jobId, partitionId, tokenRange, buf, this.timestampGenerator.next());
        if (!latest.equals(this.latestState.get(key = latest.key()))) {
            this.latestState.compute(key, (k, prev) -> !latest.equals(prev) ? latest : prev);
        }
    }

    @NotNull
    public List<CdcState> loadState(String jobId, int partitionId, @Nullable TokenRange tokenRange) {
        CompressionUtil compressionUtil = CdcBridgeFactory.get((CassandraVersion)this.cdcOptions.version()).compressionUtil();
        ArrayList sizes = new ArrayList();
        List<CdcState> result = this.loadStateForRange(jobId, tokenRange).peek(bytes -> sizes.add(((byte[])bytes).length)).map(bytes -> CdcState.deserialize((Kryo)CdcKryoRegister.kryo(), (CompressionUtil)compressionUtil, (byte[])bytes)).collect(Collectors.toList());
        int count = sizes.size();
        int len = sizes.stream().mapToInt(i -> i).sum();
        LOGGER.debug("Read CDC state from Cassandra jobId={} start={} end={} stateCount={} stateSize={}", new Object[]{jobId, tokenRange == null ? "null" : tokenRange.lowerEndpoint(), tokenRange == null ? "null" : tokenRange.upperEndpoint(), count, len});
        this.sidecarCdcStats.captureCdcConsumerReadFromState(count, len);
        return result;
    }

    @VisibleForTesting
    public Stream<byte[]> loadStateForRange(String jobId, @Nullable TokenRange tokenRange) {
        return this.cassandraClient.loadStateForRange(jobId, tokenRange);
    }

    public synchronized void start() {
        if (this.timerId >= 0L) {
            return;
        }
        this.timerId = this.asyncExecutor.periodicTimer(this::persistToCassandra, this.sidecarCdcOptions.persistDelay().toMillis());
    }

    public void stop() {
        this.stop(true);
    }

    public synchronized void stop(boolean flush) {
        if (this.timerId < 0L) {
            return;
        }
        this.asyncExecutor.cancelTimer(this.timerId);
        this.timerId = -1L;
        if (flush) {
            this.flush();
        }
    }

    protected void persistToCassandra() {
        this.persistToCassandra(false);
    }

    protected void persistToCassandra(boolean force) {
        this.activeFlush.removeIf(wrapper -> {
            if (wrapper.allDone()) {
                try {
                    wrapper.await();
                    this.sidecarCdcStats.capturePersistSucceeded(System.nanoTime() - wrapper.startTimeNanos);
                }
                catch (InterruptedException e) {
                    LOGGER.warn("Persist failed with InterruptedException", (Throwable)e);
                    Thread.currentThread().interrupt();
                    this.sidecarCdcStats.capturePersistFailed(e);
                }
                catch (Throwable throwable) {
                    LOGGER.warn("Persist failed", throwable);
                    this.sidecarCdcStats.capturePersistFailed(throwable);
                }
                return true;
            }
            return false;
        });
        if (!force && !this.activeFlush.isEmpty()) {
            LOGGER.debug("CDC persist flush backed up, can't persist until active requests complete activeRequests={}", (Object)this.activeFlush.size());
            this.sidecarCdcStats.capturePersistBackedUp(this.activeFlush.size());
            return;
        }
        List states = this.latestState.keySet().stream().map(this.latestState::remove).filter(Objects::nonNull).collect(Collectors.toList());
        if (states.isEmpty()) {
            return;
        }
        states.stream().map(this::persistToCassandra).filter(Objects::nonNull).forEach(this.activeFlush::add);
    }

    @Nullable
    protected TimedFutureWrapper persistToCassandra(@NotNull PersistWrapper state) {
        TokenRange range = state.tokenRange();
        if (range == null) {
            LOGGER.warn("Cannot persist state with null token range");
            return null;
        }
        try {
            LOGGER.debug("Persisting CDC state jobId={} partitionId={} start={} end={} sizeBytes={}", new Object[]{state.jobId, state.partitionId, range.lowerEndpoint(), range.upperEndpoint(), state.buf.remaining()});
            this.sidecarCdcStats.capturePersistingCdcStateLength(state.buf.remaining());
            return new TimedFutureWrapper(this.cassandraClient.storeStateAsync(state.jobId, range, state.buf, state.timestamp));
        }
        catch (Throwable t) {
            LOGGER.error("Unexpected error persisting CDC state to Cassandra", t);
            this.sidecarCdcStats.capturePersistFailed(t);
            this.latestState.putIfAbsent(state.key(), state);
            return null;
        }
    }

    protected void flush() {
        this.persistToCassandra(true);
        this.flushActiveSafe();
    }

    protected void flushActiveSafe() {
        try {
            this.flushActive();
        }
        catch (ExecutionException e) {
            LOGGER.warn("Failed to flush active CDC state", ThrowableUtils.rootCause((Throwable)e));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    protected void flushActive() throws ExecutionException, InterruptedException {
        for (TimedFutureWrapper wrapper : this.activeFlush) {
            wrapper.await();
        }
    }

    protected static class TimedFutureWrapper {
        protected final List<ResultSetFuture> futures;
        protected final long startTimeNanos;

        protected TimedFutureWrapper(List<ResultSetFuture> futures) {
            this.futures = futures;
            this.startTimeNanos = System.nanoTime();
        }

        public void await() throws ExecutionException, InterruptedException {
            for (ResultSetFuture future : this.futures) {
                future.get();
            }
        }

        public boolean allDone() {
            return this.futures.stream().allMatch(Future::isDone);
        }
    }

    protected static class PersistWrapper
    implements Comparable<PersistWrapper> {
        final String jobId;
        final int partitionId;
        @Nullable
        final TokenRange tokenRange;
        final ByteBuffer buf;
        final long timestamp;

        protected PersistWrapper(String jobId, int partitionId, @Nullable TokenRange tokenRange, ByteBuffer buf, long timestamp) {
            this.jobId = jobId;
            this.partitionId = partitionId;
            this.tokenRange = tokenRange;
            this.buf = buf;
            this.timestamp = timestamp;
        }

        @Nullable
        public TokenRange tokenRange() {
            return this.tokenRange;
        }

        public Key key() {
            return new Key(this.jobId, this.tokenRange());
        }

        @Override
        public int compareTo(@NotNull PersistWrapper o) {
            return Long.compare(this.timestamp, o.timestamp);
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.tokenRange());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PersistWrapper other = (PersistWrapper)o;
            return this.jobId.equals(other.jobId) && Objects.equals(this.tokenRange(), other.tokenRange()) && this.buf.equals(other.buf);
        }

        public static PersistWrapper max(PersistWrapper w1, PersistWrapper w2) {
            if (w1 == null) {
                return w2;
            }
            if (w2 == null) {
                return w1;
            }
            return w1.compareTo(w2) > 0 ? w1 : w2;
        }

        protected static class Key {
            private final String jobId;
            private final TokenRange tokenRange;

            protected Key(String jobId, TokenRange tokenRange) {
                this.jobId = jobId;
                this.tokenRange = tokenRange;
            }

            public int hashCode() {
                return Objects.hash(this.jobId, this.tokenRange);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Key other = (Key)o;
                return this.jobId.equals(other.jobId) && Objects.equals(this.tokenRange, other.tokenRange);
            }
        }
    }
}

