/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics.testcontainer;

import com.adobe.testing.s3mock.testcontainers.S3MockContainer;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import io.vertx.junit5.VertxTestContext;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.cassandra.analytics.DataGenerationUtils;
import org.apache.cassandra.analytics.SparkTestUtils;
import org.apache.cassandra.analytics.testcontainer.BulkWriteS3CompatModeSimpleTest;
import org.apache.cassandra.analytics.testcontainer.CoordinatedWriteTestBase;
import org.apache.cassandra.analytics.testcontainer.LocalCoordinatedStorageTransportExtension;
import org.apache.cassandra.distributed.api.ConsistencyLevel;
import org.apache.cassandra.distributed.api.IInstance;
import org.apache.cassandra.sidecar.config.S3ClientConfiguration;
import org.apache.cassandra.sidecar.config.S3ProxyConfiguration;
import org.apache.cassandra.sidecar.config.yaml.S3ClientConfigurationImpl;
import org.apache.cassandra.sidecar.config.yaml.SidecarConfigurationImpl;
import org.apache.cassandra.sidecar.db.schema.SidecarSchema;
import org.apache.cassandra.sidecar.modules.SidecarModules;
import org.apache.cassandra.sidecar.server.Server;
import org.apache.cassandra.sidecar.testing.QualifiedName;
import org.apache.cassandra.sidecar.testing.SharedClusterIntegrationTestBase;
import org.apache.cassandra.testing.ClusterBuilderConfiguration;
import org.apache.cassandra.testing.IClusterExtension;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatedBulkWriteSimpleTest
extends CoordinatedWriteTestBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoordinatedBulkWriteSimpleTest.class);

    @Test
    void testCoordinatedWriteToTwoClusters() throws Exception {
        try (IClusterExtension cluster1 = this.classLoaderWrapper.loadCluster(this.testVersion.version(), this.clusterConfiguration());
             IClusterExtension cluster2 = this.classLoaderWrapper.loadCluster(this.testVersion.version(), this.clusterConfiguration());
             S3MockContainer s3 = new S3MockContainer("2.17.0").withInitialBuckets("sbw-bucket");){
            LOGGER.info("Both Cassandra clusters are up");
            s3.start();
            Assertions.assertThat((boolean)s3.isRunning()).isTrue();
            LOGGER.info("S3Mock started");
            QualifiedName tableName = new QualifiedName("ks", "coordinatedwrite");
            this.createSchema(tableName, cluster1, cluster2);
            LOGGER.info("Test schema created on both clusters");
            Server sidecar1 = this.startSidecarWithInstances((Iterable<? extends IInstance>)cluster1, s3);
            Server sidecar2 = this.startSidecarWithInstances((Iterable<? extends IInstance>)cluster2, s3);
            Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.SECONDS);
            LOGGER.info("Both Sidecars are up. sidecar1 port1: {}, sidecar2 port1: {}", (Object)sidecar1.actualPort(), (Object)sidecar2.actualPort());
            SparkSession spark = SparkSession.builder().config(this.sparkTestUtils.defaultSparkConf()).getOrCreate();
            Dataset<Row> df = DataGenerationUtils.generateCourseData(spark, 1000);
            String coordinatedConf = this.coordinatedWriteConfiguration((IClusterExtension<? extends IInstance>)cluster1, sidecar1, (IClusterExtension<? extends IInstance>)cluster2, sidecar2);
            ImmutableMap s3CompatOptions = ImmutableMap.of((Object)"data_transport", (Object)"S3_COMPAT", (Object)"data_transport_extension_class", (Object)LocalCoordinatedStorageTransportExtension.class.getCanonicalName(), (Object)"storage_client_endpoint_override", (Object)s3.getHttpEndpoint(), (Object)"coordinated_write_config", (Object)coordinatedConf);
            this.sparkTestUtils.coordinatedBulkWriterDataFrameWriter(df, tableName, (Map<String, String>)s3CompatOptions).save();
            List rows = df.collectAsList();
            this.sparkTestUtils.validateWrites(rows, this.queryAllData(cluster1, tableName, ConsistencyLevel.ALL));
            this.sparkTestUtils.validateWrites(rows, this.queryAllData(cluster2, tableName, ConsistencyLevel.ALL));
            this.stopSidecarServers(sidecar1, sidecar2);
        }
    }

    private void createSchema(QualifiedName tableName, IClusterExtension ... clusters) {
        String createKs = "CREATE KEYSPACE IF NOT EXISTS ks WITH REPLICATION = { 'class' : 'NetworkTopologyStrategy', 'replication_factor' : 3 };";
        String createTable = "CREATE TABLE IF NOT EXISTS " + String.valueOf(tableName) + " (id int, course text, marks int, PRIMARY KEY (id)) WITH read_repair='NONE';";
        for (IClusterExtension cluster : clusters) {
            cluster.schemaChangeIgnoringStoppedInstances(createKs);
            cluster.schemaChangeIgnoringStoppedInstances(createTable);
        }
    }

    private Server startSidecarWithInstances(Iterable<? extends IInstance> instances, S3MockContainer s3Mock) {
        VertxTestContext context = new VertxTestContext();
        Function<SidecarConfigurationImpl.Builder, SidecarConfigurationImpl.Builder> sidecarConfigurator = builder -> {
            BulkWriteS3CompatModeSimpleTest.S3MockProxyConfigurationImpl s3MockProxyConfiguration = new BulkWriteS3CompatModeSimpleTest.S3MockProxyConfigurationImpl(s3Mock.getHttpEndpoint());
            S3ClientConfigurationImpl s3ClientConfig = new S3ClientConfigurationImpl("s3-client", 4, S3ClientConfigurationImpl.DEFAULT_THREAD_KEEP_ALIVE, 0x500000, S3ClientConfigurationImpl.DEFAULT_API_CALL_TIMEOUT, (S3ProxyConfiguration)s3MockProxyConfiguration);
            builder.s3ClientConfiguration((S3ClientConfiguration)s3ClientConfig);
            return builder;
        };
        SharedClusterIntegrationTestBase.IntegrationTestModule testModule = new SharedClusterIntegrationTestBase.IntegrationTestModule(instances, this.classLoaderWrapper, this.mtlsTestHelper, this.dnsResolver, sidecarConfigurator);
        this.sidecarServerInjector = Guice.createInjector((Module[])new Module[]{Modules.override((Iterable)SidecarModules.all()).with(new Module[]{testModule})});
        Server sidecarServer = (Server)this.sidecarServerInjector.getInstance(Server.class);
        sidecarServer.start().onFailure(arg_0 -> ((VertxTestContext)context).failNow(arg_0));
        SidecarSchema sidecarSchema = (SidecarSchema)this.sidecarServerInjector.getInstance(SidecarSchema.class);
        for (int i = 0; i < 60; ++i) {
            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            if (!sidecarSchema.isInitialized()) continue;
            context.completeNow();
            return sidecarServer;
        }
        throw new AssertionError((Object)"Sidecar server failed to init schema");
    }

    private ClusterBuilderConfiguration clusterConfiguration() {
        ClusterBuilderConfiguration conf = new ClusterBuilderConfiguration();
        conf.additionalInstanceConfig(Map.of("storage_compatibility_mode", "NONE"));
        conf.nodesPerDc(3);
        conf.dcCount(1);
        return conf;
    }

    private String coordinatedWriteConfiguration(IClusterExtension<? extends IInstance> cluster1, Server sidecar1, IClusterExtension<? extends IInstance> cluster2, Server sidecar2) {
        String cluster1Instances = SparkTestUtils.sidecarInstancesOptionStream(cluster1, this.dnsResolver).map(hostname -> hostname + ":" + sidecar1.actualPort()).collect(Collectors.joining("\", \"", "\"", "\""));
        String cluster2Instances = SparkTestUtils.sidecarInstancesOptionStream(cluster2, this.dnsResolver).map(hostname -> hostname + ":" + sidecar2.actualPort()).collect(Collectors.joining("\",\"", "\"", "\""));
        return "{\"cluster1\":{\"sidecarContactPoints\":[" + cluster1Instances + "], \"localDc\":\"datacenter1\"},\"cluster2\":{\"sidecarContactPoints\":[" + cluster2Instances + "], \"localDc\":\"datacenter1\"}}";
    }

    private Object[][] queryAllData(IClusterExtension cluster, QualifiedName table, ConsistencyLevel consistencyLevel) {
        return cluster.getFirstRunningInstance().coordinator().execute(String.format("SELECT * FROM %s;", table), consistencyLevel, new Object[0]);
    }
}

