/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ArrayUtils {
    private ArrayUtils() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    public static <T> List<T> listOf(T ... values) {
        return Arrays.asList(values);
    }

    public static <T> Set<T> setOf(T ... values) {
        return new HashSet<T>(Arrays.asList(values));
    }

    public static Object[] retain(Object[] source, int index, int length) {
        Preconditions.checkArgument((source != null && 0 <= index && 0 <= length ? 1 : 0) != 0);
        Preconditions.checkArgument((index + length <= source.length ? 1 : 0) != 0, (Object)"Requested retain range exceed the source array!");
        Object[] result = new Object[length];
        if (length > 0) {
            System.arraycopy(source, index, result, 0, length);
        }
        return result;
    }

    public static <T> List<T> combine(List<T> ... lists) {
        ArrayList<T> result = new ArrayList<T>(Arrays.stream(lists).filter(Objects::nonNull).mapToInt(List::size).sum());
        for (List<T> list : lists) {
            if (list == null) continue;
            result.addAll(list);
        }
        return result;
    }

    public static <T> Stream<T> concatToStream(List<T> ... lists) {
        if (lists.length == 0) {
            return Stream.empty();
        }
        Stream curr = lists[0].stream();
        for (int i = 1; i < lists.length; ++i) {
            curr = Stream.concat(curr, lists[i].stream());
        }
        return curr;
    }

    public static <T> List<T> orElse(@Nullable List<T> v1, @NotNull List<T> v2) {
        return v1 == null ? v2 : v1;
    }
}

