/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.bridge;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.cassandra.analytics.reader.common.IndexIterator;
import org.apache.cassandra.analytics.stats.Stats;
import org.apache.cassandra.bridge.BloomFilter;
import org.apache.cassandra.bridge.BridgeInitializationParameters;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.CassandraTypesImplementation;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.bridge.SSTableSummary;
import org.apache.cassandra.bridge.SSTableWriter;
import org.apache.cassandra.bridge.SSTableWriterImplementation;
import org.apache.cassandra.bridge.TokenRange;
import org.apache.cassandra.bridge.Tokenizer;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Murmur3Partitioner;
import org.apache.cassandra.dht.RandomPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.compress.ICompressor;
import org.apache.cassandra.io.compress.LZ4Compressor;
import org.apache.cassandra.io.sstable.CQLSSTableWriter;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.SSTableTombstoneWriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.spark.data.CassandraTypes;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.CqlTable;
import org.apache.cassandra.spark.data.CqlType;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.SSTable;
import org.apache.cassandra.spark.data.SSTablesSupplier;
import org.apache.cassandra.spark.data.TypeConverter;
import org.apache.cassandra.spark.data.complex.AbstractCqlTuple;
import org.apache.cassandra.spark.data.complex.CqlTuple;
import org.apache.cassandra.spark.data.complex.CqlUdt;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.reader.BigIndexReader;
import org.apache.cassandra.spark.reader.CompactionStreamScanner;
import org.apache.cassandra.spark.reader.IndexEntry;
import org.apache.cassandra.spark.reader.ReaderUtils;
import org.apache.cassandra.spark.reader.RowData;
import org.apache.cassandra.spark.reader.SchemaBuilder;
import org.apache.cassandra.spark.reader.StreamScanner;
import org.apache.cassandra.spark.reader.SummaryDbUtils;
import org.apache.cassandra.spark.sparksql.CellIterator;
import org.apache.cassandra.spark.sparksql.RowIterator;
import org.apache.cassandra.spark.sparksql.filters.PartitionKeyFilter;
import org.apache.cassandra.spark.sparksql.filters.PruneColumnFilter;
import org.apache.cassandra.spark.sparksql.filters.SparkRangeFilter;
import org.apache.cassandra.spark.utils.Pair;
import org.apache.cassandra.spark.utils.SparkClassLoaderOverride;
import org.apache.cassandra.spark.utils.TimeProvider;
import org.apache.cassandra.tools.JsonTransformer;
import org.apache.cassandra.tools.Util;
import org.apache.cassandra.util.CompressionUtil;
import org.apache.cassandra.util.IntWrapper;
import org.apache.cassandra.utils.CompressionUtilImplementation;
import org.apache.cassandra.utils.IFilter;
import org.apache.cassandra.utils.TokenUtils;
import org.apache.cassandra.utils.UUIDGen;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraBridgeImplementation
extends CassandraBridge {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraBridgeImplementation.class);
    private final Map<Class<?>, Serializer<?>> kryoSerializers = new LinkedHashMap();
    private static final ICompressor COMPRESSOR;

    public static synchronized void setup() {
        CassandraTypesImplementation.setup((BridgeInitializationParameters)BridgeInitializationParameters.fromEnvironment());
    }

    public CassandraBridgeImplementation() {
        this.kryoSerializers.put(CqlField.class, (Serializer<?>)new CqlField.Serializer(this.cassandraTypes()));
        this.kryoSerializers.put(CqlTable.class, (Serializer<?>)new CqlTable.Serializer(this.cassandraTypes()));
        this.kryoSerializers.put(CqlUdt.class, (Serializer<?>)new CqlUdt.Serializer(this.cassandraTypes()));
    }

    public CassandraTypes cassandraTypes() {
        return CassandraTypesImplementation.INSTANCE;
    }

    public AbstractMap.SimpleEntry<ByteBuffer, BigInteger> getPartitionKey(@NotNull CqlTable table, @NotNull Partitioner partitioner, @NotNull List<String> keys) {
        Preconditions.checkArgument((table.partitionKeys().size() > 0 ? 1 : 0) != 0);
        ByteBuffer partitionKey = CassandraBridgeImplementation.buildPartitionKey(table, keys);
        BigInteger partitionKeyTokenValue = this.hash(partitioner, partitionKey);
        return new AbstractMap.SimpleEntry<ByteBuffer, BigInteger>(partitionKey, partitionKeyTokenValue);
    }

    @VisibleForTesting
    public static ByteBuffer buildPartitionKey(@NotNull CqlTable table, @NotNull List<String> keys) {
        List<AbstractType<?>> partitionKeyColumnTypes = CassandraBridgeImplementation.partitionKeyColumnTypes(table);
        if (table.partitionKeys().size() == 1) {
            return partitionKeyColumnTypes.get(0).fromString(keys.get(0));
        }
        Object[] buffers = new ByteBuffer[keys.size()];
        for (int index = 0; index < buffers.length; ++index) {
            buffers[index] = partitionKeyColumnTypes.get(index).fromString(keys.get(index));
        }
        return (ByteBuffer)CompositeType.build((ValueAccessor)ByteBufferAccessor.instance, (Object[])buffers);
    }

    @VisibleForTesting
    public static List<AbstractType<?>> partitionKeyColumnTypes(@NotNull CqlTable table) {
        return table.partitionKeys().stream().map(CqlField::type).map(type -> (CqlType)type).map(type -> type.dataType(true)).collect(Collectors.toList());
    }

    public StreamScanner<RowData> getCompactionScanner(@NotNull CqlTable table, @NotNull Partitioner partitioner, @NotNull SSTablesSupplier ssTables, @Nullable SparkRangeFilter sparkRangeFilter, @NotNull Collection<PartitionKeyFilter> partitionKeyFilters, @Nullable PruneColumnFilter columnFilter, @NotNull TimeProvider timeProvider, boolean readIndexOffset, boolean useIncrementalRepair, @NotNull Stats stats) {
        SchemaBuilder schemaBuilder = new SchemaBuilder(table, partitioner);
        TableMetadata metadata = schemaBuilder.tableMetaData();
        return new CompactionStreamScanner(metadata, partitioner, timeProvider, ssTables.openAll((ssTable, isRepairPrimary) -> org.apache.cassandra.spark.reader.SSTableReader.builder(metadata, ssTable).withSparkRangeFilter(sparkRangeFilter).withPartitionKeyFilters(partitionKeyFilters).withColumnFilter(columnFilter).withReadIndexOffset(readIndexOffset).withStats(stats).useIncrementalRepair(useIncrementalRepair).isRepairPrimary(isRepairPrimary).build()));
    }

    public StreamScanner<IndexEntry> getPartitionSizeIterator(@NotNull CqlTable table, @NotNull Partitioner partitioner, @NotNull SSTablesSupplier ssTables, @Nullable SparkRangeFilter rangeFilter, @NotNull TimeProvider timeProvider, @NotNull Stats stats, @NotNull ExecutorService executor) {
        SchemaBuilder schemaBuilder = new SchemaBuilder(table, partitioner);
        TableMetadata metadata = schemaBuilder.tableMetaData();
        return new IndexIterator(ssTables, stats, (ssTable, isRepairPrimary, consumer) -> new BigIndexReader(ssTable, metadata, rangeFilter, stats, consumer));
    }

    public CassandraVersion getVersion() {
        return CassandraVersion.FOURZERO;
    }

    public BigInteger hash(Partitioner partitioner, ByteBuffer key) {
        switch (partitioner) {
            case RandomPartitioner: {
                return (BigInteger)RandomPartitioner.instance.getToken(key).getTokenValue();
            }
            case Murmur3Partitioner: {
                return BigInteger.valueOf((Long)Murmur3Partitioner.instance.getToken(key).getTokenValue());
            }
        }
        throw new UnsupportedOperationException("Unexpected partitioner: " + String.valueOf(partitioner));
    }

    public UUID getTimeUUID() {
        return UUIDGen.getTimeUUID();
    }

    public CqlTable buildSchema(String createStatement, String keyspace, ReplicationFactor replicationFactor, Partitioner partitioner, Set<String> udts, @Nullable UUID tableId, int indexCount, boolean enableCdc) {
        return new SchemaBuilder(createStatement, keyspace, replicationFactor, partitioner, cassandraTypes -> udts, tableId, indexCount, enableCdc).build();
    }

    public CompressionUtil compressionUtil() {
        return CompressionUtilImplementation.INSTANCE;
    }

    public long lastRepairTime(String keyspace, String table, SSTable ssTable) throws IOException {
        Map<MetadataType, MetadataComponent> componentMap = ReaderUtils.deserializeStatsMetadata(keyspace, table, ssTable, EnumSet.of(MetadataType.STATS));
        StatsMetadata statsMetadata = (StatsMetadata)componentMap.get(MetadataType.STATS);
        if (statsMetadata == null) {
            throw new IllegalStateException("Could not read StatsMetadata");
        }
        return statsMetadata.repairedAt;
    }

    public List<Boolean> overlaps(SSTable ssTable, Partitioner partitioner, int minIndexInterval, int maxIndexInterval, List<TokenRange> ranges) {
        SSTableSummary summary = this.getSSTableSummary(partitioner, ssTable, minIndexInterval, maxIndexInterval);
        TokenRange sstableRange = TokenRange.closed((BigInteger)summary.firstToken, (BigInteger)summary.lastToken);
        return ranges.stream().map(range -> range.isConnected(sstableRange)).collect(Collectors.toList());
    }

    public Tokenizer tokenizer(Partitioner partitioner) {
        IPartitioner iPartitioner = CassandraBridgeImplementation.getPartitioner(partitioner);
        return partitionKey -> {
            DecoratedKey decoratedKey = iPartitioner.decorateKey(partitionKey);
            return TokenUtils.tokenToBigInteger((Token)decoratedKey.getToken());
        };
    }

    public List<ByteBuffer> encodePartitionKeys(Partitioner partitioner, String keyspace, String createTableStmt, List<List<String>> keys) {
        CqlTable table = new SchemaBuilder(createTableStmt, keyspace, ReplicationFactor.simpleStrategy((int)1), partitioner).build();
        return keys.stream().map(key -> CassandraBridgeImplementation.buildPartitionKey(table, key)).collect(Collectors.toList());
    }

    public BloomFilter openBloomFilter(Partitioner partitioner, String keyspace, String table, SSTable ssTable) throws IOException {
        IPartitioner iPartitioner = CassandraBridgeImplementation.getPartitioner(partitioner);
        Descriptor descriptor = ReaderUtils.constructDescriptor(keyspace, table, ssTable);
        org.apache.cassandra.utils.BloomFilter filter = this.openBloomFilter(descriptor, ssTable);
        return partitionKey -> {
            DecoratedKey decoratedKey = iPartitioner.decorateKey(partitionKey);
            return filter.isPresent((IFilter.FilterKey)decoratedKey);
        };
    }

    private org.apache.cassandra.utils.BloomFilter openBloomFilter(Descriptor descriptor, SSTable ssTable) throws IOException {
        return ReaderUtils.readFilter(ssTable, descriptor);
    }

    public List<Boolean> contains(Partitioner partitioner, String keyspace, String table, SSTable ssTable, List<ByteBuffer> partitionKeys) throws IOException {
        if (partitionKeys.isEmpty()) {
            return Collections.emptyList();
        }
        IPartitioner iPartitioner = CassandraBridgeImplementation.getPartitioner(partitioner);
        List decoratedKeys = partitionKeys.stream().map(arg_0 -> ((IPartitioner)iPartitioner).decorateKey(arg_0)).collect(Collectors.toList());
        Descriptor descriptor = ReaderUtils.constructDescriptor(keyspace, table, ssTable);
        org.apache.cassandra.utils.BloomFilter filter = this.openBloomFilter(descriptor, ssTable);
        List<Boolean> result = decoratedKeys.stream().map(arg_0 -> ((org.apache.cassandra.utils.BloomFilter)filter).isPresent(arg_0)).collect(Collectors.toList());
        if (result.stream().noneMatch(found -> found)) {
            return result;
        }
        List sortedByTokens = IntStream.range(0, decoratedKeys.size()).mapToObj(idx -> {
            DecoratedKey key = (DecoratedKey)decoratedKeys.get(idx);
            BigInteger token = TokenUtils.tokenToBigInteger((Token)key.getToken());
            return Pair.of((Object)token, (Object)idx);
        }).sorted(Comparator.comparing(Pair::getLeft)).collect(Collectors.toList());
        try (InputStream primaryIndex = ssTable.openPrimaryIndexStream();){
            if (primaryIndex == null) {
                throw new IOException("Could not read Index.db file");
            }
            IntWrapper position = new IntWrapper();
            ReaderUtils.readPrimaryIndex(primaryIndex, buffer -> {
                DecoratedKey key = iPartitioner.decorateKey(buffer);
                BigInteger token = TokenUtils.tokenToBigInteger((Token)key.getToken());
                Pair current = (Pair)sortedByTokens.get(position.value);
                int compare = token.compareTo((BigInteger)current.getLeft());
                while (compare > 0) {
                    result.set((Integer)current.getRight(), false);
                    ++position.value;
                    if (position.value >= decoratedKeys.size()) {
                        return true;
                    }
                    current = (Pair)sortedByTokens.get(position.value);
                    compare = token.compareTo((BigInteger)current.getLeft());
                }
                ByteBuffer currentKey = (ByteBuffer)partitionKeys.get((Integer)current.getRight());
                if (compare == 0 && buffer.equals(currentKey)) {
                    result.set((Integer)current.getRight(), true);
                    ++position.value;
                }
                return position.value >= decoratedKeys.size();
            });
            IntStream.range(position.value, sortedByTokens.size()).forEach(i -> result.set((Integer)((Pair)sortedByTokens.get(i)).getRight(), false));
        }
        return result;
    }

    public void readPartitionKeys(Partitioner partitioner, String keyspace, String createStmt, SSTablesSupplier ssTables, @Nullable TokenRange tokenRange, @Nullable List<ByteBuffer> partitionKeys, @Nullable String[] requiredColumns, Consumer<Map<String, Object>> rowConsumer) throws IOException {
        IPartitioner iPartitioner = CassandraBridgeImplementation.getPartitioner(partitioner);
        SchemaBuilder schemaBuilder = new SchemaBuilder(createStmt, keyspace, ReplicationFactor.simpleStrategy((int)1), partitioner);
        TableMetadata metadata = schemaBuilder.tableMetaData();
        CqlTable table = schemaBuilder.build();
        List tokens = partitionKeys == null ? Collections.emptyList() : this.toTokens(partitioner, partitionKeys);
        List partitionKeyFilters = partitionKeys == null ? Collections.emptyList() : IntStream.range(0, partitionKeys.size()).mapToObj(i -> PartitionKeyFilter.create((ByteBuffer)((ByteBuffer)partitionKeys.get(i)), (BigInteger)((BigInteger)tokens.get(i)))).sorted().collect(Collectors.toList());
        try (CellIterator it = new CellIterator(0, table, (Stats)Stats.DoNothingStats.INSTANCE, TypeConverter.IDENTITY, partitionKeyFilters, t -> PruneColumnFilter.of((String[])requiredColumns), (partitionId1, partitionKeyFilters1, columnFilter1) -> new CompactionStreamScanner(metadata, partitioner, TimeProvider.DEFAULT, ssTables.openAll((ssTable, isRepairPrimary) -> org.apache.cassandra.spark.reader.SSTableReader.builder(metadata, ssTable).withPartitionKeyFilters(partitionKeyFilters1).build()))){

            public boolean isInPartition(int partitionId, BigInteger token, ByteBuffer partitionKey) {
                return true;
            }

            public boolean equals(CqlField field, Object obj1, Object obj2) {
                return Objects.equals(obj1, obj2);
            }
        };){
            RowIterator rowIterator = RowIterator.rowMapIterator((CellIterator)it, (Stats)Stats.DoNothingStats.INSTANCE, (String[])requiredColumns);
            while (rowIterator.next()) {
                rowConsumer.accept((Map)rowIterator.get());
            }
        }
    }

    public synchronized void writeSSTable(Partitioner partitioner, String keyspace, String table, Path directory, String createStatement, String insertStatement, String updateStatement, boolean upsert, Set<CqlField.CqlUdt> udts, Consumer<CassandraBridge.Writer> writer) {
        CQLSSTableWriter.Builder builder = CQLSSTableWriter.builder().inDirectory(directory.toFile()).forTable(createStatement).withPartitioner(CassandraBridgeImplementation.getPartitioner(partitioner)).using(upsert ? updateStatement : insertStatement).withBufferSizeInMB(128);
        for (CqlField.CqlUdt udt : udts) {
            String statement = udt.createStatement(this.cassandraTypes(), keyspace);
            builder.withType(statement);
        }
        try (CQLSSTableWriter ssTable = builder.build();){
            writer.accept(values -> {
                try {
                    ssTable.addRow(values);
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
            });
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static IPartitioner getPartitioner(Partitioner partitioner) {
        return CassandraTypesImplementation.getPartitioner((Partitioner)partitioner);
    }

    public SSTableWriter getSSTableWriter(String inDirectory, String partitioner, String createStatement, String insertStatement, @NotNull Set<String> userDefinedTypeStatements, int bufferSizeMB) {
        return new SSTableWriterImplementation(inDirectory, partitioner, createStatement, insertStatement, userDefinedTypeStatements, bufferSizeMB);
    }

    public SSTableSummary getSSTableSummary(@NotNull String keyspace, @NotNull String table, @NotNull SSTable ssTable) {
        TableMetadata metadata = Schema.instance.getTableMetadata(keyspace, table);
        if (metadata == null) {
            throw new RuntimeException("Could not create table metadata needed for reading SSTable summaries for keyspace: " + keyspace);
        }
        return this.getSSTableSummary(metadata.partitioner, ssTable, metadata.params.minIndexInterval, metadata.params.maxIndexInterval);
    }

    public SSTableSummary getSSTableSummary(@NotNull Partitioner partitioner, @NotNull SSTable ssTable, int minIndexInterval, int maxIndexInterval) {
        return this.getSSTableSummary(CassandraBridgeImplementation.getPartitioner(partitioner), ssTable, minIndexInterval, maxIndexInterval);
    }

    protected SSTableSummary getSSTableSummary(@NotNull IPartitioner partitioner, @NotNull SSTable ssTable, int minIndexInterval, int maxIndexInterval) {
        try {
            Pair<DecoratedKey, DecoratedKey> keys;
            SummaryDbUtils.Summary summary = SummaryDbUtils.readSummary(ssTable, partitioner, minIndexInterval, maxIndexInterval);
            Pair<DecoratedKey, DecoratedKey> pair = keys = summary == null ? null : Pair.of((Object)summary.first(), (Object)summary.last());
            if (summary == null) {
                keys = ReaderUtils.keysFromIndex(partitioner, ssTable);
            }
            if (keys == null) {
                throw new RuntimeException("Could not load SSTable first or last tokens for SSTable: " + ssTable.getDataFileName());
            }
            DecoratedKey first = (DecoratedKey)keys.left;
            DecoratedKey last = (DecoratedKey)keys.right;
            BigInteger firstToken = ReaderUtils.tokenToBigInteger((Token)first.getToken());
            BigInteger lastToken = ReaderUtils.tokenToBigInteger((Token)last.getToken());
            return new SSTableSummary(firstToken, lastToken, this.getSSTablePrefix(ssTable.getDataFileName()));
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    private String getSSTablePrefix(String dataFileName) {
        return dataFileName.substring(0, dataFileName.lastIndexOf(45) + 1);
    }

    @VisibleForTesting
    public void writeTombstoneSSTable(Partitioner partitioner, Path directory, String createStatement, String deleteStatement, Consumer<CassandraBridge.Writer> consumer) {
        try (SSTableTombstoneWriter writer = SSTableTombstoneWriter.builder().inDirectory(directory.toFile()).forTable(createStatement).withPartitioner(CassandraBridgeImplementation.getPartitioner(partitioner)).using(deleteStatement).withBufferSizeInMB(128).build();){
            consumer.accept(values -> {
                try {
                    writer.addRow(values);
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
            });
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    @VisibleForTesting
    public void sstableToJson(Path dataDbFile, OutputStream output) throws FileNotFoundException {
        if (!Files.exists(dataDbFile, new LinkOption[0])) {
            throw new FileNotFoundException("Cannot find file " + String.valueOf(dataDbFile.toAbsolutePath()));
        }
        if (!Descriptor.isValidFile((File)dataDbFile.toFile())) {
            throw new RuntimeException("Invalid sstable file");
        }
        Descriptor desc = Descriptor.fromFilename((String)dataDbFile.toAbsolutePath().toString());
        try {
            TableMetadataRef metadata = TableMetadataRef.forOfflineTools((TableMetadata)Util.metadataFromSSTable((Descriptor)desc));
            SSTableReader ssTable = SSTableReader.openNoValidation((Descriptor)desc, (TableMetadataRef)metadata);
            ISSTableScanner currentScanner = ssTable.getScanner();
            Stream partitions = Util.iterToStream((Iterator)currentScanner);
            JsonTransformer.toJson((ISSTableScanner)currentScanner, (Stream)partitions, (boolean)false, (TableMetadata)metadata.get(), (OutputStream)output);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    @VisibleForTesting
    public Object toTupleValue(CqlField.CqlTuple type, Object[] values) {
        return CqlTuple.toTupleValue((CassandraVersion)this.getVersion(), (AbstractCqlTuple)((CqlTuple)type), (Object)values);
    }

    @VisibleForTesting
    public Object toUserTypeValue(CqlField.CqlUdt type, Map<String, Object> values) {
        return CqlUdt.toUserTypeValue((CassandraVersion)this.getVersion(), (CqlUdt)((CqlUdt)type), values);
    }

    public ByteBuffer compress(byte[] bytes) throws IOException {
        ByteBuffer input = COMPRESSOR.preferredBufferType().allocate(bytes.length);
        input.put(bytes);
        input.flip();
        return this.compress(input);
    }

    public ByteBuffer compress(ByteBuffer input) throws IOException {
        int length = input.remaining();
        ByteBuffer output = COMPRESSOR.preferredBufferType().allocate(4 + COMPRESSOR.initialCompressedBufferLength(length));
        output.putInt(length);
        COMPRESSOR.compress(input, output);
        output.flip();
        return output;
    }

    public ByteBuffer uncompress(byte[] bytes) throws IOException {
        ByteBuffer input = COMPRESSOR.preferredBufferType().allocate(bytes.length);
        input.put(bytes);
        input.flip();
        return this.uncompress(input);
    }

    public ByteBuffer uncompress(ByteBuffer input) throws IOException {
        ByteBuffer output = COMPRESSOR.preferredBufferType().allocate(input.getInt());
        COMPRESSOR.uncompress(input, output);
        output.flip();
        return output;
    }

    public void kryoRegister(Kryo kryo) {
        this.kryoSerializers.forEach((arg_0, arg_1) -> ((Kryo)kryo).register(arg_0, arg_1));
    }

    public void javaSerialize(ObjectOutputStream out, Serializable object) {
        try {
            out.writeObject(object);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T javaDeserialize(ObjectInputStream in, Class<T> type) {
        try (SparkClassLoaderOverride override = new SparkClassLoaderOverride(in, ((Object)((Object)this)).getClass().getClassLoader());){
            T t = type.cast(in.readObject());
            return t;
        }
        catch (IOException | ClassNotFoundException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static String baseFilename(Descriptor descriptor) {
        String baseFileNameWithDirectory = descriptor.baseFilename();
        return baseFileNameWithDirectory.substring(baseFileNameWithDirectory.lastIndexOf(File.separatorChar) + 1);
    }

    static {
        CassandraBridgeImplementation.setup();
        COMPRESSOR = LZ4Compressor.create(Collections.emptyMap());
    }
}

