/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.transports.storage;

import o.a.c.sidecar.client.shaded.common.data.RestoreJobSecrets;
import org.apache.cassandra.spark.transports.storage.StorageCredentialPair;
import org.apache.cassandra.spark.transports.storage.StorageCredentials;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class StorageCredentialPairTest {
    StorageCredentialPairTest() {
    }

    @Test
    void testToRestoreJobSecrets() {
        StorageCredentialPair pair = this.makePair(1);
        RestoreJobSecrets secrets = pair.toRestoreJobSecrets();
        Assertions.assertThat((String)secrets.readCredentials().accessKeyId()).isEqualTo("readAccessKey1");
        Assertions.assertThat((String)secrets.readCredentials().secretAccessKey()).isEqualTo("readSecretKey1");
        Assertions.assertThat((String)secrets.readCredentials().sessionToken()).isEqualTo("readSession1");
        Assertions.assertThat((String)secrets.readCredentials().region()).isEqualTo("readRegion1");
        Assertions.assertThat((String)secrets.writeCredentials().accessKeyId()).isEqualTo("writeAccessKey1");
        Assertions.assertThat((String)secrets.writeCredentials().secretAccessKey()).isEqualTo("writeSecretKey1");
        Assertions.assertThat((String)secrets.writeCredentials().sessionToken()).isEqualTo("writeSession1");
        Assertions.assertThat((String)secrets.writeCredentials().region()).isEqualTo("writeRegion1");
    }

    @Test
    void testHashcodeAndEquals() {
        StorageCredentialPair pair1 = this.makePair(1);
        StorageCredentialPair pair2 = this.makePair(1);
        Assertions.assertThat((int)pair1.hashCode()).isEqualTo(pair2.hashCode());
        Assertions.assertThat((Object)pair1).isEqualTo((Object)pair2);
        pair2 = this.makePair(2);
        Assertions.assertThat((int)pair1.hashCode()).isNotEqualTo(pair2.hashCode());
        Assertions.assertThat((Object)pair1).isNotEqualTo((Object)pair2);
    }

    private StorageCredentialPair makePair(int id) {
        return new StorageCredentialPair("writeRegion" + id, new StorageCredentials("writeAccessKey" + id, "writeSecretKey" + id, "writeSession" + id), "readRegion" + id, new StorageCredentials("readAccessKey" + id, "readSecretKey" + id, "readSession" + id));
    }
}

