/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.endtoend;

import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.spark.TestUtils;
import org.apache.cassandra.spark.Tester;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.utils.RandomUtils;
import org.apache.cassandra.spark.utils.test.TestSchema;
import org.apache.spark.sql.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.quicktheories.QuickTheory;
import org.quicktheories.generators.SourceDSL;

@Tag(value="Sequential")
public class TombstoneTests {
    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testPartitionTombstoneInt(CassandraBridge bridge) {
        int numRows = 100;
        int numColumns = 10;
        QuickTheory.qt().withExamples(20).forAll(SourceDSL.integers().between(0, numRows - 2)).checkAssert(deleteRangeStart -> {
            assert (0 <= deleteRangeStart && deleteRangeStart < numRows);
            int deleteRangeEnd = deleteRangeStart + RandomUtils.RANDOM.nextInt(numRows - deleteRangeStart - 1) + 1;
            assert (deleteRangeStart < deleteRangeEnd && deleteRangeEnd < numRows);
            Tester.builder(TestSchema.basicBuilder((CassandraBridge)bridge).withDeleteFields(new String[]{"a ="})).withVersions(TestUtils.tombstoneTestableVersions()).dontWriteRandomData().withSSTableWriter(writer -> {
                for (int row = 0; row < numRows; ++row) {
                    for (int column = 0; column < numColumns; ++column) {
                        writer.write(new Object[]{row, column, column});
                    }
                }
            }).withTombstoneWriter(writer -> {
                for (int row = deleteRangeStart.intValue(); row < deleteRangeEnd; ++row) {
                    writer.write(new Object[]{row});
                }
            }).dontCheckNumSSTables().withCheck(dataset -> {
                int count = 0;
                for (Row row : dataset.collectAsList()) {
                    int value = row.getInt(0);
                    Assertions.assertThat((int)value).isBetween(Integer.valueOf(0), Integer.valueOf(numRows - 1));
                    Assertions.assertThat((value < deleteRangeStart || value >= deleteRangeEnd ? 1 : 0) != 0).isTrue();
                    ++count;
                }
                Assertions.assertThat((int)count).isEqualTo((numRows - (deleteRangeEnd - deleteRangeStart)) * numColumns);
            }).run(bridge.getVersion());
        });
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testRowTombstoneInt(CassandraBridge bridge) {
        int numRows = 100;
        int numColumns = 10;
        QuickTheory.qt().withExamples(20).forAll(SourceDSL.integers().between(0, numColumns - 1)).checkAssert(colNum -> Tester.builder(TestSchema.basicBuilder((CassandraBridge)bridge).withDeleteFields(new String[]{"a =", "b ="})).withVersions(TestUtils.tombstoneTestableVersions()).dontWriteRandomData().withSSTableWriter(writer -> {
            for (int row = 0; row < numRows; ++row) {
                for (int column = 0; column < numColumns; ++column) {
                    writer.write(new Object[]{row, column, column});
                }
            }
        }).withTombstoneWriter(writer -> {
            for (int row = 0; row < numRows; ++row) {
                writer.write(new Object[]{row, colNum});
            }
        }).dontCheckNumSSTables().withCheck(dataset -> {
            int count = 0;
            for (Row row : dataset.collectAsList()) {
                int value = row.getInt(0);
                Assertions.assertThat((int)row.getInt(0)).isBetween(Integer.valueOf(0), Integer.valueOf(numRows - 1));
                Assertions.assertThat((int)row.getInt(1)).isNotEqualTo(colNum);
                Assertions.assertThat((Object)row.get(2)).isEqualTo(row.get(1));
                ++count;
            }
            Assertions.assertThat((int)count).isEqualTo(numRows * (numColumns - 1));
        }).run(bridge.getVersion()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testRangeTombstoneInt(CassandraBridge bridge) {
        int numRows = 10;
        int numColumns = 128;
        QuickTheory.qt().withExamples(10).forAll(SourceDSL.integers().between(0, numColumns - 1)).checkAssert(startBound -> {
            Assertions.assertThat((Integer)startBound).isLessThan(numColumns);
            int endBound = startBound + RandomUtils.RANDOM.nextInt(numColumns - startBound);
            Assertions.assertThat((int)endBound).isBetween(startBound, Integer.valueOf(numColumns));
            int numTombstones = endBound - startBound;
            Tester.builder(TestSchema.basicBuilder((CassandraBridge)bridge).withDeleteFields(new String[]{"a =", "b >=", "b <"})).withVersions(TestUtils.tombstoneTestableVersions()).dontWriteRandomData().withSSTableWriter(writer -> {
                for (int row = 0; row < numRows; ++row) {
                    for (int column = 0; column < numColumns; ++column) {
                        writer.write(new Object[]{row, column, column});
                    }
                }
            }).withTombstoneWriter(writer -> {
                for (int row = 0; row < numRows; ++row) {
                    writer.write(new Object[]{row, startBound, endBound});
                }
            }).dontCheckNumSSTables().withCheck(dataset -> {
                int count = 0;
                for (Row row : dataset.collectAsList()) {
                    int value = row.getInt(1);
                    Assertions.assertThat((int)row.getInt(2)).isEqualTo(value);
                    Assertions.assertThat((int)value).isLessThanOrEqualTo(numColumns);
                    Assertions.assertThat((value < startBound || value >= endBound ? 1 : 0) != 0).isTrue();
                    ++count;
                }
                Assertions.assertThat((int)count).isEqualTo(numRows * (numColumns - numTombstones));
            }).run(bridge.getVersion());
        });
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testRangeTombstoneString(CassandraBridge bridge) {
        int numRows = 10;
        int numColumns = 128;
        QuickTheory.qt().withExamples(10).forAll(SourceDSL.characters().ascii()).checkAssert(startBound -> {
            Assertions.assertThat((int)startBound.charValue()).isLessThanOrEqualTo(numColumns);
            char endBound = (char)(startBound.charValue() + RandomUtils.RANDOM.nextInt(numColumns - startBound.charValue()));
            Assertions.assertThat((char)endBound).isBetween((Comparable)startBound, (Comparable)Character.valueOf((char)numColumns));
            int numTombstones = endBound - startBound.charValue();
            Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.aInt()).withClusteringKey("b", (CqlField.CqlType)bridge.text()).withColumn("c", (CqlField.CqlType)bridge.aInt()).withDeleteFields(new String[]{"a =", "b >=", "b <"})).withVersions(TestUtils.tombstoneTestableVersions()).dontWriteRandomData().withSSTableWriter(writer -> {
                for (int row = 0; row < numRows; ++row) {
                    for (int column = 0; column < numColumns; ++column) {
                        String value = String.valueOf((char)column);
                        writer.write(new Object[]{row, value, column});
                    }
                }
            }).withTombstoneWriter(writer -> {
                for (int row = 0; row < numRows; ++row) {
                    writer.write(new Object[]{row, startBound.toString(), Character.toString(endBound)});
                }
            }).dontCheckNumSSTables().withCheck(dataset -> {
                int count = 0;
                for (Row row : dataset.collectAsList()) {
                    char character = row.getString(1).charAt(0);
                    Assertions.assertThat((int)character).isLessThanOrEqualTo(numColumns);
                    Assertions.assertThat((character < startBound.charValue() || character >= endBound ? 1 : 0) != 0).isTrue();
                    ++count;
                }
                Assertions.assertThat((int)count).isEqualTo(numRows * (numColumns - numTombstones));
            }).run(bridge.getVersion());
        });
    }
}

